
/* math.q: mathematical functions
   01-10-1993 AG, revised 10-19-1993, 12-01-1999 AG */

/* This file is part of the Q programming system.

   The Q programming system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   The Q programming system is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Trigonometric functions: */

public asin X, acos X, tan X;

asin X:Num	= atan2 X (sqrt (1-X*X))
			if (X<=1) and (X>=-1);
			
acos X:Num	= atan2 (sqrt (1-X*X)) X
			if (X<=1) and (X>=-1);
			
tan X:Num	= sin X / cos X
			if cos X<>0;

/* Base 2 and 10 logarithms: */

public lg X, log X;

lg X:Num	= ln X / ln 2;
log X:Num	= ln X / ln 10;

/* Hyperbolic functions: */

public sinh X, cosh X, tanh X;

sinh X:Num	= (exp X - exp (-X))/2;
cosh X:Num	= (exp X + exp (-X))/2;
tanh X:Num	= (exp X - exp (-X))/(exp X + exp (-X));

public asinh X, acosh X, atanh X;

asinh X:Num	= ln (X + sqrt (X*X + 1));
acosh X:Num	= ln (X + sqrt (X*X - 1))
			if X>=1;
atanh X:Num	= ln ((1 + X) / (1 - X)) / 2
			if (X<1) and (X>-1);
