
/* stddecl.q: shared declarations of the stdtypes modules 03-02-02,
   11-09-02, 02-18-03 AG */

/* This file is part of the Q programming system.

   The Q programming system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   The Q programming system is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

include stdlib;

/* Overloaded operations used by various stdtypes modules: */

public stdlib::null A;		// tests whether A is empty
public member A X;		// tests whether A contains X
public ::list A as members;	// list the values stored in A
public list2 A;			// list members in 2D array
public stddecl::list2 A as members2; // alias for backward compatibility
public keys A;			// list the keys stored in A
public vals A;			// list the corresponding values

public first A, stdlib::last A;	// first and last member of A
public rmfirst A, rmlast A;	// remove first and last member from A
public insert A X;		// insert X into A
public stdlib::append A X;	// append X to the end of A
public delete A X;		// remove X from A
public update A K X;		// replace member K of A by X
