/*

cqc.h Connectix QuickCam hardware interface.

Copyright (C) 1996, 1997 Alex Belits

This software contains ideas and modified parts from qcam,
written by Scott Laird.

Copyright (C) 1996 by Scott Laird

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL SCOTT LAIRD OR ALEX BELITS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#define QCPORT0                      0x3bc
#define QCPORT1                      0x378
#define QCPORT2                      0x278

#define DEFAULTCONFIGFILENAME        "/usr/local/etc/qcam.conf"

#define SCAN_PRIORITY                -20

#define QCAM_ALARM_TIME              10

#define QCAM_DEFAULT_SPEED           2

#define QCAM_VER_COLOR               0x10

/* Commands */

#define QCAM_CMD_SENDVFRAME          7  /*0x07*/
#define QCAM_CMD_SETBRIGHTNESS       11 /*0x0b*/
#define QCAM_CMD_SETTOP              13 /*0x0d*/
#define QCAM_CMD_SETLEFT             15 /*0x0f*/
#define QCAM_CMD_SETNUMV             17 /*0x11*/
#define QCAM_CMD_SETNUMH             19 /*0x13*/
#define QCAM_CMD_SENDVERSION         23 /*0x17*/
#define QCAM_CMD_BW_SETCONTRAST      25 /*0x19*/
#define QCAM_CMD_BW_AUTOADJUSTOFFSET 27 /*0x1b*/
#define QCAM_CMD_SETBLACK            29 /*0x0d*/
#define QCAM_CMD_SETWHITE            31 /*0x1f*/
#define QCAM_CMD_COLOR_SETHUE        33 /*0x21*/
#define QCAM_CMD_BW_GETOFFSET        33 /*0x21*/
#define QCAM_CMD_SETSATURATION       35 /*0x23*/
#define QCAM_CMD_COLOR_SETCONTRAST   37 /*0x25*/
#define QCAM_CMD_SENDSTATUS          41 /*0x29*/
#define QCAM_CMD_COLOR_SETSPEED      45 /*0x2d*/


/* Camera definition (NOT the same as in qcam) */

struct qcam{
double red;
double green;
double blue;
unsigned int x;           /* horizontal image offset */
unsigned int y;           /* vertical image offset */
unsigned int xsize;       /* image width */
unsigned int ysize;       /* image height */
unsigned int decim;       /* image decimation */
unsigned int direction;   /* image direction A - 0, > - 1, V - 2, < - 3 */
unsigned int bpp;         /* bits per pixel */
unsigned int framesize;   /* frame size */
unsigned char *frame;     /* output frame */
unsigned char **rows;     /* rows pointers list */
unsigned char redarray[256];
unsigned char greenarray[256];
unsigned char bluearray[256];
unsigned char brightness; /* brightness */
unsigned char contrast;   /* contrast */
unsigned char hue;        /* hue */
int p0;                   /* ports */
int p1;
int p2;
int lockfile;             /* lock file descriptor */
int ioporthandle;         /* i/o port handle (if used) */
int scan_priority;        /* priority used when scanning */
unsigned int camv;        /* version */
unsigned int color;       /* color flag */
unsigned int connv;       /* connector version */
unsigned int bidir;       /* bidirectional port */
unsigned int btpp;        /* bytes per pixel */
int alarmflag;            /* alarm flag */
unsigned char black;      /* black level */
unsigned char white;      /* white level */
unsigned char blackoffset;/* black offset */
unsigned char saturation; /* saturation */
unsigned char *frame1;    /* internal frame */

unsigned char vparam;     /* hardware mode for the camera */
};

struct qcam *qccreate(void);
/* Create camera definition */

void qcdelete(struct qcam *qc);
/* Delete camera definition */

inline int qcsend(const struct qcam *qc,unsigned char arg);
/* Send request */

inline unsigned char qcrecv(const struct qcam *qc);
/* Receive response */

inline int qccmd(const struct qcam *qc,unsigned char cmd,unsigned char param);
/* Send command */

inline unsigned int qcget(const struct qcam *qc,unsigned char cmd);
/* Get parameter */

int qcinit(struct qcam *qc,int portnum);
/* Initialize camera */

int qcsetimage(struct qcam *qc,unsigned char brightness,
unsigned char contrast,unsigned char saturation,
unsigned char hue,unsigned char black,unsigned char white,
unsigned char blackoffset);
/* Set image parameters */

int qchwframe(struct qcam *qc,int x,int y,int xsize,int ysize,int direction,
int bpp,int decim);
/* Set frame parameters */

void qcsetcolor(struct qcam *qc,double red,double green,double blue);
/* Set color balance */

void qcsetpriority(struct qcam *qc,int priority);
/* Set priority */

int qcsethw(struct qcam *qc);
/* Set parameters after initial setup */

void qcwaitforready(const struct qcam *qc);
/* Wait fro camera to become ready */

int qcreadframe(struct qcam *qc);
/* Read frame */

int qcgetimageexposure(struct qcam *qc);
/* Get image exposure */

int qcinitset(struct qcam *qc);
/* Initialize after filling the descriptor from the config file */

int qcreadconfigfile(struct qcam *qc,char *filename,
char *cameraname,int quiet);
/* Read the config file */
