/*

os-specific.h, part of Connectix QuickCam hardware interface

Copyright (C) 1996, 1997 Alex Belits

This software contains ideas and modified parts from qcam,
written by Scott Laird.

Copyright (C) 1996 by Scott Laird

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL SCOTT LAIRD OR ALEX BELITS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifdef Linux
#include <asm/io.h>
#define OUTB(a,b) outb((a),(b))
#define INB(a)    inb(a)
#else
#ifdef FreeBSD
#include <machine/cpufunc.h>
#define OUTB(a,b) outb((b),(a))
#define INB(a)    inb(a)
#else
#error "No OS or unknown OS defined"
#endif
#endif

int openioport(int portnum){
#ifdef Linux
if(ioperm(portnum,3,1)){
 return -1;
 }else{
 return 0;
 }
#else
#ifdef FreeBSD
return open("/dev/io",O_RDONLY,0);
#else
#error "No OS or unknown OS defined"
#endif
#endif
}

void closeioport(int portnum,int handle){
#ifdef Linux
ioperm(portnum,3,0);
#else
#ifdef FreeBSD
close(handle);
#else
#error "No OS or unknown OS defined"
#endif
#endif
}
