#!/bin/sh
# $Id: rbllist.sh,v 1.4 2005/11/16 14:08:05 luca Exp $
# this script build ``data'' file for rbldns
# see http://cr.yp.to/djbdns/rbldns-data.html for more info

RBLIP=127.0.0.2
TXT="The sender is listed: $"

if [ "${1}" = "-x" -a -f ${2} ]; then
  EXCLUDE=${2}
  shift; shift
fi

if [ "${1}" = "" -o ! -f ${1} ]; then
  exec >&2
  echo "usage: ${0} [-x data.good] data.new [data.old ...]"
  echo
  echo " where data.new is the qmail-rblchk file generated by -L option"
  echo " and data.old files are other file to add to output"
  echo
  echo " -x data.good exclude all IPs listed into data.good"
  exit 1
fi

echo "# WARNING: This file was auto-generated. Do not edit!"
echo "#"
echo "# `date`"
echo
echo ":${RBLIP}:${TXT}"
echo
if [ "${EXCLUDE}" = "" -o ! -f ${EXCLUDE} ]; then
  cat ${*} | sort -u
else
  cat ${*} | sort -u | grep -F -v -f ${EXCLUDE}
fi
