.\"
.\"   $Id: radvd.conf.5.man,v 1.7 2002/06/21 11:57:15 psavola Exp $
.\"
.\"   Authors:
.\"    Lars Fenneberg		<lf@elemental.net>
.\"    Marko Myllynen           <myllynen@lut.fi>	 
.\"
.\"   This software is Copyright 1996-2000 by the above mentioned author(s), 
.\"   All Rights Reserved.
.\"
.\"   The license which is distributed with this software in the file COPYRIGHT
.\"   applies to this software. If your distribution is missing this file, you
.\"   may request it from <lutchann@litech.org>.
.\"
.\"
.\"
.TH RADVD.CONF 5 "29 Mar 2001" "radvd @VERSION@" ""
.SH NAME
radvd.conf \- configuration file of the router advertisement daemon
.B radvd
.SH DESCRIPTION
This file describes the information which is included in the router
advertisement (RA) of a specific interface.
.P
The file contains one or more interface definitions of the form:

.nf
.BR "interface " "name " {
	list of interface specific options
	list of prefix definitions
.B };
.fi

All the possible interface specific options are detailed below.  Each
option has to be terminated by a semicolon.

Prefix definitions are of the form:

.nf
.BR "prefix " prefix / "length " {
	list of prefix specific options
.B };
.fi

Prefix can be network prefix or the address of the inferface.
The address of interface should be used when using Mobile IPv6
extensions.

All the possible prefix specific options are described below.  Each
option has to be terminated by a semicolon.

Decimal values are allowed only for MaxRtrAdvInterval and
MinRtrAdvInterval.  Decimal values should be used only when using
Mobile IPv6 extensions.

.SH INTERFACE SPECIFIC OPTIONS

.TP
.BR AdvSendAdvert " " on | off

A flag indicating whether or not the router sends
periodic router advertisements and responds to
router solicitations. 

This option no longer has to be specified first, but it
needs to be
.B on
to enable advertisement on this interface.

Default: off

.TP
.BR UnicastOnly " " on | off

Indicates that the interface link type only supports unicast.
This will prevent unsolicited advertisements from being sent, and
will cause solicited advertisements to be unicast to the
soliciting node.  This option is necessary for non-broadcast,
multiple-access links, such as ISATAP.

Default: off

.TP
.BR "MaxRtrAdvInterval " seconds

The maximum time allowed between sending unsolicited multicast
router advertisements from the interface, in seconds.

Must be no less than 4 seconds and no greater than 1800 seconds.

Minimum when using Mobile IPv6 extensions: 1.5.

Default: 600 seconds	

.TP
.BR "MinRtrAdvInterval " seconds

The minimum time allowed between sending unsolicited multicast
router advertisements from the interface, in seconds.

Must be no less than 3 seconds and no greater than 0.75 *
MaxRtrAdvInterval.

Minimum when using Mobile IPv6 extensions: 0.05.

Default: 0.33 * MaxRtrAdvInterval

.TP
.BR AdvManagedFlag " " on | off

When set, hosts use the administered (stateful) protocol for address
autoconfiguration in addition to any addresses autoconfigured using
stateless address autoconfiguration.  The use of this flag is
described in RFC 2462.

Default: off

.TP
.BR AdvOtherConfigFlag " " on | off

When set, hosts use the administered (stateful) protocol for
autoconfiguration of other (non-address) information.  The use of
this flag is described in RFC 2462.

Default: off

.TP
.BR "AdvLinkMTU " integer

The MTU option is used in  router advertisement messages to insure
that all nodes on a link use the same MTU value in those cases where
the link MTU is not well known.

If specified, i.e. not 0, must not be smaller than 1280 and not greater
than the maximum MTU allowed for this link (e.g. ethernet has
a maximum MTU of 1500. See RFC 2464).

Default: 0

.TP
.BR "AdvReachableTime " milliseconds

The time, in milliseconds, that a node assumes a neighbor is
reachable after having received a reachability confirmation.  Used
by the Neighbor Unreachability Detection algorithm (see Section
7.3 of RFC 2461).  A value of zero means unspecified (by this router).

Must be no greater than 3,600,000 milliseconds (1 hour).

Default: 0

.TP
.BR "AdvRetransTimer " milliseconds

The time, in milliseconds, between retransmitted Neighbor
Solicitation messages.  Used by address resolution and the Neighbor
Unreachability Detection algorithm (see Sections 7.2 and 7.3 of RFC 2461).
A value of zero means unspecified (by this router).

Default: 0

.TP
.BR "AdvCurHopLimit " integer

The default value that should be placed in the Hop Count field of
the IP header for outgoing (unicast) IP packets.  The value should
be set to the current diameter of the Internet.  The value zero
means unspecified (by this router).

Default: 64

.TP
.BR "AdvDefaultLifetime " seconds

The lifetime associated with the default router in units of seconds. 
The maximum value corresponds to 18.2 hours.  A lifetime of 0
indicates that the router is not a default router and should not
appear on the default router list.  The router lifetime applies only
to the router's usefulness as a default router; it does not apply to
information contained in other message fields or options.  Options
that need time limits for their information include their own
lifetime fields.

Must be either zero or between MaxRtrAdvInterval and 9000 seconds.

Default: 3 * MaxRtrAdvInterval

.TP
.BR AdvSourceLLAddress " " on | off

When set, the link-layer address of the outgoing interface is
included in the RA.

Default: on

.TP
.BR AdvHomeAgentFlag " " on | off

When set, indicates that sending router is able to serve as Mobile
IPv6 Home Agent.  When set, minimum limits specified by Mobile IPv6
are used for MinRtrAdvInterval and MaxRtrAdvInterval.

Default: off

.TP
.BR AdvHomeAgentInfo " " on | off

When set, Home Agent Information Option (specified by Mobile IPv6)
is included in Router Advertisements.  AdvHomeAgentFlag must also
be set when using this option.

Default: off

.TP
.BR "HomeAgentLifetime " seconds

The length of time in seconds (relative to the time the packet is
sent) that the router is offering Mobile IPv6 Home Agent services.  
A value 0 must not be used.  The maximum lifetime is 65520 seconds 
(18.2 hours).  This option is ignored, if AdvHomeAgentInfo is not
set.

If both HomeAgentLifetime and HomeAgentPreference are set to their
default values, Home Agent Information Option will not be sent.

Default: AdvDefaultLifetime

.TP
.BR "HomeAgentPreference " integer

The preference for the Home Agent sending this Router Advertisement.  
Values greater than 0 indicate more preferable Home Agent, values
less than 0 indicate less preferable Home Agent.  This option is
ignored, if AdvHomeAgentInfo is not set.

If both HomeAgentLifetime and HomeAgentPreference are set to their
default values, Home Agent Information Option will not be sent.

Default: 0

.TP
.BR AdvIntervalOpt " " on | off

When set, Advertisement Interval Option (specified by Mobile IPv6)
is included in Router Advertisements.  When set, minimum limits
specified by Mobile IPv6 are used for MinRtrAdvInterval and
MaxRtrAdvInterval.

Default: off

.SH PREFIX SPECIFIC OPTIONS

.TP
.BR AdvOnLink " " on | off

When set, indicates that this prefix can be used for on-link
determination.  When not set the advertisement makes no statement
about on-link or off-link properties of the prefix.  For instance,
the prefix might be used for address configuration with some of the
addresses belonging to the prefix being on-link and others being
off-link.

Default: on

.TP
.BR AdvAutonomous " " on | off

When set, indicates that this prefix can be used for autonomous
address configuration as specified in RFC 2462.

Default: on

.TP
.BR AdvRouterAddr " " on | off

When set, indicates that the address of interface is sent instead of
network prefix, as is required by Mobile IPv6.  When set, minimum
limits specified by Mobile IPv6 are used for MinRtrAdvInterval and
MaxRtrAdvInterval.

Default: off

.TP
.BR "AdvValidLifetime " seconds "" | infinity

The length of time in seconds (relative to the time the packet is
sent) that the prefix is valid for the purpose of on-link
determination.  The symbolic value
.B infinity
represents infinity (i.e. a value of all one bits (0xffffffff)).
The valid lifetime is also used by RFC 2462.

Default: infinity

.TP
.BR "AdvPreferredLifetime " seconds "" | infinity

The length of time in seconds (relative to the time the packet is
sent) that addresses generated from the prefix via stateless address
autoconfiguration remain preferred. 
The symbolic value
.B infinity
represents infinity (i.e. a value of all one bits (0xffffffff)).
See RFC 2462.

Default: 604800 seconds (7 days)

.TP
.BR "Base6to4Interface " name 

If this option is specified, this prefix will be combined with the
IPv4 address of interface
.B name
to produce a valid 6to4 prefix. The first 16 bits of this prefix
will be replaced by
.B 2002
and the next 32 bits of this prefix will be replaced by the IPv4
address assigned to interface
.B name
at configuration time. The remaining 80 bits of the prefix (including
the SLA ID) will be advertised as specified in the configuration file.
See the next section for an example.

If interface
.B name
is not available at configuration time, a warning will be written to
the log and this prefix will be disabled until radvd is reconfigured.

This option enables systems with dynamic IPv4 addresses to update their
advertised 6to4 prefixes simply by restarting radvd or sending a SIGHUP
signal to cause radvd to reconfigure itself.

Note that 6to4 prefixes derived from dynamically-assigned IPv4 addresses
should be advertised with a significantly shorter lifetime (see the
.B AdvValidLifetime
and
.B AdvPreferredLifetime
options).

For more information on 6to4, see RFC 3056.

Default: 6to4 is not used

.SH EXAMPLES

.nf
interface eth0
{
        AdvSendAdvert on;
        prefix fec0:0:0:1::/64
        {
                AdvOnLink on;
                AdvAutonomous on;
        };
};
.fi

It says that router advertisement daemon should advertise
(AdvSendAdvert on;) the prefix fec0:0:0:1:: which has a lenght of 64
on the interface eth0.  Also the prefix should be marked as autonomous
(AdvAutonomous on;) and as on-link (AdvOnLink on;).  All the other
options are left on their default values.

To support movement detection of Mobile IPv6 Mobile Nodes, the
address of interface should be used instead of network prefix:

.nf
interface eth0
{
        AdvSendAdvert on;
        prefix fec0:0:0:1::4/64
        {
                AdvOnLink on;
                AdvAutonomous on;
                AdvRouterAddr on;
        };
};
.fi

For 6to4 support, include the
.B Base6to4Interface
option in each prefix section. When using a dynamic IPv4 address, set
small prefix lifetimes to prevent hosts from retaining unreachable
prefixes after a new IPv4 address has been assigned.

.nf
interface eth0
{
        AdvSendAdvert on;

        # Advertise at least every 30 seconds
        MaxRtrAdvInterval 30;

        prefix 0:0:0:5678::/64
        {
                AdvOnLink on;
                AdvAutonomous on;
                Base6to4Interface ppp0;

                # Very short lifetimes for dynamic addresses
                AdvValidLifetime 300;
                AdvPreferredLifetime 120;
        };
};
.fi

Since 6to4 is enabled, the prefix will be advertised as
2002:WWXX:YYZZ:5678::/64, where WW.XX.YY.ZZ is the IPv4 address of
ppp0 at configuration time. (IPv6 addresses are written in hexadecimal
whereas IPv4 addresses are written in decimal, so the IPv4 address
WW.XX.YY.ZZ in the 6to4 prefix will be represented in hex.)

.SH FILES

.nf
@sbindir@/radvd
@PATH_RADVD_CONF@
@PATH_RADVD_PID@
@PATH_RADVD_LOG@
.fi

.SH CREDIT
The description of the different flags and variables is in large
parts taken from RFC 2461.

.SH RFCS
Narten, T., E. Nordmark, W. Simpson, "Neighbor Discovery for IP
Version 6 (IPv6)", RFC 2461, December 1998
.PP
Thomson, S., and T. Narten, "IPv6 Stateless Address Autoconfiguration", 
RFC 2462, December 1998.
.PP
Deering, S., and R. Hinden, Editors, "IP Version 6 Addressing
Architecture", RFC 2373, July 1998.
.PP	
Conta, A., and S. Deering, "Internet Control Message Protocol (ICMPv6)
for the Internet Protocol Version 6 (IPv6)", RFC 2463, December 1998.
.PP
Crawford, M., "Transmission of IPv6 Packets over Ethernet Networks",
RFC 2464, December 1998.	
.PP
Carpenter B., Moore K., "Connection of IPv6 Domains via IPv4 Clouds",
RFC 3056, February 2001. (6to4 specification)

.SH "SEE ALSO"

.BR radvd (8),
.BR radvdump (8)
