#!/bin/sh
#
# Copyright 2002-2005 G.U.F.I. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  1.Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#  2.Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation 
#    and/or other materials provided with the distribution. 
#
# THIS SOFTWARE IS PROVIDED BY G.U.F.I. ``AS IS'' AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE FREEBSD PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
# OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
# EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# The views and conclusions contained in the software and documentation are
# those of the authors and should not be interpreted as representing official
# policies, either expressed or implied, of the G.U.F.I.
#
# $Id: after_installation_routines.sh,v 1.8 2005/05/01 18:43:31 saturnero Exp $
# Lets cleanup from fake root environment

export PATH="/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin"

mkdir  /RelaxBSD/mnt/dev
rm -f /RelaxBSD/mnt/etc/rc.d/relaxmdconf
rm -rf /RelaxBSD/mnt/uzip
rm -rf /RelaxBSD/mnt/dist

# Update boot loader
cp -R /boot/* /RelaxBSD/mnt/boot/

#cat /boot/loader.conf | grep -v ^mfsroot > /RelaxBSD/mnt/boot/loader.conf

cd /RelaxBSD/mnt && rm RelaxBSD/ boot/mfsroot.gz

#Install grub
sysctl kern.geom.debugflags=16
grub-install --root-directory=/RelaxBSD/mnt /dev/ad0
cp /usr/local/share/grub/i386-freebsd/splash.xpm.gz /RelaxBSD/mnt/boot/grub/

cat >> /RelaxBSD/mnt/boot/grub/menu.lst << _EOF
timeout 10
default 0
_EOF

hd=`mount -up /RelaxBSD/mnt | awk '{print $1}'`
hdsub1=`echo ${hd} | cut -c 17`
hdsub4=`echo ${hd} | cut -c 19`
hdsub2=`expr ${hdsub4} - 1`
hdsub3=`echo ${hd} | cut -c 20`
cat >> /RelaxBSD/mnt/boot/grub/menu.lst << _EOF
splashimage (hd${hdsub1},${hdsub2},${hdsub3})/boot/grub/splash.xpm.gz

title   RelaxBSD @VERSION@ Release
root    (hd${hdsub1},${hdsub2},${hdsub3})
kernel  /boot/loader
_EOF

for i in `egrep "^ad[0-9]:" /var/run/dmesg.boot | cut -d':' -f1 | sort | uniq`
do
    grub_hdsub=`echo $i | cut -c 3`
    a=1
    for x in `fdisk /dev/$i | grep sysid | awk -F"," '{print $1}' | awk '{print $2}'`
    do
        case ${x} in
        1|4|6|11|12|13)
        grub_fatsub=`expr $a - 1`
        cat >> /RelaxBSD/mnt/boot/grub/menu.lst << _EOF

title   Windows 98/Me/2000/XP
root    (hd${grub_hdsub},${grub_fatsub})
makeactive
chainloader +1
_EOF
        ;;
        esac
        a=`expr $a + 1`
    done
done

# Self destruct myself.
if [ -e "/RelaxBSD/mnt/@prefix@/bin/after_installation_routines.sh" ];then
        rm -f /RelaxBSD/mnt/@prefix@/bin/after_installation_routines.sh
fi
