#!/bin/sh
# Example for use of GNU gettext.
# Copyright (C) 2003 Free Software Foundation, Inc.
# This file is in the public domain.
#
# Script for regenerating all autogenerated files.

. ./installpaths

cp -p ${ACLOCALDIR-../../../gettext-runtime/m4}/nls.m4 m4/nls.m4
cp -p ${ACLOCALDIR-../../../gettext-runtime/m4}/po.m4 m4/po.m4
cp -p ${GETTEXTSRCPODIR-../../../gettext-runtime/po}/remove-potcdate.sin po/remove-potcdate.sin

aclocal15 -I m4

autoconf253

automake15 -a -c

cd po
for f in *.po; do
  if test -r "$f"; then
    lang=`echo $f | sed -e 's,\.po$,,'`
    msgfmt -c -o $lang.gmo $lang.po
  fi
done
cd ..
