#!/bin/sh
#
# Copyright 2005 RelaxBSD All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  1.Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#  2.Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY RelaxBSD ``AS IS'' AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE FREEBSD PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
# OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
# EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# The views and conclusions contained in the software and documentation are
# those of the authors and should not be interpreted as representing official
# policies, either expressed or implied, of the RelaxBSD
#

export PATH="/bin:/sbin:/usr/bin:/usr/sbin:@prefix@/bin:@prefix@/sbin"

[ "$1" = "once" -a -e /root/.relaxconf ] && exit 0
[ ! -e /root/.relaxconf ] && touch /root/.relaxconf

. gettext.sh
export TEXTDOMAIN=@PACKAGE@
export TEXTDOMAINDIR="@localedir@"

TMP=/tmp
SYSTEM="RelaxBSD @VERSION@"
PPPCONF="/etc/ppp/ppp.conf"

DIALOG="@DIALOG@"

tempfile="/tmp/mainTEMP.$$"

SAVESETTING="`find /mnt -maxdepth 2 -name 'RelaxBSD_*' -type d`"

savesetting() {
		if [ -z "$SAVESETTING" -a -f /RelaxBSD/COPYRIGHT.RelaxBSD ]; then
 		 	YESNO=$(gettext "Do you want to save setting? It's important for you.")
			$DIALOG --clear --yesno "$YESNO" 6 40
			[ "$?" = "0" ] && (. @prefix@/bin/relaxsavesetting)
		fi
}

main_menu()
{
CANCELLABEL=$(gettext "Poweroff")
HELPLABEL=$(gettext "Reboot")
BACKTITLE=$(eval_gettext "\$SYSTEM -> Main menu")
MENU=$(gettext "Select the function you need")
LANGLOG=$(gettext "Change Language environment")
KBDMAPLOG=$(gettext "Change keyboard language")
PERSONALDATALOG=$(gettext "Backup or Restore your PersonalDate")
NETCONFIGLOG=$(gettext "Configure network interface")
XCONFIGLOG=$(gettext "Configure Xorg or XFree86")
SAVESETTINGLOG=$(gettext "Save all configuration files to a disk")
LOADSETTINGLOG=$(gettext "Load configuration settings")
STARTGNOMELOG=$(gettext "Start Gnome 2.10 desktop environment")
STARTXFCE4LOG=$(gettext "Start XFCE 4 desktop environment")
STARTCONSOLELOG=$(gettext "Start tcsh shell")
BSDINSTALLERLOG=$(eval_gettext "Install \$SYSTEM into a disk")
NOLOG=$(gettext "Don't do any things")
$DIALOG --default-item "Gnome" --cancel-label $CANCELLABEL --clear --backtitle "$BACKTITLE" \
	--help-button --help-label "$HELPLABEL" --menu "$MENU" 19 68 12 \
	"Langchoice" "$LANGLOG" \
	"Kbdmap" "$KBDMAPLOG" \
	"Netconfig" "$NETCONFIGLOG" \
	"Xconfig" "$XCONFIGLOG" \
	"Savesetting" "$SAVESETTINGLOG" \
	"Loadsetting" "$LOADSETTINGLOG" \
	"PersonalData" "$PERSONALDATALOG" \
	"Console"  "$STARTCONSOLELOG" \
	"Gnome" "$STARTGNOMELOG" \
	"XFCE4" "$STARTXFCE4LOG" \
	"BSDinstaller" "$BSDINSTALLERLOG" \
	"No"	"$NOLOG" 2> $tempfile

retval=$?
RESULT=`cat $tempfile`
case $retval in
  0)
	case $RESULT in
		Langchoice)
		[ -x @prefix@/bin/relaxlangconf ] && (. @prefix@/bin/relaxlangconf)
		main_menu
		;;
		Kbdmap)
		[ -x /usr/sbin/kbdmap ] && (/usr/sbin/kbdmap)
		main_menu
		;;
		Netconfig)
		[ -x @prefix@/bin/relaxnetconf ] && (. @prefix@/bin/relaxnetconf)
		main_menu
		;;
		Xconfig)
		[ -x @prefix@/bin/relaxxconf ] && (. @prefix@/bin/relaxxconf)
		main_menu
		;;
		Savesetting)
		[ -x @prefix@/bin/relaxsavesetting ] && (. @prefix@/bin/relaxsavesetting)
		main_menu;;
		Loadsetting)
		[ -n "$SAVESETTING" ] && (sh @prefix@/bin/relaxloadsetting select)
		main_menu;;
		PersonalData)
		BACKTITLE2=$(eval_gettext "\$SYSTEM -> Personal data")
		MENU2=$(gettext "Backup or Restore your personal data")
		BACKUPLOG=$(gettext "Backup your personal data")
		RESTORELOG=$(gettext "Restore your personal data")
		$DIALOG --no-cancel --clear --backtitle "$BACKTITLE2" --menu "$MENU2" 9 68 2 \
		Backup "$BACKUPLOG" \
		Restore "$RESTORELOG" 2> /tmp/selectTEMP.$$
		DATASELECT=`cat /tmp/selectTEMP.$$`
		[ "$DATASELECT" = "Backup" ] && (. @prefix@/bin/relaxmediabackup)
		[ "$DATASELECT" = "Restore" ] && (. @prefix@/bin/relaxrestore)
		;;
		Console)
		touch /root/.console
		savesetting
		;;
		Gnome)
		if [ ! -f /etc/X11/xorg.conf -a ! -f /etc/X11/XF86Config ] ; then
			[ -x @prefix@/bin/relaxxconf ] && (. @prefix@/bin/relaxxconf)
		fi
		[ -e /root/.xinitrc.gnome ] && ln -sf /root/.xinitrc.gnome /root/.xinitrc
		savesetting
		;;
		XFCE4)
		if [ ! -f /etc/X11/xorg.conf -a ! -f /etc/X11/XF86Config ] ; then
			[ -x @prefix@/bin/relaxxconf ] && (. @prefix@/bin/relaxxconf)
		fi
		[ -e /root/.xinitrc.xfce4 ] && ln -sf /root/.xinitrc.xfce4 /root/.xinitrc
		savesetting
		;;
		BSDinstaller)
		[ -x @prefix@/bin/relaxinstaller ] && . @prefix@/bin/relaxinstaller
		;;
	esac
	;;
  1)
  	YESNO=$(gettext "Do you want to take poweroff ?")
	$DIALOG --clear --yesno "$YESNO" 6 40
	case $? in
		0)
		halt -p now;;
		1)
		main_menu;;
		255)
		main_menu;;
	esac
	;;
  2)
  	YESNO=$(gettext "Do you want to reboot?")
   $DIALOG --clear --yesno "$YESNO" 6 40
	case $? in
		0)
		reboot;;
		1)
		main_menu;;
		255)
		main_menu;;
	esac
	;;
  255)
  main_menu;;
esac
}
main_menu
exit 0
