#!/bin/sh

# Launch BSD Installer with fake "installer root"
# Copyright 2004-2005 BSD Installer Project,the FreeSBIE project and the RelaxBSD Project
# This file is placed under the BSD license.

echo
echo Launching BSD/RelaxBSD Installer...
echo

export PATH="/bin:/sbin:/usr/bin:/usr/sbin:@prefix@/bin:@prefix@/sbin"

swapdev=`swapinfo | grep "\/dev\/" | awk '{print $1}'`
[  "${swapdev}" != "" ] && swapoff ${swapdev}

echo "Umounting automounted partitions..."
mount | cut -d ' ' -f3 | grep "^/mnt/" | xargs umount

#ln -s /RelaxBSD/tftpdroot /tmp/tftpdroot
echo "Mounting /RelaxBSD/dev..."
mount_devfs devfs /RelaxBSD/dev

echo "Mounting /RelaxBSD/usr..."
MD_LOCAL=`mdconfig -a -t vnode -f /RelaxBSD/uzip/usr.uzip`
mount -r /dev/$MD_LOCAL.uzip /RelaxBSD/usr

echo "Mounting /RelaxBSD/var..."
MD_LOCAL=`mdconfig -a -f /RelaxBSD/uzip/var.uzip`
mount -r /dev/$MD_LOCAL.uzip /RelaxBSD/var

if [ -f /RelaxBSD/uzip/x11r6.uzip ]; then
echo "Mounting /RelaxBSD/usr/X11R6/..."
MD_LOCAL=`mdconfig -a -t vnode -f /RelaxBSD/uzip/x11r6.uzip`
mount -r /dev/$MD_LOCAL.uzip /RelaxBSD/usr/X11R6
fi

if [ -f /RelaxBSD/uzip/openoffice.uzip ]; then
echo "Mounting /RelaxBSD@prefix@/OpenOffice.org1.1.4..."
MD_LOCAL=`mdconfig -a -t vnode -f /RelaxBSD/uzip/openoffice.uzip`
mount -r /dev/$MD_LOCAL.uzip /RelaxBSD@prefix@/OpenOffice.org1.1.4
fi

# Copy dmesg.boot into place so that installer can discover names of devices
mount_unionfs /.var /RelaxBSD/var

# Place PFI here
# XXX: port pfi to FreeBSD XXX

# Let's access this now to prevent the "RockRidge" message
# during the actual install
ls /RelaxBSD/usr >/dev/null 2>&1
ls /RelaxBSD/var >/dev/null 2>&1
ls /RelaxBSD@prefix@/OpenOffice.org1.1.4 >/dev/null 2>&1

# Launch the backend
@prefix@/sbin/dfuibe_installer -o /RelaxBSD/ >/dev/null 2>&1 &
# Launch the curses based frontend
@prefix@/sbin/dfuife_curses
