#!/bin/sh
#
# Copyright 2005 RelaxBSD All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  1.Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#  2.Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY RelaxBSD ``AS IS'' AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE FREEBSD PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
# OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
# EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# The views and conclusions contained in the software and documentation are
# those of the authors and should not be interpreted as representing official
# policies, either expressed or implied, of the RelaxBSD
#

export PATH="/bin:/sbin:/usr/bin:/usr/sbin:@prefix@/bin:@prefix@/sbin"

. gettext.sh

export TEXTDOMAIN=@PACKAGE@
export TEXTDOMAINDIR="@localedir@"

DIALOG="@DIALOG@"

LANGCSH=/etc/lang.csh
LANGSH=/etc/lang.sh
if [ -f $LANGCSH -o -f $LANGSH ]; then
	if [ "$1" = "once" ] ; then
		exit 0
    else
        touch /root/.langreset
	fi
fi
langchoice () {
CANCELLABEL=$(gettext "Return")
ENGLISHLOG=$(gettext "English")
CSLOG=$(gettext "Chinese Simplified")
CTLOG=$(gettext "Chinese Traditional")
backtitle=$(gettext "RelaxBSD @VERSION@ --> Language choice:")
MENU=$(gettext "Please choose a language to use")
$DIALOG --clear --no-cancel \
		--backtitle "$backtitle" \
		--menu "$MENU" 10 40 3 \
	        "zh_CN.eucCN" "$CSLOG" \
	        "zh_TW.Big5" "$CTLOG" \
		"en_US.ISO8859-1" "$ENGLISHLOG" 2> /tmp/langTEMP.$$

retval=$?
choice=`cat /tmp/langTEMP.$$`
case $retval in
  0)
    case $choice in
	  "en_US.ISO8859-1")
	    echo "setenv LANG en_US.ISO8859-1" > $LANGCSH
	    echo "setenv LC_CTYPE en_US.ISO8859-1" >> $LANGCSH
	    echo "export LANG=en_US.ISO8859-1" > $LANGSH
	    echo "export LC_CTYPE=en_US.ISO8859-1" >> $LANGSH
	    ;;
	  "zh_CN.eucCN")
	    echo "setenv LANG zh_CN.eucCN" > $LANGCSH
	    echo "setenv LC_CTYPE zh_CN.eucCN" >> $LANGCSH
	    echo "setenv CHARSET eucCN" >> $LANGCSH
	    echo "export LANG=zh_CN.eucCN" > $LANGSH
	    echo "export LC_CTYPE=zh_CN.eucCN" >> $LANGSH
	    echo "export CHARSET=eucCN" >> $LANGSH
	    ;;
	  "zh_TW.Big5")
	    echo "setenv LANG zh_TW.Big5" > $LANGCSH
	    echo "setenv LC_CTYPE zh_TW.Big5" >> $LANGCSH
	    echo "setenv CHARSET Big5" >> $LANGCSH
	    echo "export LANG=zh_TW.Big5" > $LANGSH
	    echo "export LC_CTYPE=zh_TW.Big5" >> $LANGSH
	    echo "export CHARSET=Big5" >> $LANGSH
	esac
	chmod 755 $LANGSH $LANGCSH
	;;
        1)
	    langchoice
            ;;
        255)
	    echo "ESC pressed."
	esac
}
langchoice

