#!/bin/sh
#
# Modified by hamigua <relaxbsd@yahoo.com>
#
# Copyright 2002-2005 G.U.F.I. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  1.Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#  2.Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation 
#    and/or other materials provided with the distribution. 
#
# THIS SOFTWARE IS PROVIDED BY G.U.F.I. ``AS IS'' AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE FREEBSD PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
# OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
# EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# The views and conclusions contained in the software and documentation are
# those of the authors and should not be interpreted as representing official
# policies, either expressed or implied, of the G.U.F.I.
#
#$Id: load_settings.sh,v 1.6 2005/04/26 17:22:46 rionda Exp $

[ ! -f /RelaxBSD/COPYRIGHT.RelaxBSD ] && exit 0

export PATH="/bin:/sbin:/usr/bin:/usr/sbin:@prefix@/bin:@prefix@/sbin"

. gettext.sh
export TEXTDOMAIN=@PACKAGE@
export TEXTDOMAINDIR="@localedir@"

DIALOG="@DIALOG@"

CONFIGFILE_NAME="relaxbsd_settings.conf"
CONFIG_DIR=""

set_defaultrouter() {
  route add default $DEFAULTROUTER >/dev/null 2>&1
}

set_hostname() {
  hostname $HOSTNAME
}

load_rc_conf() {
  #It's necessary copy back the rc.conf file because a lot of daemons
  #starts only if a specific directive is present in rc.conf, e.g.
  #ddclient_enable="YES" or apache_enable="YES". 
  cp $CONFIG_DIR/rc.conf /etc/rc.conf
}

load_ppp_dir() {
  cp -r $CONFIG_DIR/ppp /etc
  [ -f $CONFIG_DIR/resolv.conf ] && cp $CONFIG_DIR/resolv.conf /etc/resolv.conf
}

load_exec_local_daemons() {
  while read i
  do
    #Unuseful? No, it is needed by repeated relaxsavesetting.
    chmod 755 @prefix@/etc/rc.d/$i >/dev/null 2>&1
    # Do all scripts support the restart param? I think no.
    sh @prefix@/etc/rc.d/$i stop >/dev/null 2>&1
    sh @prefix@/etc/rc.d/$i start >/dev/null 2>&1
  done < $CONFIG_DIR/local_daemons.txt
}

load_kbdmap_file() {
  if [ -f $CONFIG_DIR/kbdmap.conf ]; then
    cp $CONFIG_DIR/kbdmap.conf /tmp/kbdmap.conf
    /usr/sbin/kbdcontrol -l "/usr/share/syscons/keymaps/`cat /tmp/kbdmap.conf`"
  fi
}

load_lang_choice() {
  if [ -x $CONFIG_DIR/lang.sh ]; then
    cp $CONFIG_DIR/lang.sh /etc/lang.sh
    chmod a+x /etc/lang.sh
  fi
  if [ -x $CONFIG_DIR/lang.csh ]; then
    cp $CONFIG_DIR/lang.csh /etc/lang.csh
    chmod a+x /etc/lang.csh
  fi
}

load_user_env() {
[ -r $CONFIG_DIR/.relaxconf ] && touch /root/.relaxconf
[ -r $CONFIG_DIR/.xinitrc ] && cp $CONFIG_DIR/.xinitrc /root/.xinitrc
[ -r $CONFIG_DIR/.tcshrc ] && cp $CONFIG_DIR/.tcshrc /root/.tcshrc
[ -r $CONFIG_DIR/.muttrc ] && cp $CONFIG_DIR/.muttrc /root/.muttrc
}

load_x11_config() {
        [ -r $CONFIG_DIR/xorg.conf ] && cp $CONFIG_DIR/xorg.conf /etc/X11/xorg.conf
        [ -r $CONFIG_DIR/XF86Config-4 ] && cp $CONFIG_DIR/XF86Config-4 /etc/X11/XF86Config-4
}

set_iface() {
  #Stopping the dhclient if present
  DHCLIENT_PID=`ps -x | grep "dhclient -nw $IFACE_NAME" | \
                awk '{print $1}'`
  [ "$DHCLIENT_PID" ] && kill $DHCLIENT_PID >/dev/null 2>&1
  ifconfig $IFACE_NAME $IFACE_ARGS >/dev/null 2>&1
}

# Find the already mounted partitions in /mnt
if [ "$1" = "select" ] ; then
    DIALOG_FILE=/tmp/loadTEMP.$$
    DIALOG_CHOICE=/tmp/choiceTEMP.$$
    SYSTEM="RelaxBSD @VERSION@"
    BACKTITLE=$(eval_gettext "\${SYSTEM} -> Load setting")
    MENU=$(gettext "Please select an available settings:")
    echo "${DIALOG} --no-cancel --backtitle \"$BACKTITLE\" \
             --menu \"$MENU\" 12 40 5 \\" > ${DIALOG_FILE}
    for i in `find /mnt -maxdepth 2 -name 'RelaxBSD_*' -type d`; do
        echo "$i \"\" \\" >> ${DIALOG_FILE}
    done
    echo "2> ${DIALOG_CHOICE}" >> ${DIALOG_FILE}
    sh ${DIALOG_FILE}
    IS_PRESENT=`cat ${DIALOG_CHOICE}`
else
    IS_PRESENT=`find /mnt -maxdepth 2 -name 'RelaxBSD_*' -type d | tail -1`
fi
if [ "${IS_PRESENT}" ]; then
    CONFIG_DIR=$IS_PRESENT
    PRINTF1=$(gettext "Using settings from")
    /usr/bin/printf "\033[1;34m$PRINTF1 $CONFIG_DIR... \033[0m"
    . $CONFIG_DIR/${CONFIGFILE_NAME}

    #Set the hostname
    [ "$HOSTNAME" ] && set_hostname

    #Network interfaces setup
    for j in 0 1 2 3 4 5 6 7 
    do
      eval IFACE=\$NETWORK_IFACE$j
      if [ "$IFACE" ]; then
        IFACE_NAME=`echo $IFACE | cut -d, -f 1`
        IFACE_ARGS=`echo $IFACE | cut -d, -f 2`
        set_iface
      fi
    done

    #Default router setup
    [ "$DEFAULTROUTER" ] && set_defaultrouter

    #Other settings
    load_rc_conf
    load_user_env
    load_x11_config
    load_kbdmap_file
    load_ppp_dir
    load_exec_local_daemons
    PRINTF2=$(gettext "[OK]")
    /usr/bin/printf "\033[1;35m$PRINTF2\033[0m\n"
fi
