#!/bin/sh
#
# THIS SOFTWARE IS PROVIDED BY EDSON BRANDI ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED.  IN NO EVENT EDSON BRANDI BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
# OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
# DAMAGE.
#$Id: mount_disks.sh,v 1.5 2004/11/09 10:28:34 rionda Exp $

###############################################
# We will try to detect a set of disks and 
# existing slices and try to mount every 
# FAT16/32, NTFS, UFS, EXT2 partition we find.
###############################################

export PATH="/bin:/sbin:/usr/bin:/usr/sbin:@prefix@/bin:@prefix@/sbin"

MOUNT_OPTION=
UFS_PART=1
MSDOS_PRIMARY=1
NTFS_PRIMARY=1
EXT2FS_PRIMARY=1

MSDOS_LOGICAL=1
NTFS_LOGICAL=1
EXT2FS_LOGICAL=1

USESWAP="NO"

[ -x /etc/lang.sh ] && . /etc/lang.sh
[ -n ${LANG} -a "${LANG}" != "en_US.ISO8859-1" ] && LOCALE="-L ${LANG}"
[ -n ${CHARSET} ] && CHARSET="-C ${CHARSET}"

OPTION=`echo $@`
if [ "${OPTION}" != "rw" -a "${OPTION}" != "ro" ]; then
	echo "Program: mount_disks.sh"
	echo "Parameters:" 
	echo "   - ro mounts partitions in READ ONLY mode;"
	echo "   - rw mounts partitions in READ/WRITE mode."
	exit 1
fi
if [ "${OPTION}" = "ro" ]; then
	MOUNT_OPTION="-o ro"
fi

/bin/df > /tmp/dflog

for i in `egrep "^(ad|ar|da)[0-9]:" /var/run/dmesg.boot | cut -d':' -f1 | sort | uniq`
do
    a=1
    for x in `fdisk /dev/$i | grep sysid | awk -F"," '{print $1}' | awk '{print $2}'`
    do
        case ${x} in
        1|4|6|11|12|13)
            printf "\033[1;34mFAT16/32 partition found at /dev/${i}s${a}, mounting it under /mnt/dos.${MSDOS_PRIMARY} ...\033[0m"
            [ ! -d /mnt/dos.${MSDOS_PRIMARY} ] && mkdir -p /mnt/dos.${MSDOS_PRIMARY}
            mount_msdosfs ${MOUNT_OPTION} ${LOCALE} /dev/${i}s${a} /mnt/dos.${MSDOS_PRIMARY} >/dev/null 2>&1
            MSDOS_PRIMARY=`expr $MSDOS_PRIMARY + 1`
            printf "\033[1;35m[OK]\033[0m\n"
            ;;
        5|15)
            printf "\033[1;34mExtended partition found, trying to detect and mount logical partitions ...\033[0m\n"
            for w in /dev/${i}s* ; do
                y=`echo ${w} | cut -nb 10`
                [ ${y} -lt 5 ] && continue
                filesystem=`disktype ${w} | grep "file system"`
                case $filesystem in
                    FAT*)
                        printf "\033[1;34mFAT32 partition found at ${w}, mounting it under /mnt/dos.ext.${MSDOS_LOGICAL} ...\033[0m"
                        [ ! -d /mnt/dos.ext.${MSDOS_LOGICAL} ] && mkdir -p /mnt/dos.ext.${MSDOS_LOGICAL}
                        mount_msdosfs ${MOUNT_OPTION} ${LOCALE} ${w} /mnt/dos.ext.${MSDOS_LOGICAL} >/dev/null 2>&1
                        MSDOS_LOGICAL=`expr $MSDOS_LOGICAL + 1`
                        printf "\033[1;35m[OK]\033[0m\n"
                        ;;
                    NTFS*)
                        printf "\033[1;34mNTFS partition found at ${w}, mounting it under /mnt/ntfs.ext.${NTFS_LOGICAL} ...\033[0m"
                        mount_ntfs ${CHARSET} ${w} /mnt/ntfs.ext.${NTFS_LOGICAL} >/dev/null 2>&1
                        [ ! -d /mnt/ntfs.ext.${NTFS_LOGICAL} ] && mkdir -p /mnt/ntfs.ext.${NTFS_LOGICAL}
                        mount_ntfs ${CHARSET} ${w} /mnt/ntfs.ext.${NTFS_LOGICAL} >/dev/null 2>&1
                        NTFS_LOGICAL=`expr $NTFS_LOGICAL + 1`
                        printf "\033[1;35m[OK]\033[0m\n"
                        ;;
                    Ext*)
                        printf "\033[1;34mEXT2FS partition found at /dev/${i}s${y}, mounting it under /mnt/ext2fs.ext.${EXT2FS_LOGICAL} ...\033[0m"
                        [ ! -d /mnt/ext2fs.ext.${EXT2FS_LOGICAL} ] && mkdir -p /mnt/ext2fs.ext.${EXT2FS_LOGICAL}
                        mount_ext2fs ${MOUNT_OPTION} /dev/${i}s${y} /mnt/ext2fs.ext.${EXT2FS_LOGICAL} >/dev/null 2>&1
                        EXT2FS_LOGICAL=`expr $EXT2FS_LOGICAL + 1`
                        printf "\033[1;35m[OK]\033[0m\n"
                        ;;
                esac
            done
            ;;
        7)
            printf "\033[1;34mNTFS partition found at /dev/${i}s${a}, mounting it under /mnt/ntfs.${NTFS_PRIMARY} ...\033[0m"
            [ ! -d /mnt/ntfs.${NTFS_PRIMARY} ] && mkdir -p /mnt/ntfs.${NTFS_PRIMARY}
            mount_ntfs ${CHARSET} /dev/${i}s${a} /mnt/ntfs.${NTFS_PRIMARY} >/dev/null 2>&1
            NTFS_PRIMARY=`expr $NTFS_PRIMARY + 1`
            printf "\033[1;35m[OK]\033[0m\n"
            ;;
        131)
            printf "\033[1;34mEXT2FS partition found at /dev/${i}s${a}, mounting it under /mnt/ext2fs.${EXT2FS_PRIMARY} ...\033[0m"
            [ ! -d /mnt/ext2fs.${EXT2FS_PRIMARY} ] && mkdir -p /mnt/ext2fs.${EXT2FS_PRIMARY}
            mount_ext2fs ${MOUNT_OPTION} /dev/${i}s${a} /mnt/ext2fs.${EXT2FS_PRIMARY} >/dev/null 2>&1
            EXT2FS_PRIMARY=`expr $EXT2FS_PRIMARY + 1`
            printf "\033[1;35m[OK]\033[0m\n"
            ;;
        165)
            printf "\033[1;34mUFS partition found at /dev/${i}s${a}, detecting slices...\033[0m\n"
            for j in `disklabel -r /dev/${i}s${a} 2>/dev/null | grep BSD | awk '{print substr($1,1,length($1)-1)}'`
            do
                if [ $UFS_PART -lt 9 ]; then
                  if ! grep "\/dev\/${i}s${a}${j}" /tmp/dflog > /dev/null; then
                    printf "\033[1;34mUFS slice found at /dev/${i}s${a}${j}, mounting it under /mnt/ufs.${UFS_PART}...\033[0m"
                    [ ! -d /mnt/ufs.${UFS_PART} ] && mkdir -p /mnt/ufs.${UFS_PART}
                    mount ${MOUNT_OPTION} /dev/${i}s${a}${j} /mnt/ufs.${UFS_PART} >/dev/null 2>&1
                    UFS_PART=`expr ${UFS_PART} + 1`
                    printf "\033[1;35m[OK]\033[0m\n"
                  fi
                fi
            done
            if [ "$USESWAP" = "NO" ]; then
                k=`disklabel -r /dev/${i}s${a} 2>/dev/null | grep swap | awk '{print substr($1,1,length($1)-1)}' | tail -1`
                if [ -n "${k}" ]; then
                    printf "\033[1;34mSWAP partition found at /dev/${i}s${a},swap it on...\033[0m"
                    swapon /dev/${i}s${a}${k} > /dev/null 2>&1
                    echo "swap on:/dev/${i}s${a}${k}"
                    USESWAP="YES"
                    printf "\033[1;35m[OK]\033[0m\n"
                fi
            fi
            ;;
        esac
        a=`expr $a + 1`
    done
done
rm /tmp/dflog
