#!/bin/sh
#
# Copyright 2005 RelaxBSD All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  1.Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#  2.Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY RelaxBSD ``AS IS'' AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE FREEBSD PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
# OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
# EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# The views and conclusions contained in the software and documentation are
# those of the authors and should not be interpreted as representing official
# policies, either expressed or implied, of the RelaxBSD
#


export PATH="/bin:/sbin:/usr/bin:/usr/sbin:@prefix@/bin:@prefix@/sbin"

wait_partitions() {
  PART_DISC=`ls /dev/${i}s*`
  [ ! "${PART_DISC}" ] && wait_partitions
}

find_free_dir() {
  ID=`/sbin/mount | grep "/mnt/usb.[1-4]" | tail -1 | cut -d\  -f 3 | cut -d. -f 2`
  [ ! "${ID}" ] && ID=0
  NEWID=`expr ${ID} + 1`
  FREEDIR=`echo "/mnt/usb.${NEWID}`
}

[ -x /etc/lang.sh ] && . /etc/lang.sh
[ -n ${LANG} -a "${LANG}" != "en_US.ISO8859-1" ] && LOCALE="-L ${LANG}"
[ -n ${CHARSET} ] && CHARSET="-C ${CHARSET}"

/sbin/camcontrol rescan all > /dev/null
DEVLIST=`/sbin/camcontrol devlist | cut -d\( -f 2 | cut -d\) -f 1 | grep da \
	| sed "s/.*da/da/" | sed "s/,.*//"`
[ ! "${DEVLIST}" ] && exit 0

for i in ${DEVLIST}
do
  wait_partitions
  for j in ${PART_DISC} 
  do
    find_free_dir
    [ ! -d ${FREEDIR} ] && mkdir -p ${FREEDIR} > /dev/null 2>&1
    filesystem=`disktype $j | grep "file system"`
    case $filesystem in
        FAT*)
        mount_msdosfs ${LOCALE} $j ${FREEDIR} >/dev/null 2>&1;;
        NTFS*)
        mount_ntfs ${CHARSET} $j ${FREEDIR} >/dev/null 2>&1;; 
        Ext*)
        mount_ext2fs $j ${FREEDIR} >/dev/null 2>&1;;
        UFS*)
        mount $j ${FREEDIR} >/dev/null 2>&1
    esac
  done
done
