#!/bin/sh
#
# Copyright 2005 RelaxBSD All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  1.Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#  2.Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY RelaxBSD ``AS IS'' AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE FREEBSD PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
# OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
# EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# The views and conclusions contained in the software and documentation are
# those of the authors and should not be interpreted as representing official
# policies, either expressed or implied, of the RelaxBSD
#

export PATH="/bin:/sbin:/usr/bin:/usr/sbin:@prefix@/bin:@prefix@/sbin"

[ -f /etc/ppp/ppp.conf ] && cp /etc/ppp/ppp.conf /etc/ppp/ppp.conf.bak

. gettext.sh
export TEXTDOMAIN=@PACKAGE@
export TEXTDOMAINDIR="@localedir@"
TMP=/tmp
SYSTEM="RelaxBSD @VERSION@"
PPPCONF="/etc/ppp/ppp.conf"
RCCONF="/etc/rc.conf"
CANCELLABEL=$(gettext "Return")

DIALOG="@DIALOG@"

export PATH

dns_function ()
{
gettext "Please enter the IP address of your ISP's primary DNS server." > $TMP/txtTEMP$$
echo >> $TMP/txtTEMP$$
gettext "It's important that these IP numbers be correct." >> $TMP/txtTEMP$$
gettext "The IP numbers should not be: 0.0.0.0 " >> $TMP/txtTEMP$$
echo >> $TMP/txtTEMP$$
gettext "Note: Your service provider's technical support can provide you with this information." >> $TMP/txtTEMP$$
echo >> $TMP/txtTEMP$$
backtitle=$(eval_gettext "\$SYSTEM -> DNS IP ADDRESS ...")
$DIALOG --clear --cancel-label "$CANCELLABEL" --backtitle "$backtitle" --inputbox "`cat $TMP/txtTEMP$$`" 11 74 2> $TMP/rspTEMP$$

if [ $? = 1 ]; then
rm -f $TMP/*TEMP*
clear 2>/dev/null || echo
#gettext "PPP configuration cancelled."
menu_main 
fi 

DNSIP="`cat $TMP/rspTEMP$$`"
if [ -n $DNSIP ] ; then
gettext "Please enter the IP address of your ISP's secondary DNS server." > $TMP/txtTEMP$$
echo >> $TMP/txtTEMP$$
gettext "If you just press enter, I will assume there is only one DNS server." >> $TMP/txtTEMP$$
gettext "The IP numbers should not be: 0.0.0.0 " >> $TMP/txtTEMP$$
echo >> $TMP/txtTEMP$$
gettext "Note: Your service provider's technical support can provide you with this information." >> $TMP/txtTEMP$$
echo >> $TMP/txtTEMP$$
backtitle=$(eval_gettext "\$SYSTEM -> DNS IP ADDRESS ...")
$DIALOG --clear --cancel-label "$CANCELLABEL" --backtitle "$backtitle" --inputbox "`cat $TMP/txtTEMP$$`" 11 74 2> $TMP/rspTEMP$$
if [ $? = 1 ]; then
rm -f $TMP/*TEMP*
clear 2>/dev/null || echo
#gettext "PPP configuration cancelled."
menu_main 
fi 

DNSIP2="`cat $TMP/rspTEMP$$`"
fi
if [ -n "$DNSIP" ] ; then
    echo "nameserver $DNSIP" > /etc/resolv.conf
    if [ -n "$DNSIP2" ] ; then
        echo "nameserver $DNSIP2" >> /etc/resolv.conf
    fi
fi
clear 2>/dev/null || echo
}

ppprc ()
{
TITLE=$(gettext "Do you want to connect to internet now?")
YESNO=$(gettext "Setup successfully! You can trying to bring the link up at any time. For example,link up: 'ppp -auto myisp' (See man ppp for more help),link down: 'killall ppp'")
${DIALOG} --title "$TITLE" --yesno "$YESNO" 7 60
[ $? = 0 ] && ppp -auto myisp
TITLE=$(gettext "Do you want to auto link up when bootup?")
YESNO=$(gettext 'To save these configurations,you must run "@prefix@/bin/relaxsavesetting" to save to a disk before reboot.')
${DIALOG} --title "$TITLE" --yesno "$YESNO" 7 60
case $? in
    0)
cat >> $RCCONF << RCCONFEOF
ppp_enable="yes"
ppp_mode="auto" 
ppp_nat="yes"
ppp_profile="myisp" 
RCCONFEOF
;;
esac
}

ppp_function ()
{
backtitle=$(eval_gettext "\$SYSTEM -> PHONE NUMBER ...")
while [ -z "$PHONENUM" ]
do
gettext "To begin setting up your PPP connection, I need to know a few things." > $TMP/txtTEMP$$
gettext "For starters, what is the phone number of your (I)nternet (S)ervice (P)rovider?" >> $TMP/txtTEMP$$ 
echo  >> $TMP/txtTEMP$$ 
	
$DIALOG --cancel-label "${CANCELLABEL}" --backtitle "${backtitle}" --inputbox "`cat $TMP/txtTEMP$$`" 10 75 2> $TMP/rspTEMP$$   

if [ $? = 1 ]; then
rm -f $TMP/*TEMP*
clear 2>/dev/null || echo
#gettext "PPP configuration cancelled."
menu_main
fi 

PHONENUM="`cat $TMP/rspTEMP$$`"
 
if [ -z "$PHONENUM" ]; then
clear 2>/dev/null || echo
rm -f $TMP/*TEMP*
#gettext "PPP configuration cancelled."
#gettext "No phone number."
menu_main
fi
done

backtitle=$(eval_gettext "\$SYSTEM -> MODEM DEVICE ...")
gettext "Where is your modem /dev/cuaa?" > $TMP/txtTEMP$$ 
$DIALOG --cancel-label "${CANCELLABEL}" --backtitle "$backtitle" --menu "`cat $TMP/txtTEMP$$`" 11 60 4 \
cuaa0 "= (COM1: under DOS)" \
cuaa1 "= (COM2: under DOS)" \
cuaa2 "= (COM3: under DOS)" \
cuaa3 "= (COM4: under DOS)" \
2> $TMP/rspTEMP$$

MODEM="`cat $TMP/rspTEMP$$`"
 
 if [ -z $MODEM ]; then
    clear 2>/dev/null || echo
    rm -f $TMP/*TEMP*
#    gettext "PPP configuration cancelled."
    menu_main 
fi

backtitle=$(eval_gettext "\$SYSTEM -> MODEM BAUD RATE ...")
gettext "What baud rate is your modem?" > $TMP/txtTEMP$$
$DIALOG --cancel-label "$CANCELLABEL" --backtitle "$backtitle" --default-item "115200" --menu "`cat $TMP/txtTEMP$$`" 14 72 7 \
460800 "460KBps  - ISDN modem..." \
230400 "230KBps  - 56Kbps modem... or ISDN modem..." \
115200 "115KBps  - 28.8, 33.6, or 56Kbps modem..." \
57600  "57.6KBps - 28.8, 33.6, or 56Kbps modem..." \
38400  "38.4KBps - Hangin ten on the net! 28.8 or 33.6..." \
19200  "19.2KBps - Better known as 14.4..." \
9600   "9600bps  - No comment..." 2> $TMP/rspTEMP$$

BAUDRATE="`cat $TMP/rspTEMP$$`"

if [ -z $BAUDRATE ]; then
clear 2>/dev/null || echo
rm -f $TMP/*TEMP*
#gettext "PPP configuration cancelled."
menu_main 
fi

gettext "Put your Login = Username in the box below." > $TMP/txtTEMP1
echo >> $TMP/txtTEMP1
gettext "Sometimes they want your username or number followed" >> $TMP/txtTEMP1
gettext "by their @domenu_main name like this below." >> $TMP/txtTEMP1
gettext "Example: jerry@foo.boo.com" >> $TMP/txtTEMP1
gettext "Example: 1234567@foo.boo.com" >> $TMP/txtTEMP1
echo >> $TMP/txtTEMP1
gettext "Sometimes the username is two words." >> $TMP/txtTEMP1
gettext "Example: jerry donut" >> $TMP/txtTEMP1
echo >> $TMP/txtTEMP1
gettext "Usally it's just your username like this below." >> $TMP/txtTEMP1
gettext "Example: jerry" >> $TMP/txtTEMP1
echo >> $TMP/txtTEMP1

backtitle=$(eval_gettext "\$SYSTEM -> PAP or CHAP LOGIN? ...")
$DIALOG --cancel-label "$CANCELLABEL" --backtitle "$backtitle" --inputbox "`cat $TMP/txtTEMP1`" 14 64 2> $TMP/rspTEMP1

if [ $? = 1 ]; then
rm -f $TMP/*TEMP*
clear 2>/dev/null || echo
#gettext "PPP configuration cancelled."
menu_main 
fi

if [ ! -s $TMP/rspTEMP1 ]; then   
rm -f $TMP/*TEMP*
clear 2>/dev/null || echo
#gettext "PPP configuration cancelled."
#gettext "No username for pap, chap, or ms-chap given."
menu_main
fi

if [ -s $TMP/rspTEMP1 ]; then 
AUTH1="`cat $TMP/rspTEMP1`"
eval_gettext "User:$AUTH1 " > $TMP/txtTEMP2
gettext "What's the password for the username above?" >> $TMP/txtTEMP2
gettext "Example: Xpi9u87T" >> $TMP/txtTEMP2
backtitle=$(eval_gettext "\$SYSTEM -> PAP or CHAP PASSWORD? ...")
$DIALOG --clear --cancel-label "$CANCELLABEL" --backtitle "$backtitle" --inputbox "`cat $TMP/txtTEMP2`" 9 64 2> $TMP/rspTEMP2
AUTH2="`cat $TMP/rspTEMP2`"
fi
rm -f $TMP/*TEMP*

! [ -s /etc/resolv.conf ] && dns_function

cat > $PPPCONF << EOF_
default:
 set log Phase Chat LCP IPCP CCP tun command
 ident user-ppp VERSION (built COMPILATIONDATE)
 set device /dev/$MODEM
 set speed $BAUDRATE
 set dial "ABORT BUSY ABORT NO\\\sCARRIER TIMEOUT 5 \\
           \"\" AT OK-AT-OK ATE1Q0 OK \\\dATDT\\\T TIMEOUT 40 CONNECT"
 set timeout 180
 enable dns
myisp:
 set phone $PHONENUM
 set authname $AUTH1
 set authkey $AUTH2
 set ifaddr 10.0.0.1/0 10.0.0.2/0 255.255.255.0 0.0.0.0
 add default HISADDR
EOF_
ppprc
}

pppoe_function () {
	if [ -x @prefix@/sbin/pppoe ] ; then
		DISCOVERY_PROGRAM="@prefix@/sbin/pppoe"
	else
		echo $(gettext "Please install port: net/rp-pppoe")
		menu_main
	fi
BACKTITLE=$(eval_gettext "\$SYSTEM -> The Ethernet interface connected to the ADSL modem")
MENU=$(gettext "Select the Ethernet interface connected to the ADSL modem")
echo "${DIALOG}  --clear --item-help --cancel-label \"$CANCELLABEL\" --backtitle \"$BACKTITLE\" --menu \"$MENU\" 10 75 3 \\" > $TMP/menuTEMP$$
for i in  /dev/net/* ; do
ETHDEV="`echo $i | cut -nb 10-`"
ETHTEST=`pciconf -lv | egrep -A 4 "$ETHDEV" | egrep "ethernet"`
if [ -n "$ETHTEST" ] ; then
ETHNAME=`pciconf -lv | egrep -A 4 "$ETHDEV" | egrep "device" | cut -nb 16-`
ETHVENDOR=`pciconf -lv | egrep -A 4 "$ETHDEV" | egrep "vendor" | cut -nb 16-`
ETHNUM=`echo $ETHDEV | wc -w| tr -d " "`

# Begin:Add date:2005.04.18
for mmm in '' ' -U ' ; do
	title=$(gettext "SCANNING DEVICE")
	text=$(eval_gettext "Looking for PPPoE Access Concentrator on \$ETHNAME")
	if test -n "$mmm" ; then
		mmode=$(gettext "(multi-modem mode)")
	fi
	touch $TMP/pppoe.scan
	ifconfig $ETHDEV up
	($DISCOVERY_PROGRAM $mmm -A -I $ETHDEV >> $TMP/$ETHNAME.pppoe ; rm $TMP/pppoe.scan) &
	( time=0 ; while test -f $TMP/pppoe.scan ; do time=`expr $time + 6`; echo $time; sleep 1; done ) | $DIALOG --title "$title" --gauge "$text $mmode" 10 60 0
	true
done
# End:Add date:2005.04.18
echo "$ETHDEV $ETHNAME $ETHVENDOR \\" >> $TMP/menuTEMP$$
fi
done
# Begin:Add date:2005.04.19
cd "$TMP"
ETHDEV=`grep -l AC *.pppoe| cut -f1 -d"." | head -n1`
#ifacenocomma=$(echo $iface | sed -e 's/,/\\,/g')

if test -z "$ETHDEV" ; then
	title=$(gettext 'NOT CONNECTED')
    backtitle=$(eval_gettext "\$SYSTEM -> Can't find any ADSL modem")
	text=$(eval_ngettext \
        'Sorry, I scanned $ETHNUM interface(s), but the Access Concentrator of your provider did not respond. Please check your network and  modem cables. Another reason for the scan failure may also be another running pppoe process which controls the modem.Do you still want to continue ?')
	 $DIALOG --title "$title" --clear --backtitle "$backtitle" --yesno "$text" 10 60
	 [ $? = "1" ] && (rm $TMP/*pppoe* ; menu_main)
# End:Add date:2005.04.19
echo "2> $TMP/rspTEMP$$" >> $TMP/menuTEMP$$
sh $TMP/menuTEMP$$
ETHDEV=`cat $TMP/rspTEMP$$`
if [ $? = 1 ] ; then
rm -f $TMP/*TEMP*
clear 2> /dev/null || echo
menu_main
fi
else
	title=$(gettext 'DSL CONNECTION FOUND')
	text=$(eval_gettext 'I found an Access Concentrator on $ETHDEV. Should I setup PPPOE for this connection?')
	$DIALOG --title "$title" --clear --yesno "$text" 15 60
	[ $? = "1" ] && (rm $TMP/*pppoe* ; menu_main)
fi

gettext "Welcome to the RelaxBSD ADSL client setup." > $TMP/textTEMP1
gettext "Now, please enter some information" >> $TMP/textTEMP1
gettext "Enter your PPPoE user name:" >> $TMP/textTEMP1

BACKTITLE=$(eval_gettext "\$SYSTEM -> USER NAME")
$DIALOG --cancel-label "$CANCELLABEL" --backtitle "$BACKTITLE" --inputbox "`cat $TMP/textTEMP1`" 9 64 2> $TMP/rspTEMP1

if [ $? = 1 ]; then
	rm -f $TMP/*TEMP*
	clear 2>/dev/null || echo
#	gettext "PPPoE configuration cancelled."
	menu_main
fi
                                                                                                             
if [ ! -s $TMP/rspTEMP1 ]; then
	rm -f $TMP/*TEMP*
	clear 2>/dev/null || echo
#	gettext "PPPoE configuration cancelled."
#	gettext "No username for PPPoE client."
	menu_main
fi
                                                          
if [ -s $TMP/rspTEMP1 ]; then
	AUTH1="`cat $TMP/rspTEMP1`"
	eval_gettext "User:$AUTH1. " > $TMP/txtTEMP2
	gettext "What's the password for the username above?" >> $TMP/txtTEMP2
	gettext "Example: Xpi9u87T" >> $TMP/txtTEMP2
	BACKTITLE=$(eval_gettext "\$SYSTEM -> PPPoE PASSWORD")
	$DIALOG --cancel-label "$CANCELLABEL" --backtitle "$BACKTITLE" --inputbox "`cat $TMP/txtTEMP2`" 9 64 2> $TMP/rspTEMP2
	AUTH2="`cat $TMP/rspTEMP2`"
fi

rm $TMP/*TEMP*
! [ -s /etc/resolv.conf ] && dns_function

cat > $PPPCONF << EOF_
default:
 set log Phase Chat LCP IPCP CCP tun command
 ident user-ppp VERSION (built COMPILATIONDATE)
 set device PPPoE:$ETHDEV
 set speed sync
 set mru 1492
 set mtu 1492
 set ctsrts off
 set timeout 180
 disable lqr
 deny lqr
 add default HISADDR
 enable dns
myisp:
 set authname $AUTH1
 set authkey $AUTH2
 set dial
 set login
 set ifaddr 10.0.0.1/0 10.0.0.2/0
 nat enable yes
EOF_
ppprc
}

netconf ()
{
BACKTITLE=$(eval_gettext "\$SYSTEM -> Configure additional network interfaces")
MENU=$(gettext "Select the ethernet device")
echo "${DIALOG}  --clear --item-help --cancel-label \"$CANCELLABEL\" --backtitle \"$BACKTITLE\" --menu \"$MENU\" 10 75 3 \\" > $TMP/menuTEMP$$
for i in  /dev/net/* ; do
  ETHDEV="`echo $i | cut -nb 10-`"
  ETHTEST=`pciconf -lv | egrep -A 4 "$ETHDEV" | egrep "ethernet"`
  if [ -n "$ETHTEST" ] ; then
   ETHNAME=`pciconf -lv | egrep -A 4 "$ETHDEV" | egrep "device" | cut -nb 16-`
   ETHVENDOR=`pciconf -lv | egrep -A 4 "$ETHDEV" | egrep "vendor" | cut -nb 16-`
   ETHNUM=`echo $ETHDEV | wc -w| tr -d " "`
   echo "$ETHDEV $ETHNAME $ETHVENDOR \\" >> $TMP/menuTEMP$$
  fi
done
echo "2> $TMP/rspTEMP$$" >> $TMP/menuTEMP$$
sh $TMP/menuTEMP$$
  ETHDEV=`cat $TMP/rspTEMP$$`
  if [ $? = 1 ] ; then
	  rm -f $TMP/*TEMP*
	  clear 2> /dev/null || echo
	  menu_main
  fi
TITLE=$(gettext "User Confirmation Requested")
YESNO=$(gettext "Do you want to disable DHCP service of the interface?")
${DIALOG} --title "$TITLE" --yesno "$YESNO" 6 50
case $? in
    1)
    menu_main;;
esac
eval_gettext "Configure for \$ETHDEV interface" > $TMP/txt2TEMP$$
gettext " At first,please enter the IPv4 Address of your ethernet interface." >> $TMP/txt2TEMP$$
gettext "For example:192.168.1.90" >> $TMP/txt2TEMP$$
echo >> $TMP/txt2TEMP$$
backtitle=$(eval_gettext "\$SYSTEM -> Network Configuration")
$DIALOG --clear --cancel-label "$CANCELLABEL" --backtitle "$backtitle" --inputbox "`cat $TMP/txt2TEMP$$`" 9 74 "192.168.1.90" 2> $TMP/rsp2TEMP$$
[ "$?" = "1" ] && menu_main
IPV4=`cat $TMP/rsp2TEMP$$`
rm $TMP/*TEMP*
[ -z $IPV4 ] && menu_main

gettext "Please enter the Netmask of your ethernet interface." > $TMP/txt3TEMP$$
gettext "For example:255.255.255.0" >> $TMP/txt3TEMP$$
echo >> $TMP/txt3TEMP$$
$DIALOG --clear --cancel-label "$CANCELLABEL" --backtitle "$backtitle" --inputbox "`cat $TMP/txt3TEMP$$`" 9 74 "255.255.255.0" 2> $TMP/rsp3TEMP$$
[ "$?" = "1" ] && menu_main
NETMASK=`cat $TMP/rsp3TEMP$$`
rm $TMP/*TEMP*
[ -z $NETMASK ] && menu_main

gettext "Please enter the IPv4 Gateway:" >> $TMP/txt4TEMP$$
gettext "For example:192.168.1.1" >> $TMP/txt4TEMP$$
echo >> $TMP/txt4TEMP$$
$DIALOG --clear --cancel-label "$CANCELLABEL" --backtitle "$backtitle" --inputbox "`cat $TMP/txt4TEMP$$`" 8 74 "192.168.1.1" 2> $TMP/rsp4TEMP$$
[ "$?" = "1" ] &&  menu_main
GATEWAY=`cat $TMP/rsp4TEMP$$`
rm $TMP/*TEMP*
[ -z $NETMASK ] && menu_main
[ -f /var/run/dhclient.pid ] && kill -INT `cat /var/run/dhclient.pid`
ifconfig $ETHDEV inet $IPV4 netmask $NETMASK
route add default $GATEWAY
if [ ! -f /etc/resolv.conf ]; then
YESNO=$(gettext "Do you want to configure /etc/resolv.conf?")
${DIALOG} --defaultno --yesno "$YESNO" 5 50
[ "$?" == "0" ] && dns_function
fi

TITLE=$(gettext "Do you want to save configuration to /etc/rc.conf?")
YESNO=$(gettext 'To save all these configurations,you must run "@prefix@/bin/relaxsavesetting" to save to a disk before reboot.')
${DIALOG} --title "$TITLE" --yesno "$YESNO" 7 60
case $? in
    0)
sed -e '/NIC/d' $RCCONF > $TMP/rcTEMP.$$
cp -f $TMP/rcTEMP.$$ $RCCONF
rm /tmp/*TEMP*
cat >> $RCCONF << RCCONFEOF
ifconfig_$ETHDEV="inet $IPV4 netmask $NETMASK"
defaultrouter="$GATEWAY"
RCCONFEOF
;;
   esac
    
}

menu_main ()
{
BACKTITLE=$(eval_gettext "\$SYSTEM -> Configure network interface")
MENU=$(gettext "Please choose a type of network interface")
PPPLOG=$(gettext "Configure User-ppp")
PPPOELOG=$(gettext "Configure PPP over Ethernet daemon (PPPoE for ADSL)")
ETHLOG=$(gettext "Configure ethernet interface")
NOLOG=$(gettext "I don't want to configure any network interface now")
$DIALOG --clear --backtitle "$BACKTITLE" \
        --menu "$MENU" 11 60 4 \
        "PPP" "$PPPLOG" \
        "PPPoE" "$PPPOELOG" \
	"Ethernet" "$ETHLOG" \
        "No" "$NOLOG" 2> /tmp/menuTEMP$$

retval=$?
choice=`cat /tmp/menuTEMP$$`
rm -f /tmp/menuTEMP$$
case $retval in
  0)
    case $choice in
       PPP)
          ppp_function
          ;;
       PPPoE)
          pppoe_function
          ;;
       Ethernet)
          netconf
	  ;;
       No)
          clear 2>/dev/null || echo
          exit 0
	  ;;
    esac
    ;;
  1)
    clear 2>/dev/null || echo
    exit 0
esac
}
menu_main
