#!/bin/sh
#
# Copyright 2002-2005 G.U.F.I. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  1.Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#  2.Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation 
#    and/or other materials provided with the distribution. 
#
# THIS SOFTWARE IS PROVIDED BY G.U.F.I. ``AS IS'' AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE FREEBSD PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
# OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
# EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# The views and conclusions contained in the software and documentation are
# those of the authors and should not be interpreted as representing official
# policies, either expressed or implied, of the G.U.F.I.
#
# $Id: media_restore.sh,v 1.4 2005/04/26 17:22:46 rionda Exp $
#MOUNTPOINT="/mnt/floppy"

[ ! -f /RelaxBSD/COPYRIGHT.RelaxBSD ] && exit 0

export PATH="/bin:/sbin:/usr/bin:/usr/sbin:@prefix@/bin:@prefix@/sbin"

. gettext.sh
export TEXTDOMAIN=@PACKAGE@
export TEXTDOMAINDIR="@localedir@"

DIALOG="@DIALOG@"

MD5_DIR=@prefix@/
#MD5_ETC=etc.md5
MD5_ROOT=root.md5

#echo "Trying to mount /dev/fd0 on ${MOUNTPOINT}..."
#mount -t msdos /dev/fd0 ${MOUNTPOINT}
#if [ $? = 0 ]; then
#    echo "Ok."
#else
#    echo "failed. Exiting..."
#    exit 1
#fi;

MEDIA_SET="NO"

NFS_HOST_TMP=`/usr/bin/mktemp -t nfs_host`
NFS_MOUNTPOINT_TMP=`/usr/bin/mktemp -t nfs_mountpoint`
FTP_SETUP() {
DIALINFO=$(gettext "RelaxBSD liveCD - Choose your NFS server")
INPUTBOX=$(gettext "NFS Hostname or IP Address")
    ${DIALOG} --title "$DIALINFO" \
    --inputbox "$INPUTBOX" 9 50 \
    "" 2> $NFS_HOST_TMP
    NFS_HOST=`cat $NFS_HOST_TMP`
    rm $NFS_HOST_TMP
DIALINFO=$(gettext "RelaxBSD liveCD - Choose your NFS mountpoint")
INPUTBOX=$(gettext "Mountpoint")
    ${DIALOG} --title "$DIALINFO" \
    --inputbox "$INPUTBOX" 9 50 \
    "" 2> $NFS_MOUNTPOINT_TMP
    NFS_MOUNTPOINT_TMP=`cat $NFS_MOUNTPOINT_TMP`
    rm $NFS_MOUNTPOINT_TMP
}
        
FTP_HOST_TMP=`/usr/bin/mktemp -t ftp_host`
FTP_USER_TMP=`/usr/bin/mktemp -t ftp_user`
FTP_PASS_TMP=`/usr/bin/mktemp -t ftp_pass`
FTP_SETUP() {
DIALINFO=$(gettext "RelaxBSD liveCD - Choose your ftp server")
INPUTBOX=$(gettext "FTP Hostname or IP Address")
    ${DIALOG} --title "$DIALINFO" \
    --inputbox "$INPUTBOX" 9 50 \
    "" 2> $FTP_HOST_TMP
    FTP_HOST=`cat $FTP_HOST_TMP`
    rm $FTP_HOST_TMP
DIALINFO=$(gettext "RelaxBSD liveCD - Choose your ftp username")
INPUTBOX=$(gettext "Username")
    ${DIALOG} --title "$DIALINFO" \
    --inputbox "$INPUTBOX" 9 50 \
    "" 2> $FTP_USER_TMP
    FTP_USER=`cat $FTP_USER_TMP`
    rm $FTP_USER_TMP
    # ATTENTION
    # Inputbox is not a Passwordbox (the password entered is 
    # displayed!!!!)
    #
DIALINFO=$(gettext "RelaxBSD liveCD - Choose your ftp password")
INPUTBOX=$(gettext "Password")
    ${DIALOG} --title "$DIALINFO" \
    --inputbox "$INPUTBOX" 9 50 \
    "" 2> $FTP_PASS_TMP
    FTP_PASS=`cat $FTP_PASS_TMP`
    rm $FTP_PASS_TMP
}

SMB_HOST_TMP=`/usr/bin/mktemp -t smb_host`
SMB_USER_TMP=`/usr/bin/mktemp -t smb_user`
SMB_PASS_TMP=`/usr/bin/mktemp -t smb_pass`
SMB_MOUNTPOINT_TMP=`/usr/bin/mktemp -t smb_mountpoint`

SMB_SETUP() {
DIALINFO=$(gettext "RelaxBSD liveCD - Choose your SMB server")
INPUTBOX=$(gettext "SMB Hostname or IP Address")
    ${DIALOG} --title "$DIALINFO" \
    --inputbox "$INPUTBOX" 9 50 \
    "" 2> $SMB_HOST_TMP
    SMB_HOST=`cat $SMB_HOST_TMP`
    rm $SMB_HOST_TMP
DIALINFO=$(gettext "RelaxBSD liveCD - Choose your SMB username")
INPUTBOX=$(gettext "Username")
    ${DIALOG} --title "$DIALINFO" \
    --inputbox "$INPUTBOX" 9 50 \
    "" 2> $SMB_USER_TMP
    SMB_USER=`cat $SMB_USER_TMP`
    rm $SMB_USER_TMP
DIALINFO=$(gettext "RelaxBSD liveCD - Choose your SMB password")
INPUTBOX=$(gettext "Password")
    ${DIALOG} --title "$DIALINFO" \
    --inputbox "$INPUTBOX" 9 50 \
    "" 2> $SMB_PASS_TMP
    SMB_PASS=`cat $SMB_PASS_TMP`
    rm $SMB_PASS_TMP
DIALINFO=$(gettext "RelaxBSD liveCD - Choose your SMB username")
INPUTBOX=$(gettext "Username")
    ${DIALOG} --title "$DIALINFO" \
    --inputbox "$INPUTBOX" 9 50 \
    "" 2> $SMB_USER_TMP
    SMB_MOUNTPOINT=`cat $SMB_MOUNTPOINT_TMP`
    rm $SMB_MOUNTPOINT_TMP
}

LOCAL_SETUP() {
DIALMENU=$(gettext "RelaxBSD Local Backup")
QLOG=$(gettext "Quit")
    ${DIALOG} --menu "$DIALMENU" 13 42 3 \
        "*" "$DEV_STR" \
        Q "$QLOG" \
        2> /tmp/me
}

REMOTE_TMP=`/usr/bin/mktemp -t remote`
REMOTE_SETUP() {
DIALINFO=$(gettext "RelaxBSD liveCD - Choose your protocol")
ALOG=$(gettext "FTP Server")
NLOG=$(gettext "NFS Host")
SLOG=$(gettext "SMB Host")
QLOG=$(gettext "Quit")
    ${DIALOG} --menu "$DIALINFO" 13 42 4 \
        A "$ALOG" \
        N "$NLOG" \
        S "$SLOG" \
        Q "$QLOG" \
    2> $REMOTE_TMP
    case `cat $REMOTE_TMP` in
        A)
            MEDIA_PROTO="FTP"
            FTP_SETUP
            ;;
        N)
            MEDIA_PROTO="NFS"
            NFS_SETUP
            ;;
        S)
            MEDIA_PROTO="SMB"
            SMB_SETUP
            ;;
        Q)
				@prefix@/bin/relaxconf
	;;
        esac
        rm $REMOTE_TMP
}

SITE_TMP=`/usr/bin/mktemp -t site`
CHOOSE_MEDIA() {
    DA_DEV=`mount | grep "usb." | cut -d\  -f 1 | cut -d\/ -f 3""`
    DEV_STR=`camcontrol devlist | grep da0 | cut -d\> -f 1 | cut -d\< -f 2`
DIALINFO=$(gettext "RelaxBSD liveCD - Choose your site")
ALOG=$(gettext "Remote Site")
QLOG=$(gettext "Quit")
    ${DIALOG} --menu "$DIALINFO" 13 42 3 \
        A "$ALOG" \
        L "$DEV_STR" \
        Q "$QLOG" \
    2> $SITE_TMP
    case `cat $SITE_TMP` in
        A)
            MEDIA_TYPE="REMOTE"
            REMOTE_SETUP
            ;;
        L)
            MEDIA_TYPE="LOCAL"
            MOUNTPOINT="$DA_DEV"
	;;
			Q)
				@prefix@/bin/relaxconf
            ;;
        esac
        rm $SITE_TMP
        MEDIA_SET="YES"
}

MENU_TMP=`/usr/bin/mktemp -t menu`
menu() {
DIALINFO=$(gettext "RelaxBSD Media Backup")
MLOG=$(gettext "Choose media type")
RLOG=$(gettext "Restore /root")
QLOG=$(gettext "Quit")
    ${DIALOG} --menu "$DIALINFO" 13 42 3 \
        M "$MLOG" \
        R "$RLOG" \
        Q "$QLOG" \
    2> $MENU_TMP
    case `cat $MENU_TMP` in
        M)
        CHOOSE_MEDIA
        menu
        ;;
			Q)
				@prefix@/bin/relaxconf
		;;
        R)
        if [ "$MEDIA_SET" = "NO" ]; then
DIALINFO=$(gettext "First you have to select a media.")
            ${DIALOG} --msgbox "$DIALINFO" 9 50 
            menu     
        fi

        case $MEDIA_TYPE in
            REMOTE)
            case $MEDIA_PROTO in
                FTP)
                PWD=`pwd`
                cd /tmp
		[ -e root.tar.bz2 ] && rm root.tar.bz2
                ftp -A ftp://$FTP_USER:$FTP_PASS@$FTP_HOST/relaxbsd/root.tar.bz2 > /dev/null 2>&1
                if [ "$?" != "0" ]; then
DIALINFO=$(gettext "Error while transferring data.")
                    ${DIALOG} --msgbox "$DIALINFO" 9 50 
                else
DIALINFO=$(gettext "Data transferred successfull.")
                    ${DIALOG} --msgbox "$DIALINFO" 9 50 
                fi
                tar jxvf root.tar.bz2 -C / > /dev/null 2>&1
                rm root.tar.bz2
                cd $PWD
                exit
                ;;
            esac
            ;;
            LOCAL)
            # USB Devices
            # Mounted with /sbin/umass_mount.sh
            #Retriving device name (e.g. da0)
            tar jcvpf ${MOUNTPOINT}/root.tar.bz2 -T /tmp/root_files.tmp
            rm tmp/root_files.tmp
            ;;
        esac
        ;;

        Q)
        umount ${MOUNTPOINT}
        exit 0       
        ;;

        *)
        exit 0
    esac
    #rm $MENU_TMP
}
menu
#umount ${MOUNTPOINT}
