#!/bin/sh
#
# Modified by hamigua <relaxbsd@yahoo.com>
#
# Copyright 2002-2005 G.U.F.I. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  1.Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#  2.Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation 
#    and/or other materials provided with the distribution. 
#
# THIS SOFTWARE IS PROVIDED BY G.U.F.I. ``AS IS'' AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE FREEBSD PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
# OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
# EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# The views and conclusions contained in the software and documentation are
# those of the authors and should not be interpreted as representing official
# policies, either expressed or implied, of the G.U.F.I.
#
#$Id: save_settings.sh,v 1.6 2005/04/26 17:22:46 rionda Exp $

[ ! -f /RelaxBSD/COPYRIGHT.RelaxBSD ] && exit 0

export PATH="/bin:/sbin:/usr/bin:/usr/sbin:@prefix@/bin:@prefix@/sbin"

IFACE_COUNTER="0"
CONFIGFILE_NAME="relaxbsd_settings.conf"
PARTITION=""
SYSTEM="RelaxBSD @VERSION@"
TMP="/tmp"
. gettext.sh
export TEXTDOMAIN=@PACKAGE@
export TEXTDOMAINDIR="@localedir@"

DIALOG="@DIALOG@"

set_defaultrouter() {
  #Set the default router if different from rc.conf setting
  gettext "Saving the defaultrouter setting... " ; echo -n
  DEFAULTROUTER=`netstat -rn | grep default | awk '{print $2;}'`
  DEF_ROUTER_RC=`grep defaultrouter /etc/rc.conf | cut -d\" -f 2`
  [ "${DEFAULTROUTER}" ] &&                           \
  [ "${DEFAULTROUTER}" != "${DEF_ROUTER_RC}" ] &&     \
  echo "DEFAULTROUTER=\"$DEFAULTROUTER\"" >>          \
                        $PARTITION/$CONFIGFILE_NAME
  gettext "[OK]" ; echo
}

save_user_env() {
#Save user environment selection
gettext "Saving your preferred environment... " ; echo -n
[ -r /root/.relaxconf ] && touch $PARTITION/.relaxconf
[ -L /root/.xinitrc ] && cp -RL /root/.xinitrc $PARTITION/.xinitrc
[ -r /root/.tcshrc ] && cp /root/.tcshrc $PARTITION/.tcshrc
[ -L /root/.muttrc ] && cp /root/.muttrc $PARTITION/.muttrc
  gettext "[OK]" ; echo
}

save_x11_config_file() {
  [ -f /etc/X11/xorg.conf ] && cp /etc/X11/xorg.conf $PARTITION/xorg.conf
  [ -f /etc/X11/XF86Config-4 ] && cp /etc/X11/XF86Config-4 $PARTITION/XF86Config-4
}

save_kbdmap_file() {
  [ -f /tmp/kbdmap.conf ] && cp /tmp/kbdmap.conf $PARTITION/kbdmap.conf
}

save_lang_choice() {
gettext "Saving your language choice..." ; echo -n
if [ -x /etc/lang.sh ]; then
   cp /etc/lang.sh $PARTITION/lang.sh
   chmod a+x $PARTITION/lang.sh
fi
if [ -x /etc/lang.csh ]; then
   cp /etc/lang.csh $PARTITION/lang.csh
   chmod a+x $PARTITION/lang.csh
fi
  gettext  "[OK]" ; echo
}

set_hostname() {
  #Set the hostname if different from rc.conf setting
  gettext "Saving the hostname setting... " ; echo -n
  HOSTNAME=`hostname`
  [ "${HOSTNAME}" ] && echo "HOSTNAME=\"$HOSTNAME\"" >> \
                                    $PARTITION/$CONFIGFILE_NAME
  gettext "[OK]" ; echo
}
write_iface_config() {
  #$i is the iface id
  IFACE_ARGS=`ifconfig $i | grep inet\ | awk '  \
    {                                           \
      for (i=1; i<= NF; i++)                    \
        print $i;                               \
    }                                           \
  ' | xargs`
  echo "NETWORK_IFACE${IFACE_COUNTER}=\"${i},${IFACE_ARGS}\"" >>  \
  $PARTITION/$CONFIGFILE_NAME
  IFACE_COUNTER=`expr $IFACE_COUNTER + 1`
}

save_iface_config() {
  #Set the nic informations if not dhcp'ed
  gettext "Saving network interfaces settings... " ; echo -n
  IFACES_NAME=`ifconfig -a | grep flags | cut -d: -f 1`
  for i in $IFACES_NAME
  do
       # List of dhcp'ed ifaces
       IFACE_DHCPED=`ps -x | grep dhclient | grep $i`
       if [ "${IFACE_DHCPED}" ]; then
	       # If $i has an ip like 0.0.0.0 probably there is no dhcpd around.
	       IFACE_INET=`ifconfig $i | awk '{if ($1=="inet") print $2}'`
	       if [ "${IFACE_INET}" = "0.0.0.0" ]; then
  	             write_iface_config
               fi
       else
	       # User stopped dhcpd on this interface and
	       # preferred to use a static ip address.
	       write_iface_config
    fi
  done
  gettext "[OK]" ; echo
}

save_rc_conf() {
  gettext "Saving rc.conf... " ; echo -n
  cp /etc/rc.conf $PARTITION/rc.conf
  gettext "[OK]" ; echo
}

save_exec_local_daemons() {
  gettext "Saving local daemons... " ; echo -n
  basename `find @prefix@/etc/rc.d/ -name '*sh' -type f -perm -555` \
		> $PARTITION/local_daemons.txt
  gettext "[OK]" ; echo
}

save_ppp_dir() {
  gettext "Saving ppp settings... " ; echo -n
  mkdir -p $PARTITION/ppp
  cp -r /etc/ppp $PARTITION
  [ -r /etc/resolv.conf ] && cp /etc/resolv.conf $PARTITION
  gettext "[OK]" ; echo
}

check_new_or_append() {
  #if the file exists, ask for action
  if [ -f "$PARTITION/$CONFIGFILE_NAME" ]; then
    SAVECHOOSE="$TMP/saveTEMP2.$$"
    BACKTITLE=$(eval_gettext "\${SYSTEM} -> Found an existing RelaxBSD config file")
    MENU=$(gettext "what do you want to do ?")
    OVERWRITELOG=$(gettext "Overwrite")
    APPENDLOG=$(gettext "Append")
    ${DIALOG} --backtitle "$BACKTITLE" --no-cancel \
              --menu "$MENU" 11 40 3 \
	     "Overwrite" "$OVERWRITELOG" \
	     "Append" "$APPENDLOG" 2> ${SAVECHOOSE}
	     retval=$?
	     choice=`cat ${SAVECHOOSE}`
  case $retval in
  0)
    if [ "$choice" = "Overwrite" ] ; then
         rm ${PARTITION}/${CONFIGFILE_NAME}
         touch ${PARTITION}/${CONFIGFILE_NAME}
         chmod a+x ${PARTITION}/${CONFIGFILE_NAME}
    fi
    ;;
  1)
    exit 0;;
 esac
fi
  echo -n "#RelaxBSD save_settings.sh script launched at: " \
      >> ${PARTITION}/${CONFIGFILE_NAME}
  date  >> ${PARTITION}/${CONFIGFILE_NAME}
  chmod a+x ${PARTITION}/${CONFIGFILE_NAME}
}

check_location() {
DIALOG_FILE="$TMP/dialogTEMP.$$"
SAVECHOOSE="$TMP/saveTEMP.$$"
GOOD_PARTS=`mount | grep mnt | egrep "ext2fs|msdosfs|ntfs|ufs" | \
           cut -d\  -f 1`
MOUNTED_PARTS=`mount | grep mnt | egrep "ext2fs|msdosfs|ntfs|ufs" \
              | cut -d\  -f 3`
SYSTEM="RelaxBSD @VERSION@"
BACKTITLE=$(eval_gettext "\${SYSTEM} -> Save setting")
MENU=$(gettext "Please select an available partitions:")
echo "${DIALOG} --backtitle \"$BACKTITLE\" --item-help \
             --menu \"$MENU\" 12 40 5 \\" > ${DIALOG_FILE}
# print $6 "\t\"" $1 "\"  \t\"" $2 "\ " $3 "\ " $4 "\ " $5 "\" \\"
df -h $GOOD_PARTS | awk -v SIZE=$(gettext "Size:") \
			-v USED=$(gettext "Used:") \
			-v AVAIL=$(gettext "Avail:") \
			-v CAPACITY=$(gettext "Capacity:") \
			'{
                         if ($1 != "Filesystem") {
                             print $6 "\t\"" $1 "\" \t\""SIZE$2 "\ "USED$3 "\ "AVAIL$4 "\ "CAPACITY$5 "\" \\";
                             }
}' >> $DIALOG_FILE
echo "2> ${SAVECHOOSE}" >> ${DIALOG_FILE}
sh ${DIALOG_FILE}
[ $? = 1 ] && exit 0
CHOOSEINFO=$(df -h `cat ${SAVECHOOSE}` | awk \
		-v SIZE=$(gettext "Size:") \
		-v USED=$(gettext "Used:") \
		-v AVAIL=$(gettext "Avail:") \
		-v CAPACITY=$(gettext "Capacity:") \
		-v FSYS=$(gettext "Filesystem:") \
		-v MOUNTON=$(gettext "Mounted:") \
	     '{
                if ($1 != "Filesystem") {
                print "" MOUNTON$6 "\ " FSYS$1 "\ " SIZE$2 "\ " USED$3 "\ " AVAIL$4 "\ " CAPACITY$5 "\ "
                }
             }')
TITLE=$(gettext "Do you sure this available partition?")
$DIALOG --title "$TITLE" --clear \
                --yesno "${CHOOSEINFO}" 6 80
case $? in
    0)
        PARTITION=`cat ${SAVECHOOSE}`
        ;;
    1)
        check_location
        ;;
esac
}

make_subdir() {
  mount -uw $PARTITION
  SUBDIR=`date "+%Y%m%d`
  mkdir -p $PARTITION/RelaxBSD_$SUBDIR
  PARTITION=`echo $PARTITION/RelaxBSD_$SUBDIR`
}

check_location
make_subdir
check_new_or_append
set_defaultrouter
set_hostname
save_rc_conf
save_iface_config
save_kbdmap_file
save_x11_config_file
save_exec_local_daemons
save_ppp_dir
save_user_env
PARTITION=$(cd $PARTITION/.. ; pwd)
mount -ur $PARTITION
