#!/bin/sh
#
# Modified by hamigua <relaxbsd@yahoo.com>
#
# Copyright 2002-2005 G.U.F.I. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#  1.Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
#  2.Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation 
#    and/or other materials provided with the distribution. 
#
# THIS SOFTWARE IS PROVIDED BY G.U.F.I. ``AS IS'' AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
# EVENT SHALL THE FREEBSD PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
# OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
# EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# The views and conclusions contained in the software and documentation are
# those of the authors and should not be interpreted as representing official
# policies, either expressed or implied, of the G.U.F.I.
#
# $Id: sound_detect.sh,v 1.4 2005/04/26 17:22:47 rionda Exp $
#
# Detect the audio card and load the appropriate driver

CARD_FILE='@prefix@/share/relaxconf/snd_card_ids.txt'
CARD_IDS=` pciconf -lv | grep ^none | cut -d\  -f 3 | cut -d= -f 2 | xargs -0 echo ""`
for i in $CARD_IDS
do
	SND_DRIVER=`grep $i $CARD_FILE | cut -d: -f 1`
	if [ "$SND_DRIVER" ]; then
		echo -n "Loading $SND_DRIVER.ko... "
		/sbin/kldload /boot/kernel/$SND_DRIVER.ko
		echo "[OK]";
	fi
done
