/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.ELException;
import com.caucho.el.Expr;
import com.caucho.el.VariableResolver;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class BinaryExpr
extends Expr {
    private int _op;
    private Expr _left;
    private Expr _right;

    public BinaryExpr(int op, Expr left, Expr right) {
        this._op = op;
        this._left = left;
        this._right = right;
    }

    public Object evalObject(VariableResolver env) throws ELException {
        long b;
        long a;
        Object aObj = this._left.evalObject(env);
        if (aObj instanceof Float || aObj instanceof Double) {
            double a2 = ((Number)aObj).doubleValue();
            double b2 = this._right.evalDouble(env);
            double dValue = 0.0;
            switch (this._op) {
                case 1: {
                    dValue = a2 + b2;
                    break;
                }
                case 2: {
                    dValue = a2 - b2;
                    break;
                }
                case 3: {
                    dValue = a2 * b2;
                    break;
                }
                case 4: {
                    dValue = a2 / b2;
                    break;
                }
                case 5: {
                    dValue = a2 % b2;
                }
            }
            return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
        }
        Object bObj = this._right.evalObject(env);
        if (aObj == null && bObj == null) {
            return new Integer(0);
        }
        if (bObj instanceof Double || bObj instanceof Double) {
            double a3 = BinaryExpr.toDouble(aObj);
            double b3 = ((Number)bObj).doubleValue();
            double dValue = 0.0;
            switch (this._op) {
                case 1: {
                    dValue = a3 + b3;
                    break;
                }
                case 2: {
                    dValue = a3 - b3;
                    break;
                }
                case 3: {
                    dValue = a3 * b3;
                    break;
                }
                case 4: {
                    dValue = a3 / b3;
                    break;
                }
                case 5: {
                    dValue = a3 % b3;
                }
            }
            return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
        }
        if (aObj instanceof Number) {
            a = ((Number)aObj).longValue();
            b = BinaryExpr.toLong(bObj);
            switch (this._op) {
                case 1: {
                    return new Long(a + b);
                }
                case 2: {
                    return new Long(a - b);
                }
                case 3: {
                    return new Long(a * b);
                }
                case 4: {
                    double dValue = (double)a / (double)b;
                    return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
                }
                case 5: {
                    return new Long(a % b);
                }
            }
        } else if (bObj instanceof Number) {
            a = BinaryExpr.toLong(aObj);
            b = ((Number)bObj).longValue();
            switch (this._op) {
                case 1: {
                    return new Long(a + b);
                }
                case 2: {
                    return new Long(a - b);
                }
                case 3: {
                    return new Long(a * b);
                }
                case 4: {
                    double dValue = (double)a / (double)b;
                    return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
                }
                case 5: {
                    return new Long(a % b);
                }
            }
        }
        if (BinaryExpr.isDoubleString(aObj) || BinaryExpr.isDoubleString(bObj)) {
            double a4 = BinaryExpr.toDouble(aObj);
            double b4 = BinaryExpr.toDouble(bObj);
            switch (this._op) {
                case 1: {
                    return new Double(a4 + b4);
                }
                case 2: {
                    return new Double(a4 - b4);
                }
                case 3: {
                    return new Double(a4 * b4);
                }
                case 4: {
                    double dValue = a4 / b4;
                    return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
                }
                case 5: {
                    return new Double(a4 % b4);
                }
            }
        } else {
            a = BinaryExpr.toLong(aObj);
            b = BinaryExpr.toLong(bObj);
            switch (this._op) {
                case 1: {
                    return new Long(a + b);
                }
                case 2: {
                    return new Long(a - b);
                }
                case 3: {
                    return new Long(a * b);
                }
                case 4: {
                    double dValue = (double)a / (double)b;
                    return Double.isNaN(dValue) ? new Double(0.0) : new Double(dValue);
                }
                case 5: {
                    return new Long(a % b);
                }
            }
        }
        return null;
    }

    private static boolean isDoubleString(Object obj) {
        if (!(obj instanceof String)) {
            return false;
        }
        String s = (String)obj;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch != '.' && ch != 'e' && ch != 'E') continue;
            return true;
        }
        return false;
    }

    public long evalLong(VariableResolver env) throws ELException {
        long a = this._left.evalLong(env);
        long b = this._right.evalLong(env);
        switch (this._op) {
            case 1: {
                return a + b;
            }
            case 2: {
                return a - b;
            }
            case 3: {
                return a * b;
            }
            case 4: {
                return (long)((double)a / (double)b);
            }
            case 5: {
                return a % b;
            }
        }
        dbg.log((Throwable)((Object)new ELException(L.l("error evaluating add {0} and {1}", (Object)String.valueOf(a), String.valueOf(b)))));
        return 0L;
    }

    public double evalDouble(VariableResolver env) throws ELException {
        double a = this._left.evalDouble(env);
        double b = this._right.evalDouble(env);
        switch (this._op) {
            case 1: {
                return a + b;
            }
            case 2: {
                return a - b;
            }
            case 3: {
                return a * b;
            }
            case 4: {
                return a / b;
            }
            case 5: {
                return a % b;
            }
        }
        dbg.log((Throwable)((Object)new ELException(L.l("error evaluating add {0} and {1}", (Object)String.valueOf(a), String.valueOf(b)))));
        return 0.0;
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.BinaryExpr(");
        os.print(this._op + ", ");
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof BinaryExpr)) {
            return false;
        }
        BinaryExpr expr = (BinaryExpr)o;
        return this._op == expr._op && this._left.equals(expr._left) && this._right.equals(expr._right);
    }

    public String toString() {
        String op;
        switch (this._op) {
            case 1: {
                op = " + ";
                break;
            }
            case 2: {
                op = " - ";
                break;
            }
            case 3: {
                op = " * ";
                break;
            }
            case 4: {
                op = " / ";
                break;
            }
            case 5: {
                op = " % ";
                break;
            }
            default: {
                op = " unknown(" + this._op + ") ";
            }
        }
        return "(" + this._left + op + this._right + ")";
    }
}

