/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.AbstractBooleanExpr;
import com.caucho.el.ELException;
import com.caucho.el.Expr;
import com.caucho.el.VariableResolver;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class CmpExpr
extends AbstractBooleanExpr {
    private int _op;
    private Expr _left;
    private Expr _right;

    public CmpExpr(int op, Expr left, Expr right) {
        this._op = op;
        this._left = left;
        this._right = right;
    }

    public boolean evalBoolean(VariableResolver env) throws ELException {
        Object bObj;
        Object aObj = this._left.evalObject(env);
        if (aObj == (bObj = this._right.evalObject(env))) {
            return this._op == 9 || this._op == 11;
        }
        if (aObj instanceof Double || aObj instanceof Float || bObj instanceof Double || bObj instanceof Float) {
            double a = CmpExpr.toDouble(aObj);
            double b = CmpExpr.toDouble(bObj);
            switch (this._op) {
                case 8: {
                    return a < b;
                }
                case 9: {
                    return a <= b;
                }
                case 10: {
                    return a > b;
                }
                case 11: {
                    return a >= b;
                }
            }
        }
        if (aObj instanceof Number || bObj instanceof Number) {
            long a = CmpExpr.toLong(aObj);
            long b = CmpExpr.toLong(bObj);
            switch (this._op) {
                case 8: {
                    return a < b;
                }
                case 9: {
                    return a <= b;
                }
                case 10: {
                    return a > b;
                }
                case 11: {
                    return a >= b;
                }
            }
        }
        if (aObj instanceof String || bObj instanceof String) {
            String a = CmpExpr.toString(aObj);
            String b = CmpExpr.toString(bObj);
            int cmp = a.compareTo(b);
            switch (this._op) {
                case 8: {
                    return cmp < 0;
                }
                case 9: {
                    return cmp <= 0;
                }
                case 10: {
                    return cmp > 0;
                }
                case 11: {
                    return cmp >= 0;
                }
            }
        }
        if (aObj instanceof Comparable) {
            int cmp = ((Comparable)aObj).compareTo(bObj);
            switch (this._op) {
                case 8: {
                    return cmp < 0;
                }
                case 9: {
                    return cmp <= 0;
                }
                case 10: {
                    return cmp > 0;
                }
                case 11: {
                    return cmp >= 0;
                }
            }
        }
        if (bObj instanceof Comparable) {
            int cmp = ((Comparable)bObj).compareTo(aObj);
            switch (this._op) {
                case 8: {
                    return cmp > 0;
                }
                case 9: {
                    return cmp >= 0;
                }
                case 10: {
                    return cmp < 0;
                }
                case 11: {
                    return cmp <= 0;
                }
            }
        }
        dbg.log((Throwable)((Object)new ELException(L.l("can't compare {0} and {1}.", aObj, bObj))));
        return false;
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.CmpExpr(");
        os.print(this._op + ", ");
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof CmpExpr)) {
            return false;
        }
        CmpExpr expr = (CmpExpr)o;
        return this._op == expr._op && this._left.equals(expr._left) && this._right.equals(expr._right);
    }

    public String toString() {
        String op;
        switch (this._op) {
            case 8: {
                op = " lt";
                break;
            }
            case 9: {
                op = " le ";
                break;
            }
            case 10: {
                op = " gt ";
                break;
            }
            case 11: {
                op = " ge ";
                break;
            }
            default: {
                op = " unknown(" + this._op + ") ";
            }
        }
        return "(" + this._left + op + this._right + ")";
    }
}

