/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.ELException;
import com.caucho.el.Expr;
import com.caucho.el.MethodExpr;
import com.caucho.el.VariableResolver;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.Method;

public class StaticMethodExpr
extends Expr {
    private Expr _expr;
    private Expr[] _args;

    public StaticMethodExpr(Expr expr, Expr[] args) {
        this._expr = expr;
        this._args = args;
    }

    public Object evalObject(VariableResolver env) throws ELException {
        Object aObj = this._expr.evalObject(env);
        Method method = null;
        if (aObj instanceof Method) {
            method = (Method)aObj;
        } else if (aObj instanceof Method[]) {
            Method[] methods = (Method[])aObj;
            if (methods.length < this._args.length) {
                return null;
            }
            method = methods[this._args.length];
        }
        if (method == null) {
            return null;
        }
        Class<?>[] params = method.getParameterTypes();
        if (params.length != this._args.length) {
            return null;
        }
        try {
            Object[] objs = new Object[this._args.length];
            for (int i = 0; i < params.length; ++i) {
                objs[i] = MethodExpr.evalArg(params[i], this._args[i], env);
            }
            return method.invoke(aObj, objs);
        }
        catch (ELException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.StaticMethodExpr(");
        this._expr.printCreate(os);
        os.print(", new com.caucho.el.Expr[] {");
        for (int i = 0; i < this._args.length; ++i) {
            if (i != 0) {
                os.print(", ");
            }
            this._args[i].printCreate(os);
        }
        os.println("});");
    }

    public boolean equals(Object o) {
        if (!(o instanceof StaticMethodExpr)) {
            return false;
        }
        StaticMethodExpr expr = (StaticMethodExpr)o;
        if (!this._expr.equals(expr._expr)) {
            return false;
        }
        if (this._args.length != expr._args.length) {
            return false;
        }
        for (int i = 0; i < this._args.length; ++i) {
            if (this._args[i].equals(expr._args[i])) continue;
            return false;
        }
        return true;
    }
}

