/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.ELException;
import com.caucho.el.Expr;
import com.caucho.el.VariableResolver;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;

public class UnaryExpr
extends Expr {
    private int _op;
    private Expr _expr;

    public UnaryExpr(int op, Expr expr) {
        this._op = op;
        this._expr = expr;
    }

    public Object evalObject(VariableResolver env) throws ELException {
        switch (this._op) {
            case 14: {
                return new Boolean(!this._expr.evalBoolean(env));
            }
            case 15: {
                Object obj = this._expr.evalObject(env);
                if (obj == null) {
                    return new Long(0L);
                }
                if (obj instanceof Double || obj instanceof Float) {
                    return new Double(-((Number)obj).doubleValue());
                }
                if (obj instanceof Number) {
                    return new Long(-((Number)obj).longValue());
                }
                return new Double(-UnaryExpr.toDouble(obj));
            }
            case 16: {
                if (this.evalBoolean(env)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        throw new UnsupportedOperationException();
    }

    public boolean evalBoolean(VariableResolver env) throws ELException {
        switch (this._op) {
            case 14: {
                return !this._expr.evalBoolean(env);
            }
            case 16: {
                Object obj = this._expr.evalObject(env);
                if (obj == null) {
                    return true;
                }
                if (obj instanceof String) {
                    return "".equals(obj);
                }
                if (obj instanceof Map) {
                    return ((Map)obj).isEmpty();
                }
                if (obj instanceof List) {
                    return ((List)obj).isEmpty();
                }
                if (obj.getClass().isArray()) {
                    return Array.getLength(obj) == 0;
                }
                return false;
            }
        }
        dbg.log((Throwable)((Object)new ELException(L.l("can't compare."))));
        return false;
    }

    public long evalLong(VariableResolver env) throws ELException {
        if (this._op != 15) {
            dbg.log((Throwable)((Object)new ELException(L.l("'not' and 'empty' operations can not be converted to long values."))));
            return 0L;
        }
        return -this._expr.evalLong(env);
    }

    public double evalDouble(VariableResolver env) throws ELException {
        if (this._op != 15) {
            dbg.log((Throwable)((Object)new ELException(L.l("'not' and 'empty' operations can not be converted to double values."))));
            return 0.0;
        }
        return -this._expr.evalDouble(env);
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.UnaryExpr(");
        os.print(this._op + ", ");
        this._expr.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof UnaryExpr)) {
            return false;
        }
        UnaryExpr uexpr = (UnaryExpr)o;
        return this._op == uexpr._op && this._expr.equals(uexpr._expr);
    }

    public String toString() {
        String op;
        switch (this._op) {
            case 15: {
                op = " -";
                break;
            }
            case 14: {
                op = " not ";
                break;
            }
            case 16: {
                op = " empty ";
                break;
            }
            default: {
                op = " unknown(" + this._op + ") ";
            }
        }
        return op + this._expr;
    }
}

