/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.ESArguments;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESClosure;
import com.caucho.es.ESDate;
import com.caucho.es.ESGlobal;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.ESUndefinedException;
import com.caucho.es.Global;
import com.caucho.es.Printf;
import java.util.Enumeration;
import java.util.Iterator;

public final class Call
extends ESBase {
    static ESId ARGUMENTS = ESId.intern("arguments");
    static ESId ARRAY = ESId.intern("Array");
    Call caller;
    ESObject callThis;
    int callLength;
    ESBase callee;
    public ESBase[] stack;
    int top;
    public ESGlobal global;
    ESBase[] scope;
    int scopeLength;
    public ESBase[] values;
    ESObject aux;
    Call child;

    Call() {
        this.prototype = esBase;
        this.stack = new ESBase[64];
        this.scope = new ESBase[16];
        this.values = new ESBase[64];
        this.top = 0;
    }

    void clear() {
        this.aux = null;
        this.child = null;
        this.top = 0;
    }

    public Call getCall() {
        Call child = this.child;
        if (child == null) {
            child = this.child = new Call();
        }
        child.caller = this;
        child.global = this.global;
        return child;
    }

    Global getGlobalProto() {
        return Global.getGlobalProto();
    }

    public ESBase wrap(Object o) throws Throwable {
        return Global.wrap(o);
    }

    public ESBase wrapClass(Class cl) throws Throwable {
        return Global.getGlobalProto().classWrap(cl);
    }

    final ESBase getArg(int i) {
        return this.stack[this.top + i];
    }

    public final ESBase getArg(int i, int len) {
        return i < len ? this.stack[this.top + i] : esUndefined;
    }

    public final int getArgInt32(int i, int len) throws Throwable {
        return i < len ? this.stack[this.top + i].toInt32() : 0;
    }

    public final double getArgNum(int i, int len) throws Throwable {
        return i < len ? this.stack[this.top + i].toNum() : Double.NaN;
    }

    public final String getArgString(int i, int len) throws Throwable {
        return i < len ? this.stack[this.top + i].toJavaString() : null;
    }

    public final Object getArgObject(int i, int len) throws Throwable {
        return i < len ? this.stack[this.top + i].toJavaObject() : null;
    }

    public ESObject createObject() {
        return new ESObject("Object", this.getGlobalProto().objProto);
    }

    public ESBase createDate(long time) {
        return new ESDate(time, (ESBase)this.getGlobalProto().dateProto);
    }

    public String printf(int length) throws Throwable {
        return Printf.sprintf(this, length);
    }

    void setArg(int i, ESBase obj) {
        this.stack[this.top + i] = obj;
    }

    public final ESObject getThis() throws Throwable {
        return this.stack[this.top - 1].toObject();
    }

    public final Object getThisWrapper() throws Throwable {
        return this.stack[this.top - 1].toJavaObject();
    }

    void setThis(ESBase obj) {
        this.stack[this.top - 1] = obj;
    }

    public ESGlobal getGlobal() {
        return this.global;
    }

    public final ESObject getCallThis() throws Throwable {
        ESBase obj = this.caller.stack[this.caller.top - 1];
        return obj.toObject();
    }

    ESBase getContext() {
        return this.scope[this.scopeLength - 1];
    }

    ESBase getFunctionContext() {
        if (this.caller == null || this.caller.scopeLength == 0) {
            return this.global;
        }
        return this.caller.scope[this.caller.scopeLength - 1];
    }

    public void pushScope(ESBase value) {
        this.scope[this.scopeLength++] = value;
    }

    public void popScope() {
        --this.scopeLength;
    }

    public ESObject getEval() {
        return (ESObject)this.scope[this.scopeLength - 1];
    }

    public ESObject createArg(ESId[] args, int length) throws Throwable {
        ESObject arg = ESArguments.create(args, this, length);
        this.scope[this.scopeLength++] = arg;
        return arg;
    }

    public void setProperty(ESString name, ESBase value) throws Throwable {
    }

    public ESBase delete(ESString key) throws Throwable {
        return this.aux == null ? ESBoolean.FALSE : this.aux.delete(key);
    }

    public ESBase findScopeProperty(ESString id) throws Throwable {
        for (int i = this.scopeLength - 1; i > 0; --i) {
            if (this.scope[i].getProperty(id) == esEmpty) continue;
            return this.scope[i];
        }
        return this.global;
    }

    public ESBase scopeTypeof(ESString id) throws Throwable {
        for (int i = this.scopeLength - 1; i >= 0; --i) {
            ESBase value = this.scope[i].getProperty(id);
            if (value == esEmpty) continue;
            return value.typeof();
        }
        return esEmpty.typeof();
    }

    public static ESBase setProperty(ESBase base, ESString field, ESBase value) throws Throwable {
        base.setProperty(field, value);
        return value;
    }

    public static ESBase doVoid(ESBase value) {
        return ESBase.esUndefined;
    }

    public ESBase array(ESBase value) throws Throwable {
        ESBase array = this.call((ESBase)this.global, ARRAY, 0);
        array.setProperty(0, value);
        return array;
    }

    public static ESBase comma(ESBase left, ESBase right) {
        return right;
    }

    public static ESBase _first(ESBase left, ESBase right) throws Throwable {
        if (!(left instanceof ESNumber)) {
            return ESNumber.create(left.toNum());
        }
        return left;
    }

    public static double _first(double left, double right) throws Throwable {
        return left;
    }

    public static int _first(int left, int right) throws Throwable {
        return left;
    }

    public static double _pre(ESBase expr, ESString field, int inc) throws Throwable {
        double oldVal = expr.getProperty(field).toNum();
        ESNumber newVal = ESNumber.create(oldVal + (double)inc);
        expr.setProperty(field, (ESBase)newVal);
        return oldVal + (double)inc;
    }

    public static double _post(ESBase expr, ESString field, int inc) throws Throwable {
        double oldVal = expr.getProperty(field).toNum();
        ESNumber newVal = ESNumber.create(oldVal + (double)inc);
        expr.setProperty(field, (ESBase)newVal);
        return oldVal;
    }

    public double _pre(ESString field, int inc) throws Throwable {
        double oldVal = this.getScopeProperty(field).toNum();
        ESNumber newVal = ESNumber.create(oldVal + (double)inc);
        this.setScopeProperty(field, newVal);
        return oldVal + (double)inc;
    }

    public double _post(ESString field, int inc) throws Throwable {
        double oldVal = this.getScopeProperty(field).toNum();
        ESNumber newVal = ESNumber.create(oldVal + (double)inc);
        this.setScopeProperty(field, newVal);
        return oldVal;
    }

    public ESBase setGlobalProperty(ESString id, ESBase value) throws Throwable {
        this.global.setProperty(id, value);
        return value;
    }

    public ESBase getGlobalVariable(ESString id) throws Throwable {
        ESBase value = this.global.getProperty(id);
        if (value == ESBase.esEmpty) {
            throw new ESUndefinedException("undefined variable `" + id + "'");
        }
        return value;
    }

    public ESBase getScopeProperty(ESString id) throws Throwable {
        for (int i = this.scopeLength - 1; i >= 0; --i) {
            ESBase value = this.scope[i].getProperty(id);
            if (value == esEmpty) continue;
            return value;
        }
        throw new ESUndefinedException("undefined variable `" + id + "'");
    }

    public void fillScope() {
        if (this.callee instanceof ESClosure) {
            ESClosure closure = (ESClosure)this.callee;
            if (closure.scopeLength == 0) {
                this.scope[0] = this.caller.global;
                this.scopeLength = 1;
                return;
            }
            for (int i = 0; i < closure.scopeLength; ++i) {
                this.scope[i] = closure.scope[i];
            }
            this.scopeLength = closure.scopeLength;
        } else {
            this.scope[0] = this.caller.global;
            this.scopeLength = 1;
        }
    }

    public ESBase hasScopeProperty(ESString id) throws Throwable {
        for (int i = this.scopeLength - 1; i >= 0; --i) {
            ESBase value = this.scope[i].getProperty(id);
            if (value == esEmpty) continue;
            return value;
        }
        return esEmpty;
    }

    public ESBase setScopeProperty(ESString id, ESBase value) throws Throwable {
        if (value == esEmpty) {
            value = esUndefined;
        }
        for (int i = this.scopeLength - 1; i > 0; --i) {
            if (this.scope[i].getProperty(id) == esEmpty) continue;
            this.scope[i].setProperty(id, value);
            return value;
        }
        this.global.setProperty(id, value);
        return value;
    }

    public ESBase deleteScopeProperty(ESString id) throws Throwable {
        for (int i = this.scopeLength - 1; i > 0; --i) {
            if (this.scope[i].getProperty(id) == esEmpty) continue;
            return this.scope[i].delete(id);
        }
        return this.global.delete(id);
    }

    public int arg(int i, ESBase arg) {
        this.stack[i + 1] = arg;
        return 1;
    }

    public ESBase callScope(ESString id, int i) throws Throwable {
        this.top = i + 1;
        int scopeLength = this.caller.scopeLength;
        ESBase[] scope = this.caller.scope;
        for (int j = scopeLength - 1; j >= 0; --j) {
            ESBase value = scope[j].getProperty(id);
            if (value == esEmpty) continue;
            this.callee = value;
            this.stack[i] = scope[j];
            return value.call(this, 0);
        }
        throw new ESUndefinedException("undefined call `" + id + "'");
    }

    public ESBase callScope(ESString id, int i, ESBase a) throws Throwable {
        this.top = i + 1;
        int scopeLength = this.caller.scopeLength;
        ESBase[] scope = this.caller.scope;
        for (int j = scopeLength - 1; j >= 0; --j) {
            ESBase value = scope[j].getProperty(id);
            if (value == esEmpty) continue;
            this.callee = value;
            this.stack[i] = scope[j];
            this.stack[i + 1] = a;
            return value.call(this, 1);
        }
        throw new ESUndefinedException("undefined call `" + id + "'");
    }

    public ESBase callScope(ESString id, int i, ESBase a, ESBase b) throws Throwable {
        this.top = i + 1;
        int scopeLength = this.caller.scopeLength;
        ESBase[] scope = this.caller.scope;
        for (int j = scopeLength - 1; j >= 0; --j) {
            ESBase value = scope[j].getProperty(id);
            if (value == esEmpty) continue;
            this.callee = value;
            this.stack[i] = scope[j];
            this.stack[i + 1] = a;
            this.stack[i + 2] = b;
            return value.call(this, 2);
        }
        throw new ESUndefinedException("undefined call `" + id + "'");
    }

    public ESBase callScope(ESString id, int i, ESBase a, ESBase b, ESBase c, int length) throws Throwable {
        this.top = i + 1;
        int scopeLength = this.caller.scopeLength;
        ESBase[] scope = this.caller.scope;
        for (int j = scopeLength - 1; j >= 0; --j) {
            ESBase value = scope[j].getProperty(id);
            if (value == esEmpty) continue;
            this.callee = value;
            this.stack[i] = scope[j];
            this.stack[i + 1] = a;
            this.stack[i + 2] = b;
            this.stack[i + 3] = c;
            return value.call(this, length);
        }
        throw new ESUndefinedException("undefined call `" + id + "'");
    }

    public ESBase call(ESBase base, ESString name, int i) throws Throwable {
        this.top = i + 1;
        this.stack[i] = base;
        return base.call(this, 0, name);
    }

    public ESBase call(ESBase base, ESString name, int i, ESBase a) throws Throwable {
        this.top = i + 1;
        this.stack[i] = base;
        this.stack[i + 1] = a;
        return base.call(this, 1, name);
    }

    public ESBase call(ESBase base, ESString name, int i, ESBase a, ESBase b) throws Throwable {
        this.top = i + 1;
        this.stack[i] = base;
        this.stack[i + 1] = a;
        this.stack[i + 2] = b;
        return base.call(this, 2, name);
    }

    public ESBase call(ESBase base, ESString name, int i, ESBase a, ESBase b, ESBase c, int length) throws Throwable {
        this.top = i + 1;
        this.stack[i] = base;
        this.stack[i + 1] = a;
        this.stack[i + 2] = b;
        this.stack[i + 3] = c;
        return base.call(this, length, name);
    }

    public ESBase call(ESBase base, int i) throws Throwable {
        this.top = i + 1;
        this.stack[i] = this.global;
        this.callee = base;
        return base.call(this, 0);
    }

    public ESBase call(ESBase base, int i, ESBase a) throws Throwable {
        this.top = i + 1;
        this.stack[i + 1] = a;
        this.stack[i] = this.global;
        this.callee = base;
        return base.call(this, 1);
    }

    public ESBase call(ESBase base, int i, ESBase a, ESBase b) throws Throwable {
        this.top = i + 1;
        this.stack[i] = base;
        this.stack[i + 1] = a;
        this.stack[i + 2] = b;
        this.stack[i] = this.global;
        this.callee = base;
        return base.call(this, 2);
    }

    public ESBase call(ESBase base, int i, ESBase a, ESBase b, ESBase c, int length) throws Throwable {
        this.top = i + 1;
        this.stack[i] = base;
        this.stack[i + 1] = a;
        this.stack[i + 2] = b;
        this.stack[i + 3] = c;
        this.stack[i] = this.global;
        this.callee = base;
        return base.call(this, length);
    }

    public ESBase newScope(ESString id, int i) throws Throwable {
        this.top = i + 1;
        int scopeLength = this.caller.scopeLength;
        ESBase[] scope = this.caller.scope;
        for (int j = scopeLength - 1; j >= 0; --j) {
            ESBase value = scope[j].getProperty(id);
            if (value == esEmpty) continue;
            this.callee = value;
            this.stack[i] = this.global;
            return value.construct(this, 0);
        }
        throw new ESUndefinedException("undefined constructor `" + id + "'");
    }

    public ESBase newScope(ESString id, int i, ESBase a) throws Throwable {
        this.top = i + 1;
        int scopeLength = this.caller.scopeLength;
        ESBase[] scope = this.caller.scope;
        for (int j = scopeLength - 1; j >= 0; --j) {
            ESBase value = scope[j].getProperty(id);
            if (value == esEmpty) continue;
            this.callee = value;
            this.stack[i] = this.global;
            this.stack[i + 1] = a;
            return value.construct(this, 1);
        }
        throw new ESUndefinedException("undefined constructor `" + id + "'");
    }

    public ESBase newScope(ESString id, int i, ESBase a, ESBase b) throws Throwable {
        this.top = i + 1;
        int scopeLength = this.caller.scopeLength;
        ESBase[] scope = this.caller.scope;
        for (int j = scopeLength - 1; j >= 0; --j) {
            ESBase value = scope[j].getProperty(id);
            if (value == esEmpty) continue;
            this.callee = value;
            this.stack[i] = this.global;
            this.stack[i + 1] = a;
            this.stack[i + 2] = b;
            return value.construct(this, 2);
        }
        throw new ESUndefinedException("undefined constructor `" + id + "'");
    }

    public ESBase newScope(ESString id, int i, ESBase a, ESBase b, ESBase c, int length) throws Throwable {
        this.top = i + 1;
        int scopeLength = this.caller.scopeLength;
        ESBase[] scope = this.caller.scope;
        for (int j = scopeLength - 1; j >= 0; --j) {
            ESBase value = scope[j].getProperty(id);
            if (value == esEmpty) continue;
            this.callee = value;
            this.stack[i] = this.global;
            this.stack[i + 1] = a;
            this.stack[i + 2] = b;
            this.stack[i + 3] = c;
            return value.construct(this, length);
        }
        throw new ESUndefinedException("undefined constructor `" + id + "'");
    }

    public ESBase doNew(ESBase base, ESString name, int i) throws Throwable {
        this.top = i + 1;
        ESBase obj = base.getProperty(name);
        this.stack[i] = base;
        this.callee = obj;
        if (obj != esEmpty) {
            return obj.construct(this, 0);
        }
        throw new ESUndefinedException("undefined constructor `" + name + "'");
    }

    public ESBase doNew(ESBase base, ESString name, int i, ESBase a) throws Throwable {
        ESBase obj;
        this.top = i + 1;
        this.stack[i] = base;
        this.stack[i + 1] = a;
        this.callee = obj = base.getProperty(name);
        if (obj != esEmpty) {
            return obj.construct(this, 1);
        }
        throw new ESUndefinedException("undefined constructor `" + name + "'");
    }

    public ESBase doNew(ESBase base, ESString name, int i, ESBase a, ESBase b) throws Throwable {
        ESBase obj;
        this.top = i + 1;
        this.stack[i] = base;
        this.stack[i + 1] = a;
        this.stack[i + 2] = b;
        this.callee = obj = base.getProperty(name);
        if (obj != esEmpty) {
            return obj.construct(this, 2);
        }
        throw new ESUndefinedException("undefined constructor `" + name + "'");
    }

    public ESBase doNew(ESBase base, ESString name, int i, ESBase a, ESBase b, ESBase c, int length) throws Throwable {
        ESBase obj;
        this.top = i + 1;
        this.stack[i] = base;
        this.stack[i + 1] = a;
        this.stack[i + 2] = b;
        this.stack[i + 3] = c;
        this.callee = obj = base.getProperty(name);
        if (obj != esEmpty) {
            return obj.construct(this, length);
        }
        throw new ESUndefinedException("undefined constructor `" + name + "'");
    }

    public ESBase doNew(ESBase base, int i) throws Throwable {
        this.top = i + 1;
        this.stack[i] = this.global;
        this.callee = base;
        return base.construct(this, 0);
    }

    public ESBase doNew(ESBase base, int i, ESBase a) throws Throwable {
        this.top = i + 1;
        this.stack[i] = this.global;
        this.stack[i + 1] = a;
        this.callee = base;
        return base.construct(this, 1);
    }

    public ESBase doNew(ESBase base, int i, ESBase a, ESBase b) throws Throwable {
        this.top = i + 1;
        this.stack[i] = this.global;
        this.stack[i + 1] = a;
        this.stack[i + 2] = b;
        this.callee = base;
        return base.construct(this, 2);
    }

    public ESBase doNew(ESBase base, int i, ESBase a, ESBase b, ESBase c, int length) throws Throwable {
        this.top = i + 1;
        this.stack[i] = this.global;
        this.stack[i + 1] = a;
        this.stack[i + 2] = b;
        this.stack[i + 3] = c;
        this.callee = base;
        return base.construct(this, length);
    }

    public static Iterator toESIterator(Iterator i) {
        return new ESIterator(i);
    }

    public static Iterator toESIterator(Enumeration e) {
        return new ESEnumIterator(e);
    }

    public static boolean matchException(ESBase test, Exception e) {
        String testString;
        try {
            testString = test.toStr().toString();
        }
        catch (Throwable foo) {
            testString = "undefined";
        }
        String dotted = "." + test;
        for (Class<?> eClass = e.getClass(); eClass != null; eClass = eClass.getSuperclass()) {
            String eString = eClass.getName();
            if (!testString.equals(eString) && !eString.endsWith(dotted)) continue;
            return true;
        }
        return false;
    }

    static class ESEnumIterator
    implements Iterator {
        Global resin;
        Enumeration e;

        public boolean hasNext() {
            return this.e != null && this.e.hasMoreElements();
        }

        public Object next() {
            Object value = this.e != null ? this.e.nextElement() : null;
            try {
                if (value == null) {
                    return ESBase.esNull;
                }
                return this.resin.objectWrap(value);
            }
            catch (Throwable e) {
                return ESBase.esNull;
            }
        }

        public void remove() {
            throw new RuntimeException();
        }

        ESEnumIterator(Enumeration e) {
            this.e = e;
            this.resin = Global.getGlobalProto();
        }
    }

    static class ESIterator
    implements Iterator {
        Global resin;
        Iterator i;

        public boolean hasNext() {
            return this.i != null && this.i.hasNext();
        }

        public Object next() {
            ESBase result;
            Object value = this.i == null ? null : this.i.next();
            try {
                result = value == null ? ESBase.esNull : this.resin.objectWrap(value);
            }
            catch (Throwable e) {
                result = ESBase.esNull;
            }
            return result;
        }

        public void remove() {
            throw new RuntimeException();
        }

        ESIterator(Iterator i) {
            this.i = i;
            this.resin = Global.getGlobalProto();
        }
    }
}

