/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.Global;
import com.caucho.es.NativeRegexp;
import com.caucho.regexp.IllegalRegexpException;
import com.caucho.regexp.Regexp;
import com.caucho.util.IntMap;
import java.util.Iterator;

public class ESRegexp
extends ESObject {
    static ESId GLOBAL = ESId.intern("global");
    static ESId IGNORE_CASE = ESId.intern("ignoreCase");
    static ESId LAST_INDEX = ESId.intern("lastIndex");
    static ESId SOURCE = ESId.intern("source");
    ESString pattern;
    ESString flags;
    Regexp regexp;
    boolean hasSetProps;
    int lastIndex;
    ESString lastString;
    int lastStart;

    ESRegexp(ESString pattern, ESString flags) throws ESException {
        super("RegExp", ESRegexp.getPrototype());
        this.pattern = pattern;
        this.flags = flags;
        this.lastString = ESString.NULL;
        try {
            this.regexp = new Regexp(pattern.toString(), flags.toString());
        }
        catch (IllegalRegexpException e) {
            throw new ESException("regexp: " + e.getMessage());
        }
    }

    public ESRegexp(String pattern, String flags) throws ESException {
        super("RegExp", ESRegexp.getPrototype());
        this.pattern = new ESString(pattern);
        this.flags = new ESString(flags);
        this.lastString = ESString.NULL;
        try {
            this.regexp = new Regexp(pattern, flags);
        }
        catch (IllegalRegexpException e) {
            throw new ESException("regexp: " + e.getMessage());
        }
    }

    protected ESRegexp() {
    }

    private static ESBase getPrototype() {
        Global resin = Global.getGlobalProto();
        if (resin == null) {
            return null;
        }
        return resin.getRegexpProto();
    }

    private void setProps() {
        if (this.hasSetProps) {
            return;
        }
        int flags = 3;
        this.hasSetProps = true;
        this.put(GLOBAL, (ESBase)ESBoolean.create(this.regexp.isGlobal()), flags);
        this.put(IGNORE_CASE, (ESBase)ESBoolean.create(this.regexp.ignoreCase()), flags);
        this.put(LAST_INDEX, (ESBase)ESNumber.create(this.lastIndex), 2);
        this.put(SOURCE, (ESBase)this.pattern, flags);
    }

    int getLastIndex() throws Throwable {
        if (!this.hasSetProps) {
            return this.lastIndex;
        }
        return this.getProperty(LAST_INDEX).toInt32();
    }

    void setLastIndex(int index) {
        this.lastIndex = index;
        this.hasSetProps = false;
    }

    public ESBase getProperty(ESString key) throws Throwable {
        if (!this.hasSetProps) {
            this.setProps();
        }
        return super.getProperty(key);
    }

    public void setProperty(ESString key, ESBase value) throws Throwable {
        if (!this.hasSetProps) {
            this.setProps();
        }
        super.setProperty(key, value);
    }

    public ESBase delete(ESString key) throws Throwable {
        if (!this.hasSetProps) {
            this.setProps();
        }
        return super.delete(key);
    }

    public Iterator keys() throws ESException {
        if (!this.hasSetProps) {
            this.setProps();
        }
        return super.keys();
    }

    public ESString toSource(IntMap map, boolean isLoopPass) throws Throwable {
        if (isLoopPass) {
            return null;
        }
        return this.toStr();
    }

    void compile(ESString pattern, ESString flags) throws ESException {
        if (!this.pattern.equals(pattern) || !this.flags.equals(flags)) {
            this.pattern = pattern;
            this.flags = flags;
            try {
                this.regexp = new Regexp(pattern.toString(), flags.toString());
            }
            catch (IllegalRegexpException e) {
                throw new ESException("regexp: " + e);
            }
        }
        this.lastIndex = 0;
        this.hasSetProps = false;
    }

    boolean exec(ESString string, boolean useGlobal) throws Throwable {
        this.lastString = string;
        this.lastStart = this.getLastIndex();
        if (!useGlobal) {
            this.lastStart = 0;
            return this.regexp.exec(string.toString(), 0) != -1;
        }
        if (this.regexp.exec(string.toString(), this.lastStart) == -1) {
            this.hasSetProps = false;
            this.lastIndex = 0;
            return false;
        }
        this.hasSetProps = false;
        this.lastIndex = this.regexp.getEnd(0);
        if (this.regexp.getBegin(0) == this.lastIndex) {
            ++this.lastIndex;
        }
        return true;
    }

    public Object toJavaObject() {
        return this.regexp;
    }

    boolean exec(ESString string) throws Throwable {
        return this.exec(string, this.regexp.isGlobal());
    }

    public ESBase call(Call call, int length) throws Throwable {
        call.setThis(this);
        return NativeRegexp.exec(call, length);
    }

    protected ESObject dup() {
        return new ESRegexp();
    }

    protected void copy(Object newObj) {
        ESRegexp newRegexp = (ESRegexp)newObj;
        super.copy(newObj);
        newRegexp.pattern = this.pattern;
        newRegexp.flags = this.flags;
        newRegexp.lastString = this.lastString;
        try {
            newRegexp.regexp = new Regexp(this.pattern.toString(), this.flags.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

