/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.wrapper;

import com.caucho.es.wrapper.ESIndexedPropertyDescriptor;
import com.caucho.es.wrapper.ESMethodDescriptor;
import com.caucho.es.wrapper.ESPropertyDescriptor;
import com.caucho.es.wrapper.NamedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ESBeanInfo {
    static String BAD = "bad";
    Class cl;
    HashMap methodMap;
    HashMap staticMethodMap;
    HashMap propMap;
    ArrayList nonPkgClasses = new ArrayList();
    PropertyDescriptor[] propertyDescriptors;
    ESMethodDescriptor iterator;

    ESBeanInfo(Class cl) {
        this.cl = cl;
        this.methodMap = new HashMap();
        this.staticMethodMap = new HashMap();
        this.propMap = new HashMap();
    }

    void addNonPkgClass(String name) {
        if (name.indexOf(36) >= 0) {
            return;
        }
        if (!this.nonPkgClasses.contains(name)) {
            this.nonPkgClasses.add(name);
        }
    }

    ArrayList getNonPkgClasses() {
        return this.nonPkgClasses;
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = ESBeanInfo.propMapToArray(this.propMap);
        }
        return this.propertyDescriptors;
    }

    private static PropertyDescriptor[] propMapToArray(HashMap props) {
        int count = 0;
        Iterator i = props.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = props.get(key);
            if (value == BAD) continue;
            ++count;
        }
        PropertyDescriptor[] descriptors = new PropertyDescriptor[count];
        count = 0;
        i = props.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = props.get(key);
            if (value == BAD) continue;
            descriptors[count] = (PropertyDescriptor)value;
            ++count;
        }
        return descriptors;
    }

    void addProp(String name, Field field, ESMethodDescriptor getter, ESMethodDescriptor setter, boolean overwrite) throws IntrospectionException {
        Object value = this.propMap.get(name);
        if (value instanceof ESPropertyDescriptor && !(value instanceof ESIndexedPropertyDescriptor) && !(value instanceof NamedPropertyDescriptor)) {
            ESPropertyDescriptor prop = (ESPropertyDescriptor)value;
            if (field != null) {
                prop.field = field;
            }
            if (getter != null) {
                prop.getter = getter;
            }
            if (setter != null) {
                prop.setter = setter;
            }
            this.propMap.put(name, prop);
        } else if (value == null || overwrite) {
            this.propMap.put(name, new ESPropertyDescriptor(name, field, getter, setter));
        } else {
            this.propMap.put(name, BAD);
        }
    }

    void addProp(String name, Field field, ESMethodDescriptor getter, ESMethodDescriptor setter) throws IntrospectionException {
        this.addProp(name, field, getter, setter, false);
    }

    void addIndexedProp(String name, ESMethodDescriptor getter, ESMethodDescriptor setter, ESMethodDescriptor size, boolean overwrite) throws IntrospectionException {
        Object value = this.propMap.get(name);
        if (value instanceof ESIndexedPropertyDescriptor) {
            ESIndexedPropertyDescriptor prop = (ESIndexedPropertyDescriptor)value;
            if (getter != null) {
                prop.getter = getter;
            }
            if (setter != null) {
                prop.setter = setter;
            }
            if (size != null) {
                prop.size = size;
            }
            this.propMap.put(name, prop);
        } else if (value == null || overwrite) {
            this.propMap.put(name, new ESIndexedPropertyDescriptor(name, getter, setter, size));
        } else {
            this.propMap.put(name, BAD);
        }
    }

    void addIndexedProp(String name, ESMethodDescriptor getter, ESMethodDescriptor setter, ESMethodDescriptor size) throws IntrospectionException {
        this.addIndexedProp(name, getter, setter, size, false);
    }

    void addNamedProp(String name, ESMethodDescriptor getter, ESMethodDescriptor setter, ESMethodDescriptor remover, ESMethodDescriptor iterator, boolean overwrite) throws IntrospectionException {
        Object value = this.propMap.get(name);
        if (value instanceof NamedPropertyDescriptor) {
            NamedPropertyDescriptor prop = (NamedPropertyDescriptor)value;
            if (getter != null) {
                prop.namedGetter = getter;
            }
            if (setter != null) {
                prop.namedSetter = setter;
            }
            if (remover != null) {
                prop.namedRemover = remover;
            }
            if (iterator != null) {
                prop.namedIterator = iterator;
            }
        } else if (value == null || overwrite) {
            this.propMap.put(name, new NamedPropertyDescriptor(name, null, null, getter, setter, remover, iterator));
        } else {
            this.propMap.put(name, BAD);
        }
    }

    void addNamedProp(String name, ESMethodDescriptor getter, ESMethodDescriptor setter, ESMethodDescriptor remover, ESMethodDescriptor iterator) throws IntrospectionException {
        this.addNamedProp(name, getter, setter, remover, iterator, false);
    }

    public ArrayList getMethods(String name) {
        return (ArrayList)this.methodMap.get(name);
    }

    public ArrayList getStaticMethods(String name) {
        return (ArrayList)this.staticMethodMap.get(name);
    }

    public ArrayList getConstructors() {
        ArrayList overload = new ArrayList();
        if (!Modifier.isPublic(this.cl.getModifiers())) {
            return overload;
        }
        if (this.cl.getDeclaringClass() != null && !Modifier.isStatic(this.cl.getModifiers())) {
            return overload;
        }
        Constructor<?>[] constructors = this.cl.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (!Modifier.isPublic(constructors[i].getModifiers()) || !Modifier.isPublic(constructors[i].getModifiers())) continue;
            this.addConstructor(overload, constructors[i]);
        }
        return overload;
    }

    private void addConstructor(ArrayList overload, Constructor constructor) {
        Object oldConstructor;
        int modifiers = constructor.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            return;
        }
        Class<?>[] params = constructor.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (!Modifier.isPublic(params[i].getModifiers())) {
                return;
            }
            if (params[i].isPrimitive() || params[i].isArray() || params[i].getName().indexOf(46) >= 0) continue;
            this.addNonPkgClass(params[i].getName());
        }
        int length = params.length;
        if (length < overload.size() && (oldConstructor = overload.get(length)) != null) {
            overload.set(length, BAD);
        } else {
            while (overload.size() <= length) {
                overload.add(null);
            }
            overload.set(length, constructor);
        }
    }

    ESMethodDescriptor createMethodDescriptor(Method method, boolean overwrite) throws IntrospectionException {
        boolean staticVirtual = ESBeanInfo.isStaticVirtual(this.cl, method);
        return new ESMethodDescriptor(method, overwrite, staticVirtual);
    }

    private static boolean isStaticVirtual(Class cl, Method method) {
        int modifiers = method.getModifiers();
        if (!Modifier.isStatic(modifiers)) {
            return false;
        }
        if (method.getName().equals("<init>")) {
            return false;
        }
        if (!method.getDeclaringClass().getName().endsWith("EcmaWrap")) {
            return false;
        }
        Class<?>[] params = method.getParameterTypes();
        boolean result = params.length > 0 && params[0].equals(cl);
        return result;
    }

    void addMethod(MethodDescriptor oldMd, boolean overwrite) throws IntrospectionException {
        ESMethodDescriptor md = this.createMethodDescriptor(oldMd.getMethod(), overwrite);
        md.setName(oldMd.getName());
        this.addMethod(this.methodMap, md, false);
        this.addMethod(this.staticMethodMap, md, true);
    }

    void addMethod(ESMethodDescriptor md) throws IntrospectionException {
        this.addMethod(this.methodMap, md, false);
        this.addMethod(this.staticMethodMap, md, true);
    }

    void addMethods(ESBeanInfo info) throws IntrospectionException {
        if (info.iterator != null) {
            this.iterator = info.iterator;
        }
        this.addMap(this.methodMap, info.methodMap, false);
        this.addMap(this.staticMethodMap, info.staticMethodMap, true);
    }

    private void addMap(HashMap newMap, HashMap oldMap, boolean isStatic) {
        Iterator i = oldMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ArrayList overload = (ArrayList)entry.getValue();
            for (int j = 0; j < overload.size(); ++j) {
                ESMethodDescriptor[] mds = (ESMethodDescriptor[])overload.get(j);
                if (mds == null) continue;
                for (int k = 0; k < mds.length; ++k) {
                    this.addMethod(newMap, mds[k], isStatic);
                }
            }
        }
    }

    private void addMethod(HashMap map, ESMethodDescriptor md, boolean isStatic) {
        ESMethodDescriptor[] oldMethods;
        int length;
        Method method = md.getMethod();
        int modifiers = method.getModifiers();
        boolean staticVirtual = md.isStaticVirtual();
        boolean overwrite = md.isOverwrite();
        if (!Modifier.isPublic(modifiers)) {
            return;
        }
        if (isStatic && !md.isStatic()) {
            return;
        }
        Class[] params = md.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            if (!Modifier.isPublic(params[i].getModifiers())) {
                return;
            }
            if (params[i].isPrimitive() || params[i].isArray() || params[i].getName().indexOf(46) >= 0) continue;
            this.addNonPkgClass(params[i].getName());
        }
        ArrayList<ESMethodDescriptor[]> overload = (ArrayList<ESMethodDescriptor[]>)map.get(md.getName());
        if (overload == null) {
            overload = new ArrayList<ESMethodDescriptor[]>();
            map.put(md.getName(), overload);
        }
        if ((length = params.length) >= overload.size()) {
            while (overload.size() <= length) {
                overload.add(null);
            }
        }
        if ((oldMethods = (ESMethodDescriptor[])overload.get(length)) == null) {
            overload.set(length, new ESMethodDescriptor[]{md});
            return;
        }
        for (int i = 0; i < oldMethods.length; ++i) {
            int j;
            ESMethodDescriptor testMd = oldMethods[i];
            if (testMd.overwrites(md)) {
                return;
            }
            if (md.overwrites(testMd)) {
                oldMethods[i] = md;
                return;
            }
            Class[] oldParams = testMd.getParameterTypes();
            for (j = 0; j < length && params[j].equals(oldParams[j]); ++j) {
            }
            if (j == length && md.isOverwrite()) {
                oldMethods[i] = md;
                return;
            }
            if (j != length) continue;
            return;
        }
        ESMethodDescriptor[] newMethods = new ESMethodDescriptor[oldMethods.length + 1];
        System.arraycopy(oldMethods, 0, newMethods, 0, oldMethods.length);
        newMethods[oldMethods.length] = md;
        overload.set(length, newMethods);
    }

    private void addPropMap(HashMap oldMap) throws IntrospectionException {
        Iterator i = oldMap.entrySet().iterator();
        while (i.hasNext()) {
            ESPropertyDescriptor pd;
            Map.Entry entry = i.next();
            Object value = entry.getValue();
            if (value == BAD) continue;
            if (value instanceof NamedPropertyDescriptor) {
                pd = (NamedPropertyDescriptor)value;
                this.addNamedProp(pd.getName(), ((NamedPropertyDescriptor)pd).namedGetter, ((NamedPropertyDescriptor)pd).namedSetter, ((NamedPropertyDescriptor)pd).namedRemover, ((NamedPropertyDescriptor)pd).namedIterator);
                continue;
            }
            if (value instanceof ESIndexedPropertyDescriptor) {
                pd = (ESIndexedPropertyDescriptor)value;
                this.addIndexedProp(pd.getName(), ((ESIndexedPropertyDescriptor)pd).getESReadMethod(), ((ESIndexedPropertyDescriptor)pd).getESWriteMethod(), ((ESIndexedPropertyDescriptor)pd).getESSizeMethod());
                continue;
            }
            if (!(value instanceof ESPropertyDescriptor)) continue;
            pd = (ESPropertyDescriptor)value;
            this.addProp(pd.getName(), pd.field, pd.getter, pd.setter);
        }
    }

    void addField(Field field) throws IntrospectionException {
        int modifiers = field.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            return;
        }
        this.addProp(field.getName(), field, null, null);
    }

    void addProps(ESBeanInfo info) throws IntrospectionException {
        this.addPropMap(info.propMap);
    }
}

