/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.admin;

import com.caucho.http.admin.HostAdmin;
import com.caucho.http.admin.TcpServerAdmin;
import com.caucho.server.http.ServletServer;
import com.caucho.server.http.VirtualHost;
import java.util.ArrayList;

public class ServerAdmin {
    private ServletServer server;

    public ServerAdmin(ServletServer server) {
        this.server = server;
    }

    public void clearCache() {
        this.server.clearCache();
    }

    public void restart() {
        this.server.adminRestart();
    }

    public ArrayList getHostAdminList() {
        return this.server.getHostAdminList();
    }

    public HostAdmin getHostAdmin(String hostName) {
        VirtualHost host = this.server.getHostByName(hostName);
        if (host == null) {
            return null;
        }
        return host.getAdmin();
    }

    public ArrayList getTcpServerAdminList() {
        return new ArrayList(this.server.getTcpServerAdminList());
    }

    public int getConnectionCount() {
        ArrayList list = this.server.getTcpServerAdminList();
        int count = 0;
        for (int i = 0; list != null && i < list.size(); ++i) {
            TcpServerAdmin tcpServer = (TcpServerAdmin)list.get(i);
            count += tcpServer.getConnectionCount();
        }
        return count;
    }

    public int getActiveConnectionCount() {
        ArrayList list = this.server.getTcpServerAdminList();
        int count = 0;
        for (int i = 0; list != null && i < list.size(); ++i) {
            TcpServerAdmin tcpServer = (TcpServerAdmin)list.get(i);
            count += tcpServer.getActiveConnectionCount();
        }
        return count;
    }

    public void closeTcp() {
        ArrayList list = this.server.getTcpServerAdminList();
        for (int i = 0; list != null && i < list.size(); ++i) {
            TcpServerAdmin tcpServer = (TcpServerAdmin)list.get(i);
            try {
                tcpServer.close();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public boolean isShutdown() {
        return this.server.isClosed();
    }

    public void close() {
        this.closeTcp();
        this.server.close();
    }
}

