/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.distribution;

import com.caucho.http.distribution.DistributedObject;
import com.caucho.http.distribution.Store;
import com.caucho.util.Alarm;
import com.caucho.util.CacheListener;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class ObjectBacking
implements CacheListener {
    protected static WriteStream dbg = LogStream.open("/caucho.com/distribution");
    private Path objectPath;
    private String id;
    private DistributedObject object;
    private int updateCount;

    public ObjectBacking(String id, Path objectPath) {
        this.id = id;
        this.objectPath = objectPath;
    }

    public String getId() {
        return this.id;
    }

    public Path getPath() {
        return this.objectPath;
    }

    public DistributedObject getObject() {
        return this.object;
    }

    public void setObject(DistributedObject object) {
        this.object = object;
    }

    public ReadStream openRead() throws IOException {
        return this.objectPath.openRead();
    }

    public WriteStream openWrite() throws IOException {
        return this.objectPath.openWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    synchronized void save(DistributedObject object) {
        block13: {
            WriteStream os = null;
            try {
                os = this.objectPath.openWrite();
            }
            catch (Exception e) {
                this.objectPath.getParent().mkdirs();
                os = this.objectPath.openWrite();
            }
            object.getStore();
            Store.store(object, os);
            this.object = object;
            Object var5_5 = null;
            try {
                if (os != null) {
                    os.close();
                }
                break block13;
            }
            catch (IOException e1) {}
            break block13;
            {
                catch (Exception e) {
                    dbg.log(e);
                    Object var5_6 = null;
                    try {
                        if (os != null) {
                            os.close();
                        }
                        break block13;
                    }
                    catch (IOException e1) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e1) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    void access() {
        this.objectPath.setLastModified(Alarm.getCurrentTime());
    }

    public synchronized void remove() {
        try {
            this.objectPath.remove();
        }
        catch (IOException e) {
            dbg.log(e);
        }
    }

    public void removeEvent() {
        if (this.object != null) {
            this.object.setBacking(null);
        }
    }

    public boolean canLog() {
        return dbg.canWrite();
    }

    public void log(String value) {
        dbg.log(value);
    }

    public String toString() {
        return "[DistBacking " + this.objectPath + "]";
    }
}

