/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.distribution;

import com.caucho.http.distribution.DistributedObject;
import com.caucho.http.distribution.DistributionServer;
import com.caucho.http.distribution.ObjectBacking;
import com.caucho.http.distribution.Store;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class RingStore
extends Store {
    private String prefix;
    private DistributionServer selfServer;
    private int selfServerIndex;
    private DistributionServer[] selfServerGroup;
    private int selfGroupIndex;

    public RingStore(String prefix, DistributionServer selfServer) {
        this.prefix = prefix;
        this.selfServer = selfServer;
        this.selfServerIndex = selfServer.getIndex();
        this.selfServerGroup = selfServer.getGroup();
        this.selfGroupIndex = selfServer.getGroupIndex();
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void init() throws Exception {
        int count = this.selfServerGroup.length;
        for (int i = 1; i < count; ++i) {
            try {
                int nextIndex = (this.selfGroupIndex + i) % this.selfServerGroup.length;
                this.loadDump(this.selfServer.getId(), this.selfServerGroup[nextIndex]);
                continue;
            }
            catch (Exception e) {
                dbg.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void loadDump(String ownerId, DistributionServer sibling) throws Exception {
        WriteStream ws;
        ReadStream rs;
        block20: {
            ReadWritePair rws = sibling.open();
            if (rws == null) {
                return;
            }
            if (dbg.canWrite()) {
                dbg.log("server " + this.selfServerIndex + " loading sessions from " + sibling);
            }
            rs = rws.getReadStream();
            ws = rws.getWriteStream();
            int code = 0;
            try {
                String mangledId = this.prefix;
                this.writeString(ws, 74, String.valueOf(this.selfServerIndex));
                this.writeString(ws, 76, mangledId);
                TempBuffer tempBuffer = TempBuffer.allocate();
                byte[] buf = tempBuffer.getBuffer();
                code = rs.read();
                block10: while (code == 76) {
                    ObjectBacking backing;
                    int ch1 = rs.read();
                    int ch2 = rs.read();
                    int ch3 = rs.read();
                    int len = (ch1 << 16) + (ch2 << 8) + ch3;
                    if (ch3 < 0) break;
                    rs.readAll(buf, 0, len);
                    String id = new String(buf, 0, len);
                    ObjectBacking objectBacking = backing = this.backingManager.getBacking(id);
                    synchronized (objectBacking) {
                        WriteStream os = null;
                        try {
                            os = backing.openWrite();
                        }
                        catch (IOException e) {
                            dbg.log(e);
                        }
                        if (dbg.canWrite()) {
                            dbg.log("load dump: " + backing.getId());
                        }
                        try {
                            boolean hasData = false;
                            while ((code = rs.read()) == 69) {
                                ch1 = rs.read();
                                ch2 = rs.read();
                                ch3 = rs.read();
                                len = (ch1 << 16) + (ch2 << 8) + ch3;
                                if (ch3 < 0) {
                                    break block10;
                                }
                                if (os != null) {
                                    os.writeStream(rs, len);
                                    continue;
                                }
                                rs.skip(len);
                            }
                        }
                        finally {
                            if (os != null) {
                                os.close();
                            }
                        }
                    }
                }
                Object var22_21 = null;
                if (code != 90) break block20;
            }
            catch (Throwable throwable) {
                Object var22_22 = null;
                if (code == 90) {
                    rs.skip(3L);
                    sibling.free(rws);
                    throw throwable;
                }
                ws.close();
                rs.close();
                throw throwable;
            }
            rs.skip(3L);
            sibling.free(rws);
            return;
        }
        ws.close();
        rs.close();
    }

    public boolean load(DistributedObject object) throws Exception {
        ObjectBacking backing = object.getBacking();
        if (backing == null) {
            return false;
        }
        DistributionServer owningServer = object.getOwningServer();
        if (owningServer == null) {
            return false;
        }
        DistributionServer backupServer = object.getBackupServer();
        if (this.selfServer == owningServer || this.selfServer == backupServer) {
            if (object.getUpdateCount() > 0) {
                return true;
            }
            if (this.load(object, -1)) {
                if (dbg.canWrite()) {
                    dbg.log("[" + this.selfServer.getId() + "] self-load(" + owningServer.getId() + ") " + backing + " " + object.getUpdateCount());
                }
                return true;
            }
            return false;
        }
        object.setNeedsLoad(true);
        object.setUpdateCount(-1);
        try {
            if (this.loadObject(object, backing.getId(), owningServer)) {
                return true;
            }
        }
        catch (Exception e) {
            dbg.log(e);
        }
        if (backupServer == null) {
            return false;
        }
        try {
            return this.loadObject(object, backing.getId(), backupServer);
        }
        catch (Exception e) {
            dbg.log(e);
            return false;
        }
    }

    boolean loadObject(DistributedObject object, String id, DistributionServer server) throws IOException {
        ReadWritePair rws = server.openRecycle();
        if (rws != null) {
            try {
                return this.loadObject(object, server, id, rws, -1);
            }
            catch (Exception e) {
                rws.getWriteStream().close();
                rws.getReadStream().close();
            }
        }
        if ((rws = server.open()) != null) {
            try {
                return this.loadObject(object, server, id, rws, -1);
            }
            catch (Exception e) {
                rws.getWriteStream().close();
                rws.getReadStream().close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean loadObject(DistributedObject object, DistributionServer server, String id, ReadWritePair rws, int updateCount) throws Exception {
        int code;
        String mangledId = this.prefix + ';' + id;
        ReadStream rs = rws.getReadStream();
        WriteStream ws = rws.getWriteStream();
        this.writeString(ws, 74, String.valueOf(this.selfServer.getIndex()));
        this.writeString(ws, 67, mangledId);
        TempStream tempStream = new TempStream(null);
        WriteStream os = new WriteStream(tempStream);
        boolean hasData = false;
        while ((code = rs.read()) == 69) {
            int ch1 = rs.read();
            int ch2 = rs.read();
            int ch3 = rs.read();
            int len = (ch1 << 16) + (ch2 << 8) + ch3;
            if (ch3 < 0) break;
            hasData = true;
            os.writeStream(rs, len);
        }
        os.close();
        if (code == 90) {
            rs.skip(3L);
            server.free(rws);
        } else {
            ws.close();
            rs.close();
        }
        if (code != 90 && code != 88 || !hasData) {
            tempStream.destroy();
            return false;
        }
        ReadStream is = tempStream.openRead();
        boolean isValid = false;
        try {
            isValid = this.load(object, is, updateCount);
        }
        finally {
            is.close();
        }
        if (dbg.canWrite()) {
            dbg.log("[" + this.selfServer.getId() + "] dist-load(" + server.getIndex() + ") " + isValid + " " + mangledId);
        }
        return isValid;
    }

    public void storeOnShutdown(DistributedObject object) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void store(DistributedObject object) throws Exception {
        block20: {
            block17: {
                backing = object.getBacking();
                tempStream = new TempStream(null);
                os = new WriteStream(tempStream);
                empty = RingStore.store(object, os) == false;
                os.close();
                os = null;
                if (!empty) break block18;
                tempStream.destroy();
                var11_6 = null;
                ** if (os == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
lbl-1000:
                // 3 sources

                {
                    block18: {
                        return;
                    }
                    owningServer = object.getOwningServer();
                    if (owningServer != null) break block19;
                }
                var11_7 = null;
                if (os == null) ** GOTO lbl-1000
                try {
                    os.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
lbl-1000:
                // 3 sources

                {
                    block19: {
                        return;
                    }
                    backupServer = object.getBackupServer();
                    hasSelf = false;
                    if (owningServer == this.selfServer) {
                        hasSelf = true;
                    } else {
                        this.saveServer(tempStream, backing.getId(), owningServer);
                    }
                    if (backupServer == this.selfServer) {
                        hasSelf = true;
                    } else if (backupServer != null) {
                        this.saveServer(tempStream, backing.getId(), backupServer);
                    }
                    if (hasSelf) {
                        is = tempStream.openRead(true);
                        this.storeSelf(object, is);
                        is.close();
                        if (RingStore.dbg.canWrite()) {
                            RingStore.dbg.log("[" + this.selfServer.getId() + "] self-store(" + this.selfServerGroup[this.selfGroupIndex].getIndex() + ") " + backing.getId());
                        }
                        break block17;
                    }
                    tempStream.destroy();
                }
            }
            var11_8 = null;
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
            break block20;
            catch (Throwable var10_18) {
                var11_9 = null;
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var10_18;
            }
        }
    }

    public boolean access(DistributedObject obj) {
        try {
            this.store(obj);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    void saveServer(TempStream tempStream, String id, DistributionServer server) throws IOException {
        ReadWritePair rws = server.openRecycle();
        if (rws != null) {
            try {
                this.saveObject(tempStream, id, server, rws);
                return;
            }
            catch (Throwable e) {
                try {
                    rws.getWriteStream().close();
                    rws.getReadStream().close();
                    rws = null;
                }
                catch (Throwable e1) {
                    // empty catch block
                }
            }
        }
        if ((rws = server.open()) != null) {
            try {
                this.saveObject(tempStream, id, server, rws);
            }
            catch (IOException e) {
                e.printStackTrace();
                rws.getWriteStream().close();
                rws.getReadStream().close();
            }
        }
    }

    void saveObject(TempStream tempStream, String id, DistributionServer server, ReadWritePair rws) throws IOException {
        String mangledId = this.prefix + ';' + id;
        ReadStream rs = rws.getReadStream();
        WriteStream ws = rws.getWriteStream();
        this.writeString(ws, 74, String.valueOf(server.getIndex()));
        this.writeString(ws, 66, mangledId);
        ReadStream ts = tempStream.openRead(false);
        this.writeData(ws, ts);
        ts.close();
        int ch0 = rs.read();
        int ch1 = rs.read();
        int ch2 = rs.read();
        int ch3 = rs.read();
        if (ch0 != 90 || ch1 != 0 || ch2 != 0 || ch3 != 0) {
            ws.close();
            rs.close();
        } else {
            server.free(rws);
        }
        if (dbg.canWrite()) {
            dbg.log("[" + server.getId() + "] dist-store(" + server.getIndex() + ") " + mangledId);
        }
    }

    public void remove(DistributedObject object) throws Exception {
        ObjectBacking backing = object.getBacking();
        if (backing == null) {
            return;
        }
        DistributionServer owningServer = object.getOwningServer();
        DistributionServer backupServer = object.getBackupServer();
        if (owningServer == this.selfServer) {
            backing.remove();
            if (dbg.canWrite()) {
                dbg.log("[" + this.selfServer.getId() + "] self-invalidate(" + owningServer.getIndex() + ") " + backing);
            }
        } else {
            this.invalidateServer(backing.getId(), owningServer);
        }
        if (backupServer == this.selfServer) {
            backing.remove();
            if (dbg.canWrite()) {
                dbg.log("[" + this.selfServer.getId() + "] self-invalidate(" + backupServer.getIndex() + ") " + backing);
            }
        } else if (backupServer != null) {
            this.invalidateServer(backing.getId(), backupServer);
        }
    }

    void invalidateServer(String id, DistributionServer server) {
        ReadWritePair rws = server.openRecycle();
        if (rws != null) {
            try {
                this.invalidate(server, rws, id);
            }
            catch (Exception e) {
                e.printStackTrace();
                rws = null;
            }
        }
        if (rws == null && (rws = server.open()) != null) {
            try {
                this.invalidate(server, rws, id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void invalidate(DistributionServer server, ReadWritePair rws, String id) throws Exception {
        ReadStream rs = rws.getReadStream();
        WriteStream ws = rws.getWriteStream();
        String mangledId = this.prefix + ';' + id;
        this.writeString(ws, 74, String.valueOf(this.selfServer.getIndex()));
        this.writeString(ws, 73, mangledId);
        int ch0 = rs.read();
        int ch1 = rs.read();
        int ch2 = rs.read();
        int ch3 = rs.read();
        if (ch0 != 90 || ch1 != 0 || ch2 != 0 || ch3 != 0) {
            ws.close();
            rs.close();
        } else {
            server.free(rws);
        }
        if (dbg.canWrite()) {
            dbg.log("[" + server.getId() + "] dist-invalidate() " + mangledId);
        }
    }

    private void writeString(WriteStream ws, int code, String value) throws IOException {
        int len = value.length();
        ws.write(code);
        ws.write(len >> 16);
        ws.write(len >> 8);
        ws.write(len);
        ws.print(value);
    }

    private void writeData(WriteStream ws, ReadStream is) throws IOException {
        int sublen;
        TempBuffer tb = TempBuffer.allocate();
        byte[] buf = tb.getBuffer();
        int length = buf.length;
        while ((sublen = is.read(buf, 0, length)) > 0) {
            ws.write(69);
            ws.write(sublen >> 16);
            ws.write(sublen >> 8);
            ws.write(sublen);
            ws.write(buf, 0, sublen);
        }
        TempBuffer.free(tb);
        ws.write(90);
        ws.write(0);
        ws.write(0);
        ws.write(0);
    }

    private void storeSelf(DistributedObject object, ReadStream is) {
        ObjectBacking backing = object.getBacking();
        backing.save(object);
    }
}

