/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.security;

import com.caucho.http.security.AbstractLogin;
import com.caucho.util.Base64;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BasicLogin
extends AbstractLogin {
    protected String realm;

    public void setRealmName(String realm) {
        this.realm = realm;
    }

    public String getRealmName() {
        return this.realm;
    }

    public String getAuthType() {
        return "Basic";
    }

    public Principal authenticate(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        Principal user = this.auth.getUserPrincipal(request, response, application);
        if (user != null) {
            return user;
        }
        user = this.getBasicPrincipal(request, response, application);
        if (user != null) {
            return user;
        }
        this.sendBasicChallenge(response);
        return null;
    }

    public Principal getUserPrincipal(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException {
        Principal user = this.auth.getUserPrincipal(request, response, application);
        if (user != null) {
            return user;
        }
        return this.getBasicPrincipal(request, response, application);
    }

    protected void sendBasicChallenge(HttpServletResponse res) throws ServletException, IOException {
        String realm = this.getRealmName();
        if (realm == null) {
            realm = "resin";
        }
        res.setHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
        res.sendError(401);
    }

    protected Principal getBasicPrincipal(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException {
        Principal principal = (Principal)request.getAttribute("com.caucho.servlet.login.name");
        if (principal != null) {
            return principal;
        }
        String value = request.getHeader("Authorization");
        if (value == null) {
            return null;
        }
        int i = value.indexOf(32);
        if (i <= 0) {
            return null;
        }
        String decoded = Base64.decode(value.substring(i + 1));
        int index = decoded.indexOf(58);
        if (index < 0) {
            return null;
        }
        String user = decoded.substring(0, index);
        String password = decoded.substring(index + 1);
        principal = this.auth.login(request, response, application, user, password);
        if (dbg.canWrite()) {
            dbg.log("basic: " + user + " -> " + principal);
        }
        return principal;
    }
}

