/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.security;

import com.caucho.http.security.AbstractLogin;
import com.caucho.server.http.Application;
import com.caucho.server.http.Response;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FormLogin
extends AbstractLogin {
    public static final String LOGIN_SAVED_PATH = "com.caucho.servlet.login.path";
    public static final String LOGIN_SAVED_QUERY = "com.caucho.servlet.login.query";
    protected String loginPage;
    protected String errorPage;
    protected boolean internalForward;
    protected boolean formURIPriority;

    public void setFormLoginPage(String formLoginPage) {
        this.loginPage = formLoginPage;
    }

    public String getFormLoginPage() {
        return this.loginPage;
    }

    public void setFormErrorPage(String formErrorPage) {
        this.errorPage = formErrorPage;
    }

    public String getFormErrorPage() {
        return this.errorPage;
    }

    public boolean getInternalForward() {
        return this.internalForward;
    }

    public void setInternalForward(boolean internalForward) {
        this.internalForward = internalForward;
    }

    public boolean getFormURIPriority() {
        return this.formURIPriority;
    }

    public void setFormURIPriority(boolean formPriority) {
        this.formURIPriority = formPriority;
    }

    public void init() throws ServletException {
        super.init();
        if (this.errorPage == null) {
            this.errorPage = this.loginPage;
        }
        if (this.loginPage == null) {
            this.loginPage = this.errorPage;
        }
        if (this.loginPage == null) {
            throw new ServletException("FormLogin needs an form-login-page");
        }
    }

    public String getAuthType() {
        return "Form";
    }

    public Principal authenticate(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        Principal user = this.getUserPrincipal(request, response, application);
        if (user != null) {
            return user;
        }
        String path = request.getServletPath();
        if (path == null) {
            path = request.getPathInfo();
        } else if (request.getPathInfo() != null) {
            path = path + request.getPathInfo();
        }
        if (path.equals("")) {
            path = request.getContextPath() + "/";
            response.sendRedirect(response.encodeRedirectURL(path));
            return null;
        }
        Application app = (Application)application;
        String uri = request.getRequestURI();
        if (path.endsWith("/j_security_check")) {
            RequestDispatcher disp = application.getNamedDispatcher("j_security_check");
            disp.forward((ServletRequest)request, (ServletResponse)response);
            return null;
        }
        if (uri.equals(this.loginPage) || uri.equals(this.errorPage)) {
            request.getRequestDispatcher(path).forward((ServletRequest)request, (ServletResponse)response);
            return null;
        }
        HttpSession session = request.getSession();
        session.putValue(LOGIN_SAVED_PATH, (Object)path);
        session.putValue(LOGIN_SAVED_QUERY, (Object)request.getQueryString());
        if (response instanceof Response) {
            ((Response)response).killCache();
        }
        if (!this.loginPage.startsWith("/")) {
            response.sendRedirect(response.encodeRedirectURL(this.loginPage));
            return null;
        }
        request.setAttribute("caucho.login", (Object)"login");
        RequestDispatcher disp = app.getLoginDispatcher(this.loginPage);
        disp.forward((ServletRequest)request, (ServletResponse)response);
        if (dbg.canWrite()) {
            dbg.log("the form request has no authenticated user");
        }
        return null;
    }
}

