/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.security;

import com.caucho.http.security.FormLogin;
import com.caucho.http.security.ServletAuthenticator;
import com.caucho.server.http.Application;
import com.caucho.server.http.QRequestDispatcher;
import com.caucho.server.http.Response;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.GenericServlet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FormLoginServlet
extends GenericServlet {
    private WriteStream dbg = LogStream.open("/caucho.com/http/security");
    static L10N L = new L10N("com/caucho/http/security/messages");

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean useInternalForward;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        Application app = (Application)this.getServletContext();
        FormLogin login = (FormLogin)app.getAttribute("caucho.login");
        String username = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        ServletAuthenticator auth = login.getAuthenticator();
        Principal user = auth.login(req, res, app, username, password);
        if (this.dbg.canWrite()) {
            this.dbg.log("auth: " + user);
        }
        if (user == null) {
            String errorPage = login.getFormErrorPage();
            RequestDispatcher disp = app.getLoginDispatcher(errorPage);
            req.setAttribute("caucho.login", (Object)"login");
            if (res instanceof Response) {
                ((Response)res).killCache();
            } else {
                res.setDateHeader("Expires", 0L);
                res.setHeader("Cache-Control", "no-cache");
            }
            ((QRequestDispatcher)disp).forward((ServletRequest)req, (ServletResponse)res, "GET", false);
            return;
        }
        HttpSession session = req.getSession();
        String uri = (String)session.getValue("com.caucho.servlet.login.path");
        String query = (String)session.getValue("com.caucho.servlet.login.query");
        session.removeAttribute("com.caucho.servlet.login.path");
        session.removeAttribute("com.caucho.servlet.login.query");
        if (this.dbg.canWrite()) {
            this.dbg.log("old path:" + uri + " query:" + query + " j_uri:" + req.getParameter("j_uri"));
        }
        boolean formURIPriority = login.getFormURIPriority();
        if ((uri == null || formURIPriority) && req.getParameter("j_uri") != null) {
            uri = req.getParameter("j_uri");
        } else if (uri != null && query != null) {
            uri = uri + "?" + query;
        }
        if (uri == null) {
            throw new ServletException(L.l("No forwarding URI for form authentication.  Either the login form must specify j_uri or the session must have a saved URI."));
        }
        String uriPwd = req.getRequestURI();
        int p = uriPwd.indexOf("/j_security_check");
        if (p >= 0) {
            uriPwd = uriPwd.substring(0, p + 1);
        }
        if (uri.length() != 0) {
            if (uri.charAt(0) == '/') {
                uri = req.getContextPath() + uri;
            } else if (uri.indexOf(58) < 0 || uri.indexOf(58) >= uri.indexOf(47) && uri.indexOf(47) >= 0) {
                uri = uriPwd + uri;
            }
        }
        if ((useInternalForward = login.getInternalForward()) && uri.startsWith(uriPwd) && uri.indexOf(47, uriPwd.length() + 1) < 0) {
            Application newApp = (Application)app.getContext(uri);
            String suffix = uri.substring(newApp.getContextPath().length());
            RequestDispatcher disp = newApp.getLoginDispatcher(suffix);
            disp.forward((ServletRequest)req, (ServletResponse)res);
            return;
        }
        res.sendRedirect(res.encodeRedirectURL(uri));
    }
}

