/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.security;

import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import java.security.MessageDigest;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PasswordDigest {
    private String algorithm = "MD5";
    private String format = "base64";
    private MessageDigest digest;
    private byte[] digestBytes = new byte[256];

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public synchronized void init() throws ServletException {
        try {
            this.digest = MessageDigest.getInstance(this.algorithm);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String getPasswordDigest(String user, String password) throws ServletException {
        return this.getPasswordDigest(null, null, null, user, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPasswordDigest(HttpServletRequest request, HttpServletResponse response, ServletContext app, String user, String password) throws ServletException {
        if (this.digest == null) {
            this.init();
        }
        try {
            MessageDigest messageDigest = this.digest;
            synchronized (messageDigest) {
                this.digest.reset();
                PasswordDigest.addDigestUTF8(this.digest, user);
                this.digest.update((byte)58);
                PasswordDigest.addDigestUTF8(this.digest, password);
                int len = this.digest.digest(this.digestBytes, 0, this.digestBytes.length);
                return this.digestToString(this.digestBytes, len);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private static void addDigestUTF8(MessageDigest digest, String string) {
        if (string == null) {
            return;
        }
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            if (ch < '\u0080') {
                digest.update((byte)ch);
                continue;
            }
            if (ch < '\u0800') {
                digest.update((byte)(192 + (ch >> 6)));
                digest.update((byte)(128 + (ch & 0x3F)));
                continue;
            }
            digest.update((byte)(224 + (ch >> 12)));
            digest.update((byte)(128 + (ch >> 6 & 0x3F)));
            digest.update((byte)(128 + (ch & 0x3F)));
        }
    }

    protected String digestToString(byte[] digest, int len) {
        if (this.format.equals("base64")) {
            return PasswordDigest.digestToBase64(digest, len);
        }
        return PasswordDigest.digestToHex(digest, len);
    }

    protected static String digestToBase64(byte[] digest, int len) {
        CharBuffer cb = CharBuffer.allocate();
        Base64.encode(cb, digest, 0, len);
        for (int i = cb.length() - 1; i >= 0; --i) {
            if (cb.charAt(i) == '=') continue;
            cb.setLength(i + 1);
            break;
        }
        return cb.close();
    }

    protected static String digestToHex(byte[] digest, int len) {
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < len; ++i) {
            int d1 = digest[i] >> 4 & 0xF;
            int d2 = digest[i] & 0xF;
            if (d1 >= 10) {
                cb.append((char)(d1 + 97 - 10));
            } else {
                cb.append((char)(d1 + 48));
            }
            if (d2 >= 10) {
                cb.append((char)(d2 + 97 - 10));
                continue;
            }
            cb.append((char)(d2 + 48));
        }
        return cb.close();
    }
}

