/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.security;

import com.caucho.http.security.AbstractConstraint;
import com.caucho.server.http.AbstractRequest;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class SecurityFilter
implements Filter {
    private FilterConfig config;
    private ServletContext application;
    private boolean needsAuthentication;
    private AbstractConstraint[] constraints;
    private HashMap methodMap;

    public void setConstraints(AbstractConstraint[] constraints) {
        this.constraints = constraints;
    }

    public void setMethodMap(HashMap methodMap) {
        this.methodMap = methodMap;
    }

    public void init(FilterConfig config) {
        this.config = config;
        this.application = config.getServletContext();
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        AbstractRequest req = (AbstractRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (request.getAttribute("caucho.login") == null) {
            AbstractConstraint[] constraints = this.constraints;
            if (constraints == null && this.methodMap != null) {
                constraints = (AbstractConstraint[])this.methodMap.get(req.getMethod());
            }
            if (constraints != null) {
                boolean hasAuth = false;
                for (int i = 0; i < constraints.length; ++i) {
                    if (!hasAuth && constraints[i].needsAuthentication()) {
                        hasAuth = true;
                        if (!req.authenticate()) {
                            return;
                        }
                    }
                    if (constraints[i].isAuthorized(req, res, this.application)) continue;
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }
}

