/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.security;

import com.caucho.http.security.AbstractConstraint;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TransportConstraint
extends AbstractConstraint {
    private String transport;

    public void setTransportGuarantee(String transportGuarantee) {
        this.transport = transportGuarantee;
    }

    public boolean isAuthorized(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        if (request.isSecure()) {
            return true;
        }
        String url = request.getRequestURL().toString();
        if (url.startsWith("http:")) {
            url = "https:" + url.substring(5);
            String queryString = request.getQueryString();
            if (queryString != null) {
                response.sendRedirect(url + "?" + queryString);
            } else {
                response.sendRedirect(url);
            }
            return false;
        }
        response.sendError(403, null);
        return false;
    }
}

