/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.server;

import com.caucho.Version;
import com.caucho.http.server.FastCGIRequest;
import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.Request;
import com.caucho.server.http.Response;
import com.caucho.util.Alarm;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.servlet.http.Cookie;

public class FastCGIResponse
extends Response {
    static final int FCGI_BEGIN_REQUEST = 1;
    static final int FCGI_ABORT_REQUEST = 2;
    static final int FCGI_END_REQUEST = 3;
    static final int FCGI_PARAMS = 4;
    static final int FCGI_STDIN = 5;
    static final int FCGI_STDOUT = 6;
    static final int FCGI_STDERR = 7;
    static final int FCGI_DATA = 8;
    static final int FCGI_GET_VALUES = 9;
    static final int FCGI_GET_VALUES_RESULT = 10;
    static final int FCGI_UNKNOWNE_TYPE = 11;
    FastCGIRequest req;

    FastCGIResponse(Request request) {
        super(request);
        this.req = (FastCGIRequest)request;
    }

    protected void init(AbstractRequest request, WriteStream stream) {
        super.init(request, stream);
    }

    protected boolean writeHeadersInt(WriteStream os, int length) throws IOException {
        boolean isChunked = false;
        boolean debug = dbg.canWrite();
        if (!this.containsHeader("Server")) {
            os.print("Server: Resin/" + Version.VERSION + "\r\n");
        }
        if (this.isNoCache) {
            this.removeHeader("ETag");
            this.removeHeader("Last-Modified");
            this.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
            os.print("Cache-Control: no-cache\r\n");
            if (debug) {
                dbg.log("Expires: Thu, 01 Dec 1994 16:00:00 GMT");
            }
        } else if (this.isPrivateCache()) {
            os.print("Cache-Control: private\r\n");
            if (debug) {
                dbg.log("Cache-Control: private");
            }
        }
        int size = this.headerKeys.size();
        for (int i = 0; i < size; ++i) {
            String key = (String)this.headerKeys.get(i);
            os.print(key);
            os.write(58);
            os.write(32);
            os.print((String)this.headerValues.get(i));
            os.write(13);
            os.write(10);
            if (!debug) continue;
            dbg.log("" + key + ": " + this.headerValues.get(i));
        }
        long date = Alarm.getCurrentTime();
        for (int i = 0; i < this.cookiesOut.size(); ++i) {
            Cookie cookie = (Cookie)this.cookiesOut.get(i);
            int cookieVersion = cookie.getVersion();
            this.fillCookie(this.cb, cookie, date, 0);
            os.print("Set-Cookie: ");
            os.print(this.cb.getBuffer(), 0, this.cb.getLength());
            os.print("\r\n");
            if (cookieVersion > 0) {
                this.fillCookie(this.cb, cookie, date, cookieVersion);
                os.print("Set-Cookie2: ");
                os.print(this.cb.getBuffer(), 0, this.cb.getLength());
                os.print("\r\n");
            }
            if (!debug) continue;
            dbg.log("Set-Cookie: " + this.cb);
        }
        if (this.contentType == "text/html") {
            os.print("Content-Type: text/html\r\n");
            if (debug) {
                dbg.log("Content-Type: text/html");
            }
        } else if (this.contentType != null) {
            os.print("Content-Type: ");
            os.print(this.contentType);
            os.print("\r\n");
            if (debug) {
                dbg.log("Content-Type: " + this.contentType);
            }
        }
        boolean hasContentLength = false;
        if (this.statusCode == 304) {
            hasContentLength = true;
        } else if (this.contentLength >= 0L) {
            os.print("Content-Length:");
            os.print(this.contentLength);
            os.print("\r\n");
            hasContentLength = true;
            if (debug) {
                dbg.log("Content-Length: " + this.contentLength);
            }
        } else if (length >= 0) {
            os.print("Content-Length:");
            os.print(length);
            os.print("\r\n");
            hasContentLength = true;
            if (debug) {
                dbg.log("Content-Length: " + length);
            }
        }
        os.print("\r\n");
        return false;
    }

    protected void writeHeadFinish(WriteStream os, int length) throws IOException {
    }
}

