/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.servlet;

import com.caucho.Version;
import com.caucho.http.admin.ApplicationAdmin;
import com.caucho.http.admin.HostAdmin;
import com.caucho.http.admin.ServerAdmin;
import com.caucho.http.admin.TcpServerAdmin;
import com.caucho.http.distribution.DistributionServer;
import com.caucho.server.http.Application;
import com.caucho.server.http.ServletServer;
import com.caucho.sql.DBPool;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResinStatusServlet
extends GenericServlet {
    protected static WriteStream dbg = LogStream.open("/caucho.com/http/resin-status");
    static L10N L = new L10N(class$com$caucho$http$servlet$ResinStatusServlet == null ? (class$com$caucho$http$servlet$ResinStatusServlet = ResinStatusServlet.class$("com.caucho.http.servlet.ResinStatusServlet")) : class$com$caucho$http$servlet$ResinStatusServlet);
    private Application _app;
    private ApplicationAdmin _appAdmin;
    private ServletServer _server;
    private ServerAdmin _serverAdmin;
    static /* synthetic */ Class class$com$caucho$http$servlet$ResinStatusServlet;
    static /* synthetic */ Class class$javax$ejb$EJBLocalHome;
    static /* synthetic */ Class class$javax$ejb$EJBHome;

    public void init() throws ServletException {
        String enable = this.getInitParameter("enable");
        if (!"read".equals(enable) && !"write".equals(enable)) {
            throw new ServletException(L.l("resin-status is disabled. enable=`{0}'.", enable));
        }
        this._app = (Application)this.getServletContext();
        this._server = this._app.getServer();
        this._appAdmin = (ApplicationAdmin)this._app.getAttribute("caucho.admin");
        if (this._appAdmin == null) {
            throw new ServletException(L.l("This application is not permitted to access the admin information."));
        }
        this._serverAdmin = this._appAdmin.getServerAdmin();
        if (this._serverAdmin == null) {
            throw new ServletException(L.l("Missing server admin."));
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        ApplicationAdmin appAdmin;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        this.printHeader(out);
        String hostName = req.getParameter("host");
        String appName = req.getParameter("app");
        HostAdmin hostAdmin = this._serverAdmin.getHostAdmin(hostName);
        if (hostAdmin != null && (appAdmin = hostAdmin.getApplication(appName)) != null) {
            this.printApplication(out, appAdmin, req.getRequestURI());
            return;
        }
        this.printServerHeader(out);
        this.printTcpServers(out);
        this.printSrun(out);
        this.printJNDI(out, this._server.getJndiContext());
        this.printApplicationSummary(out, req.getRequestURI());
        this.printFooter(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printApplication(PrintWriter out, ApplicationAdmin app, String pwd) throws IOException, ServletException {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(app.getClassLoader());
            this.printHeader(out);
            this.printApplicationHeader(out, app, pwd);
            this.printJNDI(out, app.getJndiContext());
            this.printJMXServlets(out, app.getMBeanServer());
            this.printFooter(out);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public void printHeader(PrintWriter out) throws IOException, ServletException {
    }

    public void printServerHeader(PrintWriter out) throws IOException, ServletException {
        Path config;
        out.println("<b>resin-status</b><br><br>");
        String id = this._server.getServerId();
        out.println("<table border=\"0\">");
        if (id != null) {
            out.println("<tr><td><b>Server:</b><td>" + id);
        }
        if ((config = this._server.getConfig()) != null) {
            out.println("<tr><td><b>Config:</b><td>" + config.getNativePath());
        }
        long startTime = this._server.getStartTime();
        long restartTime = this._server.getRestartTime();
        out.println("<tr><td><b>Server Start:</b><td>" + QDate.formatLocal(startTime));
        out.println("<tr><td><b>Server Reload:</b><td> " + QDate.formatLocal(restartTime));
        long totalMemory = Runtime.getRuntime().totalMemory();
        out.println("<tr><td><b>Total Memory:</b><td> " + totalMemory / 1000000L + "." + totalMemory / 100000L % 10L + totalMemory / 10000L % 10L + "Meg");
        long freeMemory = Runtime.getRuntime().freeMemory();
        out.println("<tr><td><b>Free Memory:</b><td> " + freeMemory / 1000000L + "." + freeMemory / 100000L % 10L + freeMemory / 10000L % 10L + "Meg");
        out.println("</table>");
    }

    public void printApplicationHeader(PrintWriter out, ApplicationAdmin app, String pwd) throws IOException, ServletException {
        Path config;
        HostAdmin host = app.getHostAdmin();
        out.println("<b><a href=\"" + pwd + "\">resin-status</a> > ");
        out.println("<a href=\"" + pwd + "?host=" + host.getName() + "\">" + host.getURL() + "</a> > ");
        out.println(app.getContextPath() + "</b><br><br>");
        String id = this._server.getServerId();
        out.println("<table border=\"0\">");
        if (id != null) {
            out.println("<tr><td><b>Server:</b><td>" + id);
        }
        if ((config = this._server.getConfig()) != null) {
            out.println("<tr><td><b>Config:</b><td>" + config.getNativePath());
        }
        out.println("<tr><td><b>Host:</b><td>" + app.getHostAdmin().getURL());
        out.println("<tr><td><b>Web-App:</b><td>" + app.getContextPath());
        out.println("<tr><td><b>App-Dir:</b><td>" + app.getAppDir().getNativePath());
        long startTime = this._server.getStartTime();
        long restartTime = app.getStartTime();
        out.println("<tr><td><b>Server Start:</b><td>" + QDate.formatLocal(startTime));
        out.println("<tr><td><b>Web-App Start:</b><td> " + QDate.formatLocal(restartTime));
        long totalMemory = Runtime.getRuntime().totalMemory();
        out.println("<tr><td><b>Total Memory:</b><td> " + totalMemory / 1000000L + "." + totalMemory / 100000L % 10L + totalMemory / 10000L % 10L + "Meg");
        long freeMemory = Runtime.getRuntime().freeMemory();
        out.println("<tr><td><b>Free Memory:</b><td> " + freeMemory / 1000000L + "." + freeMemory / 100000L % 10L + freeMemory / 10000L % 10L + "Meg");
        out.println("<tr><td><b>Sessions:</b><td>" + app.getActiveSessionCount());
        out.println("</table>");
    }

    public void printTcpServers(PrintWriter out) throws IOException, ServletException {
        ArrayList serverList = this._server.getTcpServerAdminList();
        if (serverList.size() > 0) {
            out.println("<h3>TCP ports</h3>");
            out.println("<table border='2'>");
            out.println("<tr><th><th colspan='3'>Current Threads<th colspan='3'>Config");
            out.println("<tr><th>Protocol:Port");
            out.println("    <th>Active<th>Keepalive<th>Total");
            out.println("    <th>thread-max<th>keepalive-max<th>request-timeout");
            for (int i = 0; i < serverList.size(); ++i) {
                TcpServerAdmin admin = (TcpServerAdmin)serverList.get(i);
                out.print("<tr><td>");
                out.print(admin.getProtocolName() + ":" + admin.getSocketPort());
                out.println();
                out.print("    <td>" + admin.getActiveConnectionCount());
                out.print("<td>" + admin.getKeepaliveConnectionCount());
                out.print("<td>" + admin.getConnectionCount());
                out.println();
                out.print("    <td>" + admin.getConnectionMax());
                out.print("<td>" + admin.getKeepaliveMax());
                out.print("<td>" + admin.getSocketTimeout() / 1000L);
                out.println();
            }
            out.println("</table>");
        }
    }

    public void printSrun(PrintWriter out) throws IOException, ServletException {
        DistributionServer[] srunList = this._server.getDistributionServerList();
        if (srunList == null || srunList.length == 0) {
            return;
        }
        out.println("<h3>Srun Servers</h3>");
        out.println("<table border=2>");
        out.println("<tr><th>Host</th><th>Active Count</th><th>live-time</th><th>dead-time</th><th>request-timeout</th>");
        for (int i = 0; i < srunList.length; ++i) {
            DistributionServer srun = srunList[i];
            out.print("<tr>");
            boolean isLive = false;
            try {
                ReadWritePair pair = srun.open();
                if (pair != null) {
                    isLive = true;
                    srun.free(pair);
                }
            }
            catch (Throwable e) {
                dbg.log(e);
            }
            if (isLive) {
                out.println("<td bgcolor=\"#66ff66\">" + (srun.getIndex() + 1) + ". " + srun.getHost() + ":" + srun.getPort() + (srun.isBackup() ? "*" : "") + " (ok)");
            } else {
                out.println("<td bgcolor=\"#ff6666\">" + (srun.getIndex() + 1) + ". " + srun.getHost() + ":" + srun.getPort() + (srun.isBackup() ? "*" : "") + " (down)");
            }
            out.println("<td>" + srun.getActiveCount());
            out.println("<td>" + srun.getLiveTime() / 1000L);
            out.println("<td>" + srun.getDeadTime() / 1000L);
            out.println("<td>" + srun.getTimeout() / 1000);
        }
        out.println("</table>");
    }

    public void printJNDI(PrintWriter out, Context ic) throws IOException, ServletException {
        this.printDatabasePools(out, ic);
        this.printEJBLocalHomes(out, ic);
        this.printEJBRemoteHomes(out, ic);
    }

    public void printDatabasePools(PrintWriter out, Context ic) throws IOException, ServletException {
        try {
            Context jdbcCxt = (Context)ic.lookup("java:comp/env/jdbc");
            NamingEnumeration<NameClassPair> list = jdbcCxt.list("");
            ArrayList<String> poolNames = new ArrayList<String>();
            while (list.hasMoreElements()) {
                NameClassPair pair = (NameClassPair)list.nextElement();
                poolNames.add(pair.getName());
            }
            if (poolNames.size() == 0) {
                return;
            }
            out.println("<h3>Database pools</h3>");
            out.println("<table border=\"2\">");
            out.println("<tr><th><th><th><th colspan=\"2\">Connections");
            out.println("<tr><th>Name<th>URL<th>XA<th>Active<th>Total");
            Collections.sort(poolNames);
            for (int i = 0; i < poolNames.size(); ++i) {
                String name = (String)poolNames.get(i);
                Object value = jdbcCxt.lookup(name);
                if (!(value instanceof DBPool)) continue;
                DBPool pool = (DBPool)value;
                out.print("<tr><td>" + pool.getName());
                out.print("<td>" + pool.getURL());
                if (pool.isTransactional()) {
                    out.print("<td>xa");
                } else {
                    out.print("<td>&nbsp;");
                }
                out.print("<td>" + pool.getActiveConnections());
                out.print("<td>" + pool.getTotalConnections());
            }
            out.println("</table>");
        }
        catch (Exception e) {
            dbg.log(e);
        }
    }

    public void printEJBLocalHomes(PrintWriter out, Context ic) throws IOException, ServletException {
        try {
            Context cmpCxt = (Context)ic.lookup("java:comp/env/cmp");
            if (cmpCxt == null) {
                return;
            }
            NamingEnumeration<NameClassPair> list = cmpCxt.list("");
            ArrayList<String> cmpNames = new ArrayList<String>();
            while (list.hasMoreElements()) {
                NameClassPair pair = (NameClassPair)list.nextElement();
                cmpNames.add(pair.getName());
            }
            if (cmpNames.size() == 0) {
                return;
            }
            out.println("<h3>EJB Local Home</h3>");
            out.println("<table border=\"2\">");
            out.println("<tr><th>Name<th>Home Stub Class");
            Collections.sort(cmpNames);
            for (int i = 0; i < cmpNames.size(); ++i) {
                String name = (String)cmpNames.get(i);
                Object value = cmpCxt.lookup(name);
                if (!(value instanceof EJBLocalHome)) continue;
                EJBLocalHome home = (EJBLocalHome)value;
                out.print("<tr><td>cmp/" + name);
                Class<?> homeStub = home.getClass();
                Class<?>[] interfaces = home.getClass().getInterfaces();
                for (int j = 0; j < interfaces.length; ++j) {
                    if (!(class$javax$ejb$EJBLocalHome == null ? ResinStatusServlet.class$("javax.ejb.EJBLocalHome") : class$javax$ejb$EJBLocalHome).isAssignableFrom(interfaces[j])) continue;
                    homeStub = interfaces[j];
                    break;
                }
                out.print("<td>" + homeStub.getName());
            }
            out.println("</table>");
        }
        catch (Exception e) {
            dbg.log(e);
        }
    }

    public void printEJBRemoteHomes(PrintWriter out, Context ic) throws IOException, ServletException {
        try {
            Context ejbCxt = (Context)ic.lookup("java:comp/env/ejb");
            if (ejbCxt == null) {
                return;
            }
            NamingEnumeration<NameClassPair> list = ejbCxt.list("");
            ArrayList<String> ejbNames = new ArrayList<String>();
            while (list.hasMoreElements()) {
                NameClassPair pair = (NameClassPair)list.nextElement();
                ejbNames.add(pair.getName());
            }
            if (ejbNames.size() == 0) {
                return;
            }
            out.println("<h3>EJB Home</h3>");
            out.println("<table border=\"2\">");
            out.println("<tr><th>Name<th>Home Stub Class");
            Collections.sort(ejbNames);
            for (int i = 0; i < ejbNames.size(); ++i) {
                String name = (String)ejbNames.get(i);
                Object value = ejbCxt.lookup(name);
                if (!(value instanceof EJBHome)) continue;
                EJBHome home = (EJBHome)value;
                out.print("<tr><td>ejb/" + name);
                Class<?> homeStub = home.getClass();
                Class<?>[] interfaces = home.getClass().getInterfaces();
                for (int j = 0; j < interfaces.length; ++j) {
                    if (!(class$javax$ejb$EJBHome == null ? ResinStatusServlet.class$("javax.ejb.EJBHome") : class$javax$ejb$EJBHome).isAssignableFrom(interfaces[j])) continue;
                    homeStub = interfaces[j];
                    break;
                }
                out.print("<td>" + homeStub.getName());
            }
            out.println("</table>");
        }
        catch (Exception e) {
            dbg.log(e);
        }
    }

    public void printJMXServlets(PrintWriter out, MBeanServer server) throws IOException, ServletException {
        try {
            ObjectName queryName = new ObjectName("*:j2eeType=Servlet,*");
            Set<ObjectName> servlets = server.queryNames(queryName, null);
            if (servlets.size() == 0) {
                return;
            }
            out.println("<h3>Servlets</h3>");
            Iterator<ObjectName> iter = servlets.iterator();
            while (iter.hasNext()) {
                int i;
                ObjectName servletName = iter.next();
                String name = servletName.getKeyProperty("name");
                MBeanInfo mbeanInfo = server.getMBeanInfo(servletName);
                MBeanAttributeInfo[] attrs = mbeanInfo.getAttributes();
                out.println("<table border=\"2\">");
                out.print("<tr><th>Name</th>");
                for (i = 0; i < attrs.length; ++i) {
                    out.print("<th>" + attrs[i].getName() + "</th>");
                }
                out.println("</tr>");
                out.print("<tr><td>" + name + "</td>");
                for (i = 0; i < attrs.length; ++i) {
                    Object value = server.getAttribute(servletName, attrs[i].getName());
                    out.print("<td>" + value + "</td>");
                }
                out.println("</table>");
            }
        }
        catch (Exception e) {
            dbg.log(e);
        }
    }

    public void printApplicationSummary(PrintWriter out, String pwd) throws IOException, ServletException {
        out.println("<h3>Hosts and Applications</h3>");
        out.println("<table border=\"2\">");
        out.println("<tr><th>Host<th>Web-App<th>Sessions");
        ArrayList hosts = this._serverAdmin.getHostAdminList();
        Collections.sort(hosts, new HostCompare());
        for (int i = 0; i < hosts.size(); ++i) {
            HostAdmin hostAdmin = (HostAdmin)hosts.get(i);
            out.println("<tr><td><b>" + hostAdmin.getURL() + "</b>");
            ArrayList apps = hostAdmin.getApplicationAdminList();
            Collections.sort(apps, new AppCompare());
            for (int j = 0; j < apps.size(); ++j) {
                ApplicationAdmin appAdmin = (ApplicationAdmin)apps.get(j);
                String contextPath = appAdmin.getContextPath();
                if (contextPath.equals("")) {
                    contextPath = "/";
                }
                out.print("<tr><td><td>");
                out.print("<a href=\"" + pwd + "?host=" + hostAdmin.getName() + "&app=" + appAdmin.getContextPath() + "\">");
                out.print(contextPath);
                out.print("</a><td>" + appAdmin.getActiveSessionCount());
            }
        }
        out.println("</table>");
    }

    public void printVirtualHosts(PrintWriter out) throws IOException, ServletException {
    }

    public void printFooter(PrintWriter out) throws IOException, ServletException {
        if (this._server.isTesting()) {
            out.println("<br><em>Resin test</em>");
        } else {
            out.println("<br><em>" + Version.FULL_VERSION + "</em>");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class AppCompare
    implements Comparator {
        AppCompare() {
        }

        public int compare(Object a, Object b) {
            ApplicationAdmin appA = (ApplicationAdmin)a;
            ApplicationAdmin appB = (ApplicationAdmin)b;
            return appA.getContextPath().compareTo(appB.getContextPath());
        }
    }

    static class HostCompare
    implements Comparator {
        HostCompare() {
        }

        public int compare(Object a, Object b) {
            HostAdmin hostA = (HostAdmin)a;
            HostAdmin hostB = (HostAdmin)b;
            return hostA.getURL().compareTo(hostB.getURL());
        }
    }
}

