/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.ExternalCompiler;
import com.caucho.java.JavaCompileException;
import com.caucho.java.JavacErrorParser;
import com.caucho.java.LineMap;
import com.caucho.regexp.Regexp;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.DynamicClassLoader;
import com.caucho.util.L10N;
import com.caucho.util.Registry;
import com.caucho.util.RegistryException;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.MemoryStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import sun.tools.javac.Main;

public class JavaCompiler {
    static L10N L = new L10N("com/caucho/java/messages");
    static Object LOCK = new Object();
    static WriteStream dbg = LogStream.open("/caucho.com/java");
    private static boolean hasCompiler;
    private ClassLoader loader;
    private String compiler;
    private Path classDir;
    private Path sourceDir;
    private boolean compileParent = true;
    private String extraClassPath;
    private String classPath;
    protected String charEncoding;
    protected ArrayList args;
    protected long maxCompileTime;

    public static JavaCompiler create(ClassLoader loader) {
        JavaCompiler compiler;
        block7: {
            String factory = Registry.getString("/caucho.com/java/compiler-factory", null);
            String javac = Registry.getString("/caucho.com/java/compiler", "javac");
            if (javac == null || javac.equals("")) {
                javac = "javac";
            }
            compiler = null;
            if (factory != null) {
                try {
                    Class cl = CauchoSystem.loadClass(factory, false, loader);
                    compiler = (JavaCompiler)cl.newInstance();
                }
                catch (Exception e) {
                    dbg.log(e);
                    throw new RuntimeException(e.toString());
                }
            } else {
                compiler = javac.equals("internal") ? new JavaCompiler() : new ExternalCompiler();
            }
            compiler.setClassLoader(loader);
            compiler.setCompiler(javac);
            String argString = Registry.getString("/caucho.com/java/args", null);
            argString = Registry.getString("/caucho.com/java/compiler-args", argString);
            compiler.setArgs(argString);
            String classPath = Registry.getString("/caucho.com/java/classpath", null);
            compiler.setExtraClassPath(classPath);
            String encoding = Registry.getString("/caucho.com/java/encoding", null);
            compiler.setEncoding(encoding);
            try {
                long time = Registry.getPeriod("/caucho.com/java/max-compile-time", 30000L);
                compiler.setMaxCompileTime(time);
            }
            catch (RegistryException e) {
                if (!dbg.canWrite()) break block7;
                dbg.log(e);
            }
        }
        return compiler;
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void setCompiler(String compiler) {
        this.compiler = compiler;
    }

    public String getCompiler() {
        if (this.compiler == null) {
            this.compiler = "javac";
        }
        return this.compiler;
    }

    public void setClassDir(Path path) {
        try {
            path.mkdirs();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.classDir = path;
    }

    Path getClassDir() {
        if (this.classDir == null) {
            this.setClassDir(CauchoSystem.getWorkPath());
        }
        return this.classDir;
    }

    String getClassDirName() {
        return this.getClassDir().getNativePath();
    }

    public void setSourceDir(Path path) {
        this.sourceDir = path;
    }

    public Path getSourceDir() {
        if (this.sourceDir == null) {
            this.setSourceDir(this.getClassDir());
        }
        return this.sourceDir;
    }

    String getSourceDirName() {
        return this.getSourceDir().getNativePath();
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public void setExtraClassPath(String classPath) {
        this.extraClassPath = classPath;
    }

    public void setCompileParent(boolean compileParent) {
        this.compileParent = compileParent;
    }

    public String getClassPath() {
        if (this.classPath != null) {
            return this.classPath;
        }
        if (this.classPath == null && this.loader instanceof DynamicClassLoader) {
            this.classPath = ((DynamicClassLoader)this.loader).getTop().getClassPath();
        } else if (this.classPath == null) {
            this.classPath = CauchoSystem.getClassPath();
        }
        String srcDirName = this.getSourceDirName();
        String classDirName = this.getClassDirName();
        char sep = CauchoSystem.getPathSeparatorChar();
        if (this.extraClassPath != null) {
            this.classPath = this.classPath + sep + this.extraClassPath;
        }
        if (!srcDirName.equals(classDirName)) {
            this.classPath = srcDirName + sep + this.classPath;
        }
        this.classPath = classDirName + sep + this.classPath;
        return this.classPath;
    }

    public void setArgs(String argString) {
        try {
            if (argString != null) {
                this.args = new Regexp("[\\s,]+").split(argString);
            }
        }
        catch (Exception e) {
            dbg.log(e);
        }
    }

    public void setEncoding(String encoding) {
        this.charEncoding = encoding;
        String javaEncoding = Encoding.getJavaName(encoding);
        if ("ISO8859_1".equals(javaEncoding)) {
            this.charEncoding = null;
        }
    }

    public long getMaxCompileTime() {
        return this.maxCompileTime;
    }

    public void setMaxCompileTime(long maxCompileTime) {
        this.maxCompileTime = maxCompileTime;
    }

    public static String mangleName(String name) {
        boolean toLower = CauchoSystem.isCaseInsensitive();
        CharBuffer cb = new CharBuffer();
        cb.append("_");
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '/' || ch == CauchoSystem.getPathSeparatorChar()) {
                if (i == 0 || cb.charAt(cb.length() - 1) == '.') continue;
                cb.append("._");
                continue;
            }
            if (ch == '.') {
                cb.append("__");
                continue;
            }
            if (ch == '_') {
                cb.append("_0");
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                cb.append(toLower ? Character.toLowerCase(ch) : ch);
                continue;
            }
            if (ch <= '\u0100') {
                cb.append("_2" + JavaCompiler.encodeHex(ch >> 4) + JavaCompiler.encodeHex(ch));
                continue;
            }
            cb.append("_4" + JavaCompiler.encodeHex(ch >> 12) + JavaCompiler.encodeHex(ch >> 8) + JavaCompiler.encodeHex(ch >> 4) + JavaCompiler.encodeHex(ch));
        }
        if (cb.length() == 0) {
            cb.append("_z");
        }
        return cb.toString();
    }

    private static char encodeHex(int i) {
        if ((i &= 0xF) < 10) {
            return (char)(i + 48);
        }
        return (char)(i - 10 + 97);
    }

    public void setArgs(ArrayList args) {
        if (args == null) {
            return;
        }
        if (this.args == null) {
            this.args = new ArrayList();
        }
        for (int i = 0; i < args.size(); ++i) {
            this.args.add(args.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(String fileName, LineMap lineMap) throws IOException, ClassNotFoundException {
        ClassLoader parent;
        if (this.compileParent && this.loader instanceof DynamicClassLoader && (parent = ((DynamicClassLoader)this.loader).getParentLoader()) instanceof DynamicClassLoader) {
            ((DynamicClassLoader)parent).makeAll();
        }
        int p = fileName.lastIndexOf(46);
        String path = fileName.substring(0, p);
        String javaName = path + ".java";
        Path javaPath = this.getSourceDir().lookup(javaName);
        String className = path + ".class";
        Path classPath = this.getClassDir().lookup(className);
        Object object = LOCK;
        synchronized (object) {
            if (javaPath.canRead() && classPath.exists()) {
                classPath.remove();
            }
            this.compileInt(fileName, lineMap);
        }
    }

    protected void compileInt(String path, LineMap lineMap) throws IOException, JavaCompileException {
        if (!hasCompiler) {
            try {
                Class.forName("sun.tools.javac.Main");
                hasCompiler = true;
            }
            catch (Exception e) {
                throw new JavaCompileException(L.l("Resin can't load sun.tools.javac.Main.  Usually this means that the JDK tools.jar is missing from the classpath, possibly because of using a JRE instead of the JDK.  You can either add tools.jar to the classpath or change the compiler to an external one with <java compiler='javac'/> or jikes.\n\n{0}", String.valueOf(e)));
            }
        }
        this.executeInt(path, lineMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInt(String path, LineMap lineMap) throws JavaCompileException, IOException {
        MemoryStream tempStream = new MemoryStream();
        WriteStream error = new WriteStream(tempStream);
        try {
            String[] args;
            Main javaCompiler;
            int i;
            String encoding;
            Path javaPath = this.getSourceDir().lookup(path);
            ArrayList<String> argList = new ArrayList<String>();
            argList.add("-d");
            argList.add(this.getClassDirName());
            if (this.charEncoding != null && (encoding = Encoding.getJavaName(this.charEncoding)) != null && !encoding.equals("ISO8859_1")) {
                argList.add("-encoding");
                argList.add(this.charEncoding);
            }
            argList.add("-classpath");
            argList.add(this.getClassPath());
            for (i = 0; this.args != null && i < this.args.size(); ++i) {
                argList.add((String)this.args.get(i));
            }
            argList.add(javaPath.getNativePath());
            if (dbg.canWrite()) {
                dbg.print("javac(int)");
                for (i = 0; i < argList.size(); ++i) {
                    dbg.print(" ");
                    dbg.print(argList.get(i));
                }
                dbg.println();
            }
            if (!(javaCompiler = new Main((OutputStream)error, "javac")).compile(args = argList.toArray(new String[argList.size()]))) {
                ReadStream read;
                error.close();
                tempStream.close();
                if (dbg.canWrite()) {
                    read = tempStream.openRead();
                    dbg.writeStream(read);
                    read.close();
                    dbg.flush();
                }
                read = tempStream.openRead();
                JavacErrorParser parser = new JavacErrorParser();
                String errors = parser.parseErrors(read, lineMap);
                read.close();
                throw new JavaCompileException(errors);
            }
        }
        finally {
            tempStream.destroy();
        }
    }
}

