/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.jmx.AbstractMBeanServerFactory;
import com.caucho.jmx.MBeanServerImpl;
import com.caucho.util.CharBuffer;
import com.caucho.util.ClassLoaderLocal;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanServerFactoryImpl
extends AbstractMBeanServerFactory {
    private static ClassLoaderLocal _localMBeanServer = new ClassLoaderLocal("caucho.jmx.mbean-server");

    public MBeanServer createMBeanServer(String domain) {
        try {
            if (domain == null) {
                return MBeanServerFactoryImpl.addMBeanServer("resin:type=MBeanServer");
            }
            return MBeanServerFactoryImpl.addMBeanServer(domain + ":type=MBeanServer");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public ArrayList findMBeanServer(String agentId) {
        throw new UnsupportedOperationException();
    }

    public MBeanServer newMBeanServer(String domain) {
        try {
            if (domain == null) {
                return MBeanServerFactoryImpl.addMBeanServer("resin:type=MBeanServer");
            }
            return MBeanServerFactoryImpl.addMBeanServer(domain + ":type=MBeanServer");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void releaseMBeanServer(MBeanServer mbeanServer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBeanServerImpl getServer() {
        ClassLoaderLocal classLoaderLocal = _localMBeanServer;
        synchronized (classLoaderLocal) {
            MBeanServerImpl server = (MBeanServerImpl)_localMBeanServer.get();
            if (server == null) {
                throw new RuntimeException("missing MBeanServer");
            }
            return server;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanServerImpl addMBeanServer(String url) throws MalformedObjectNameException {
        ObjectName name = new ObjectName(url);
        ClassLoaderLocal classLoaderLocal = _localMBeanServer;
        synchronized (classLoaderLocal) {
            if (_localMBeanServer.getLevel() != null) {
                throw new IllegalStateException("Can't set mbean server twice in context");
            }
            MBeanServerImpl parent = (MBeanServerImpl)_localMBeanServer.get();
            MBeanServerImpl server = new MBeanServerImpl(parent, name);
            _localMBeanServer.set(server);
            return server;
        }
    }

    public static String cleanName(String url) {
        CharBuffer cb = CharBuffer.allocate();
        block3: for (int i = 0; i < url.length(); ++i) {
            char ch = url.charAt(i);
            switch (ch) {
                case ',': 
                case ':': {
                    cb.append('_');
                    continue block3;
                }
                default: {
                    cb.append(ch);
                }
            }
        }
        return cb.toString();
    }
}

