/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.jmx.AbstractMBean;
import com.caucho.jmx.DynamicMBeanImpl;
import com.caucho.jmx.MBeanImpl;
import com.caucho.jmx.MBeanSkeleton;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;

public class MBeanServerImpl
implements MBeanServer {
    private static WriteStream dbg = LogStream.open("/caucho.com/jmx");
    private String _defaultDomain;
    private ObjectName _name;
    private MBeanServerImpl _parent;
    private ClassLoader _loader;
    private Hashtable _mbeans = new Hashtable();
    private Hashtable _skeletons = new Hashtable();

    public MBeanServerImpl(MBeanServerImpl parent, ObjectName name) {
        this._parent = parent;
        this._name = name;
        this._loader = Thread.currentThread().getContextClassLoader();
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public Object instantiate(String className) throws ReflectionException, MBeanException {
        throw new UnsupportedOperationException();
    }

    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new UnsupportedOperationException();
    }

    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        throw new UnsupportedOperationException();
    }

    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new UnsupportedOperationException();
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        throw new UnsupportedOperationException();
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        throw new UnsupportedOperationException();
    }

    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        throw new UnsupportedOperationException();
    }

    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanException, NotCompliantMBeanException {
        throw new UnsupportedOperationException();
    }

    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (this._mbeans.get(name) != null) {
            throw new InstanceAlreadyExistsException(String.valueOf(name));
        }
        MBeanRegistration registration = null;
        if (object instanceof MBeanRegistration) {
            registration = (MBeanRegistration)object;
        }
        try {
            if (registration != null) {
                name = registration.preRegister(this, name);
            }
        }
        catch (Exception e) {
            throw new MBeanRegistrationException(e);
        }
        try {
            AbstractMBean mbean = null;
            if (object instanceof DynamicMBean) {
                mbean = new DynamicMBeanImpl(this, name, (DynamicMBean)object);
            } else {
                MBeanSkeleton skel = this.conditionalSkeleton(object.getClass());
                if (skel == null) {
                    throw new NotCompliantMBeanException(String.valueOf(name));
                }
                mbean = new MBeanImpl(this, name, object, skel);
            }
            this._mbeans.put(name, mbean);
            try {
                if (registration != null) {
                    registration.postRegister(new Boolean(true));
                }
            }
            catch (Exception e) {
                throw new MBeanRegistrationException(e);
            }
            return mbean.getObjectInstance();
        }
        catch (IntrospectionException e) {
            throw new MBeanRegistrationException(e);
        }
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        AbstractMBean oldBean = (AbstractMBean)this._mbeans.get(name);
        if (oldBean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        Object obj = oldBean.getObject();
        MBeanRegistration registration = null;
        if (obj instanceof MBeanRegistration) {
            registration = (MBeanRegistration)obj;
        }
        try {
            if (registration != null) {
                registration.preDeregister();
            }
            this._mbeans.remove(name);
            if (registration != null) {
                registration.postDeregister();
            }
        }
        catch (Exception e) {
            throw new MBeanRegistrationException(e);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        AbstractMBean mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        return mbean.getObjectInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set queryMBeans(ObjectName name, QueryExp query) {
        HashSet set = new HashSet();
        Hashtable hashtable = this._mbeans;
        synchronized (hashtable) {
            Iterator iter = this._mbeans.keySet().iterator();
            while (iter.hasNext()) {
                ObjectName testName = (ObjectName)iter.next();
                if (!this.isMatch(testName, name, query)) continue;
                set.add(this._mbeans.get(testName));
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set queryNames(ObjectName name, QueryExp query) {
        HashSet<ObjectName> set = new HashSet<ObjectName>();
        Hashtable hashtable = this._mbeans;
        synchronized (hashtable) {
            Iterator iter = this._mbeans.keySet().iterator();
            while (iter.hasNext()) {
                ObjectName testName = (ObjectName)iter.next();
                if (!this.isMatch(testName, name, query)) continue;
                set.add(testName);
            }
        }
        return set;
    }

    private boolean isMatch(ObjectName testName, ObjectName queryName, QueryExp query) {
        if (queryName == null) {
            return true;
        }
        if (!queryName.isPattern() && !testName.getDomain().equals(queryName.getDomain())) {
            return false;
        }
        if (queryName.isPropertyPattern()) {
            Hashtable<String, String> map = queryName.getKeyPropertyList();
            Iterator<String> iter = map.keySet().iterator();
            while (iter.hasNext()) {
                String key = iter.next();
                String value = map.get(key);
                if (value.equals(testName.getKeyProperty(key))) continue;
                return false;
            }
        } else {
            String queryProps;
            String testProps = testName.getCanonicalKeyPropertyListString();
            if (!testProps.equals(queryProps = queryName.getCanonicalKeyPropertyListString())) {
                return false;
            }
        }
        return true;
    }

    public boolean isRegistered(ObjectName name) {
        return this._mbeans.get(name) != null;
    }

    public Integer getMBeanCount() {
        return new Integer(this._mbeans.size());
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        AbstractMBean mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        return mbean.getAttribute(attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        AbstractMBean mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        return mbean.getAttributes(attributes);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        AbstractMBean mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        mbean.setAttribute(attribute.getName(), attribute.getValue());
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        AbstractMBean mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        return mbean.setAttributes(attributes);
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        AbstractMBean mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        return mbean.invoke(operationName, params, signature);
    }

    public String getDefaultDomain() {
        return this._defaultDomain;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        AbstractMBean mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        if (!(mbean.getObject() instanceof NotificationBroadcaster)) {
            return;
        }
        NotificationBroadcaster broadcaster = (NotificationBroadcaster)mbean.getObject();
        broadcaster.addNotificationListener(listener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listenerName, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        AbstractMBean mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        if (!(mbean.getObject() instanceof NotificationBroadcaster)) {
            return;
        }
        NotificationBroadcaster broadcaster = (NotificationBroadcaster)mbean.getObject();
        AbstractMBean listener = this.getMBean(listenerName);
        if (listener == null) {
            throw new InstanceNotFoundException(String.valueOf(listenerName));
        }
        Object obj = listener.getObject();
        if (obj instanceof NotificationListener) {
            broadcaster.addNotificationListener((NotificationListener)((Object)listener), filter, handback);
        }
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        AbstractMBean mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        if (!(mbean.getObject() instanceof NotificationBroadcaster)) {
            return;
        }
        NotificationBroadcaster broadcaster = (NotificationBroadcaster)mbean.getObject();
        broadcaster.removeNotificationListener(listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listenerName) throws InstanceNotFoundException, ListenerNotFoundException {
        AbstractMBean mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        if (!(mbean.getObject() instanceof NotificationBroadcaster)) {
            return;
        }
        NotificationBroadcaster broadcaster = (NotificationBroadcaster)mbean.getObject();
        AbstractMBean listener = this.getMBean(listenerName);
        if (listener == null) {
            throw new InstanceNotFoundException(String.valueOf(listenerName));
        }
        Object obj = listener.getObject();
        if (obj instanceof NotificationListener) {
            broadcaster.removeNotificationListener((NotificationListener)((Object)listener));
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        AbstractMBean mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        return mbean.getMBeanInfo();
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        AbstractMBean mbean = this.getMBean(name);
        if (mbean == null) {
            throw new InstanceNotFoundException(String.valueOf(name));
        }
        Object obj = mbean.getObject();
        Class<?> cl = obj.getClass();
        Class<?>[] ifs = cl.getInterfaces();
        for (int i = 0; i < ifs.length; ++i) {
            if (!ifs[i].getName().equals(className)) continue;
            return true;
        }
        while (cl != null) {
            if (cl.getName().equals(className)) {
                return true;
            }
            cl.getSuperclass();
        }
        return false;
    }

    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        throw new UnsupportedOperationException();
    }

    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        throw new UnsupportedOperationException();
    }

    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws OperationsException, ReflectionException, InstanceNotFoundException {
        throw new UnsupportedOperationException();
    }

    AbstractMBean getMBean(ObjectName name) {
        return (AbstractMBean)this._mbeans.get(name);
    }

    public ObjectInstance conditionalRegisterObject(Object object, String name) throws InstanceAlreadyExistsException, MBeanRegistrationException, MalformedObjectNameException {
        if (object == null) {
            return null;
        }
        ObjectName objectName = new ObjectName(name);
        if (this._mbeans.get(objectName) != null) {
            throw new InstanceAlreadyExistsException(String.valueOf(name));
        }
        AbstractMBean mbean = null;
        if (object instanceof DynamicMBean) {
            mbean = new DynamicMBeanImpl(this, objectName, (DynamicMBean)object);
        } else {
            MBeanSkeleton skel;
            try {
                skel = this.conditionalSkeleton(object.getClass());
            }
            catch (IntrospectionException e) {
                return null;
            }
            if (skel == null) {
                return null;
            }
            mbean = new MBeanImpl(this, objectName, object, skel);
        }
        this._mbeans.put(objectName, mbean);
        return mbean.getObjectInstance();
    }

    private MBeanSkeleton conditionalSkeleton(Class cl) throws IntrospectionException {
        Class<?> mbeanClass = null;
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().endsWith("MBean")) continue;
            if (mbeanClass == null) {
                mbeanClass = interfaces[i];
                continue;
            }
            if (!mbeanClass.isAssignableFrom(interfaces[i])) continue;
            mbeanClass = interfaces[i];
        }
        if (mbeanClass == null) {
            return null;
        }
        return this.getSkeleton(mbeanClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MBeanSkeleton getSkeleton(Class mbeanClass) throws IntrospectionException {
        Hashtable hashtable = this._skeletons;
        synchronized (hashtable) {
            MBeanSkeleton skeleton = (MBeanSkeleton)this._skeletons.get(mbeanClass);
            if (skeleton != null) {
                return skeleton;
            }
            skeleton = new MBeanSkeleton(mbeanClass);
            this._skeletons.put(mbeanClass, skeleton);
            return skeleton;
        }
    }

    public void close() {
        ArrayList list = new ArrayList(this._mbeans.keySet());
        for (int i = 0; i < list.size(); ++i) {
            ObjectName name = (ObjectName)list.get(i);
            try {
                this.unregisterMBean(name);
                continue;
            }
            catch (Throwable e) {
                dbg.log(e);
            }
        }
    }

    public String toString() {
        return "[MBeanServerImpl " + this._name + "]";
    }
}

