/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.ByteWriteStream;
import com.caucho.server.http.CauchoResponse;
import com.caucho.vfs.EnclosedWriteStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspWriter;

class QJspWriter
extends JspWriter
implements ByteWriteStream,
EnclosedWriteStream {
    private CauchoResponse response;
    private WriteStream os;

    QJspWriter() {
        super(0, false);
    }

    void init(ServletResponse response, int bufferSize, boolean autoFlush) throws IOException {
        if (bufferSize == -2) {
            bufferSize = Integer.MAX_VALUE;
        } else if (bufferSize == -1) {
            bufferSize = TempBuffer.SIZE;
        }
        this.bufferSize = bufferSize;
        this.autoFlush = autoFlush;
        this.response = (CauchoResponse)response;
        if (this.response.getBufferSize() < bufferSize) {
            this.response.setBufferSize(bufferSize);
        }
        this.os = this.response.getStream();
    }

    public final void write(byte[] buf, int off, int len) throws IOException {
        this.os.write(buf, off, len);
    }

    public final void write(char[] buf, int off, int len) throws IOException {
        this.os.print(buf, off, len);
    }

    public final void write(int ch) throws IOException {
        this.os.print((char)ch);
    }

    public final void write(char[] buf) throws IOException {
        this.os.print(buf);
    }

    public final void write(String s) throws IOException {
        this.os.print(s);
    }

    public final void write(String s, int off, int len) throws IOException {
        this.os.print(s, off, len);
    }

    public final void newLine() throws IOException {
        this.os.println();
    }

    public final void print(boolean b) throws IOException {
        this.os.print(b);
    }

    public final void print(char ch) throws IOException {
        this.os.print(ch);
    }

    public final void print(int i) throws IOException {
        this.os.print(i);
    }

    public final void print(long l) throws IOException {
        this.os.print(l);
    }

    public final void print(float f) throws IOException {
        this.os.print(f);
    }

    public final void print(double d) throws IOException {
        this.os.print(d);
    }

    public final void print(char[] s) throws IOException {
        this.os.print(s, 0, s.length);
    }

    public final void print(String s) throws IOException {
        this.os.print(s);
    }

    public final void print(Object o) throws IOException {
        this.os.print(o);
    }

    public final void println() throws IOException {
        this.os.println();
    }

    public final void println(boolean b) throws IOException {
        this.os.println(b);
    }

    public final void println(char ch) throws IOException {
        this.os.println(ch);
    }

    public final void println(int i) throws IOException {
        this.os.println(i);
    }

    public final void println(long l) throws IOException {
        this.os.println(l);
    }

    public final void println(float f) throws IOException {
        this.os.println(f);
    }

    public final void println(double d) throws IOException {
        this.os.println(d);
    }

    public final void println(char[] s) throws IOException {
        this.os.println(s, 0, s.length);
    }

    public final void println(String s) throws IOException {
        this.os.println(s);
    }

    public final void println(Object o) throws IOException {
        this.os.println(o);
    }

    public final void clear() throws IOException {
        this.response.resetBuffer();
    }

    public final void clearBuffer() throws IOException {
        try {
            if (this.response instanceof CauchoResponse) {
                this.response.clearBuffer();
            } else {
                this.response.resetBuffer();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void flush() throws IOException {
        this.response.flushBuffer();
    }

    WriteStream getStream() {
        return this.os;
    }

    public final void close() throws IOException {
    }

    void privateClose() throws IOException {
    }

    public final int getBufferSize() {
        if (this.bufferSize == 0) {
            return this.bufferSize;
        }
        return this.response.getBufferSize();
    }

    public final int getRemaining() {
        if (this.bufferSize == 0) {
            return 0;
        }
        if (this.response instanceof CauchoResponse) {
            return this.response.getRemaining();
        }
        return 0;
    }

    public final boolean isAutoFlush() {
        return this.autoFlush;
    }

    public WriteStream getWriteStream() {
        return this.os;
    }
}

