/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.JspLineException;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.Page;
import com.caucho.jsp.PageManager;
import com.caucho.server.http.CauchoApplication;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoRequestDispatcher;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.Http;
import com.caucho.server.http.ResponseAdapter;
import com.caucho.util.CauchoSystem;
import com.caucho.util.Registry;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.servlet.GenericServlet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class QServlet
extends GenericServlet {
    static final String COPYRIGHT = "Copyright(c) 1998-2002 Caucho Technology.  All rights reserved.";
    private static WriteStream dbg = LogStream.open("/caucho.com/jsp/servlet");
    protected CauchoApplication application;
    private PageManager manager;

    public void init(ServletConfig config) throws ServletException {
        ServletContext cxt;
        if (Registry.getRegistry() == null) {
            try {
                String resinConf = config.getInitParameter("resin.conf");
                if (resinConf == null) {
                    resinConf = CauchoSystem.getResinConfig();
                }
                Registry node = Registry.parse(Vfs.lookupNative(resinConf));
                Registry.setDefault(node);
                dbg = LogStream.open("/caucho.com/jsp/servlet");
            }
            catch (Exception e) {
                dbg.log(e);
            }
        }
        this.application = (cxt = config.getServletContext()) instanceof CauchoApplication ? (CauchoApplication)cxt : Http.createApplicationAdapter(cxt);
        try {
            super.init(config);
        }
        catch (Exception e) {
            dbg.log(e);
        }
    }

    protected void setManager(PageManager manager) {
        this.manager = manager;
    }

    protected PageManager getManager() {
        return this.manager;
    }

    public ServletContext getServletContext() {
        return this.application;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        CauchoResponse response;
        ResponseAdapter resAdapt;
        block12: {
            resAdapt = null;
            CauchoRequest request = req instanceof CauchoRequest ? (CauchoRequest)req : Http.createRequestAdapter((HttpServletRequest)req, this.application);
            if (res instanceof CauchoResponse) {
                response = (CauchoResponse)res;
            } else {
                resAdapt = ResponseAdapter.create((HttpServletResponse)res);
                response = resAdapt;
            }
            Page page = null;
            try {
                page = this.manager.getPage(request, response);
                if (page == null) {
                    response.sendError(404);
                    return;
                }
                page.subservice(request, response);
            }
            catch (JspParseException e) {
                if (e.getErrorPage() != null) {
                    this.forwardErrorPage(request, response, (Throwable)((Object)e), e.getErrorPage());
                }
                throw e;
            }
            catch (ClientDisconnectException e) {
                throw e;
            }
            catch (Throwable e) {
                if (page != null && page.getErrorPage() != null && this.forwardErrorPage(request, response, e, page.getErrorPage())) break block12;
                if (page != null && page._caucho_getLineMap() != null) {
                    dbg.log(e);
                    throw new JspLineException(e, page._caucho_getLineMap());
                }
                if (e instanceof IOException) {
                    dbg.log(e);
                    throw (IOException)e;
                }
                if (e instanceof ServletException) {
                    dbg.log(e);
                    throw (ServletException)e;
                }
                dbg.log(e);
                throw new ServletException(e);
            }
        }
        if (resAdapt != null) {
            response.close();
        }
    }

    public Page getPage(CauchoRequest request, CauchoResponse response) throws Exception {
        try {
            return this.manager.getPage(request, response);
        }
        catch (JspParseException e) {
            if (e.getErrorPage() != null) {
                this.forwardErrorPage(request, response, (Throwable)((Object)e), e.getErrorPage());
                return null;
            }
            throw e;
        }
    }

    public void killPage(CauchoRequest request, CauchoResponse response, Page page) {
        this.manager.killPage(request, response, page);
    }

    private boolean forwardErrorPage(CauchoRequest req, CauchoResponse res, Throwable e, String errorPage) throws ServletException, IOException {
        req.setAttribute("javax.servlet.jsp.jspException", e);
        req.setAttribute("javax.servlet.error.exception_type", e);
        req.setAttribute("javax.servlet.error.request_uri", req.getRequestURI());
        RequestDispatcher rd = req.getRequestDispatcher(errorPage);
        if (rd == null) {
            return false;
        }
        if (rd instanceof CauchoRequestDispatcher) {
            ((CauchoRequestDispatcher)rd).forward(req, res, "GET");
        } else {
            rd.forward((ServletRequest)req, (ServletResponse)res);
        }
        return true;
    }

    public void destroy() {
        this.manager.destroy();
        super.destroy();
    }
}

