/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.java.JavaCompiler;
import com.caucho.jsp.JspGenerator;
import com.caucho.jsp.Page;
import com.caucho.jsp.StaticPage;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

class StaticGenerator
extends JspGenerator {
    private Path cacheEntry;
    private String className;
    private ClassLoader parent;

    StaticGenerator() {
    }

    protected void init(ClassLoader parent, String className) {
        this.parent = parent;
        this.className = className;
        this.hasSession = this.parser.getStaticSession();
        super.init(parent, className + ".java");
    }

    boolean isCacheable() {
        return false;
    }

    WriteStream openWriteStream(Path path) throws IOException {
        JavaCompiler compiler = JavaCompiler.create(this.parent);
        Path dir = this.getClassDir();
        this.cacheEntry = dir.lookup(this.className.replace('.', '/') + ".static");
        this.cacheEntry.getParent().mkdirs();
        WriteStream os = this.cacheEntry.openWrite();
        if (this.charEncoding != null) {
            os.setEncoding(this.charEncoding);
        }
        return os;
    }

    protected void processPageDirective(String key, String value) throws Exception {
        if (!key.equals("import") && !key.equals("extends")) {
            super.processPageDirective(key, value);
        }
    }

    protected void generateText(String text) throws IOException {
        this.os.print(text);
    }

    protected Page compile(Path path, long lastModified) throws Exception {
        if (dbg.canWrite()) {
            dbg.log("static page: " + this.cacheEntry);
        }
        StaticPage page = new StaticPage(this.cacheEntry, this.hasSession);
        for (int i = 0; i < this.depends.size(); ++i) {
            page._caucho_addDepend(((Depend)this.depends.get(i)).getPath());
        }
        return page;
    }
}

