/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoElement;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TagInstance {
    static WriteStream dbg = LogStream.open("/caucho.com/jsp/generator");
    static L10N L = new L10N("com/caucho/jsp/messages");
    private static Object VARIES = new Object();
    private TagInstance top;
    private Element element;
    private TagInfo tagInfo;
    private int maxId;
    private TagInstance parent;
    private ArrayList children = new ArrayList();
    private int tagId = 0;
    private String tagName;
    private Class cl;
    private VariableInfo[] varInfo;
    private boolean isDead;
    private ArrayList attributeNames = new ArrayList();
    private ArrayList attributeValues = new ArrayList();

    TagInstance(TagInstance parent, TagInfo tagInfo, String tagName, Class cl) {
        this.parent = parent;
        this.tagInfo = tagInfo;
        if (parent == null) {
            this.top = this;
            this.tagId = -1;
        } else {
            this.top = parent.top;
            parent.children.add(this);
            this.tagId = this.top.maxId++;
        }
        this.tagName = tagName;
        this.cl = cl;
    }

    String getTagName() {
        return this.tagName;
    }

    int getId() {
        return this.tagId;
    }

    TagInstance getParent() {
        return this.parent;
    }

    Class getTagClass() {
        return this.cl;
    }

    public TagInfo getTagInfo() {
        return this.tagInfo;
    }

    void setVarInfo(VariableInfo[] varInfo) {
        this.varInfo = varInfo;
    }

    VariableInfo[] getVarInfo() {
        return this.varInfo;
    }

    int size() {
        return this.top.maxId;
    }

    Iterator iterator() {
        return this.children.iterator();
    }

    ArrayList getAttributeNames() {
        return this.attributeNames;
    }

    public void setDead(boolean isDead) {
        this.isDead = isDead;
    }

    boolean isDead() {
        return this.isDead;
    }

    TagInstance addTag(String tagName, TagInfo tagInfo, Class cl, CauchoElement elt) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        for (Node attr = elt.getFirstAttribute(); attr != null; attr = attr.getNextSibling()) {
            names.add(attr.getNodeName());
            String value = attr.getNodeValue();
            if (value.startsWith("<%=") || value.startsWith("%=")) {
                value = null;
            }
            values.add(value);
        }
        TagInstance child = this.findTag(tagName, elt);
        if (child == null) {
            child = new TagInstance(this, tagInfo, tagName, cl);
        }
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            String value = (String)values.get(i);
            child.addAttribute(name, value);
        }
        return child;
    }

    TagInstance addNewTag(String tagName, TagInfo tagInfo, Class cl, CauchoElement elt) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        for (Node attr = elt.getFirstAttribute(); attr != null; attr = attr.getNextSibling()) {
            names.add(attr.getNodeName());
            String value = attr.getNodeValue();
            if (value.startsWith("<%=") || value.startsWith("%=")) {
                value = null;
            }
            values.add(value);
        }
        TagInstance child = new TagInstance(this, tagInfo, tagName, cl);
        child.element = elt;
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            String value = (String)values.get(i);
            child.addAttribute(name, value);
        }
        return child;
    }

    void addAttribute(String name, Object value) {
        for (int i = 0; i < this.attributeNames.size(); ++i) {
            String attrName = (String)this.attributeNames.get(i);
            if (!attrName.equals(name)) continue;
            Object oldValue = this.attributeValues.get(i);
            if (value == null || oldValue == null || !value.equals(oldValue)) {
                this.attributeValues.set(i, null);
            }
            return;
        }
        this.attributeNames.add(name);
        this.attributeValues.add(value);
    }

    String getAttribute(String name) {
        for (int i = 0; i < this.attributeNames.size(); ++i) {
            if (!name.equals(this.attributeNames.get(i))) continue;
            return (String)this.attributeValues.get(i);
        }
        return null;
    }

    boolean canBeRequestTime(String name) {
        TagAttributeInfo[] attrs = this.tagInfo.getAttributes();
        if (attrs == null) {
            return true;
        }
        for (int i = 0; i < attrs.length; ++i) {
            if (!name.equals(attrs[i].getName())) continue;
            return attrs[i].canBeRequestTime();
        }
        return false;
    }

    TagInstance findTag(String tagName, CauchoElement elt) {
        ArrayList<String> names = new ArrayList<String>();
        for (Node attr = elt.getFirstAttribute(); attr != null; attr = attr.getNextSibling()) {
            names.add(attr.getNodeName());
        }
        for (int i = 0; i < this.children.size(); ++i) {
            TagInstance child = (TagInstance)this.children.get(i);
            if (!child.match(tagName, names)) continue;
            return child;
        }
        return null;
    }

    TagInstance findExactTag(String tagName, CauchoElement elt) {
        for (int i = 0; i < this.children.size(); ++i) {
            TagInstance child = (TagInstance)this.children.get(i);
            if (child.element != elt) continue;
            return child;
        }
        return null;
    }

    boolean match(String tagName, ArrayList names) {
        int i;
        if (!this.tagName.equals(tagName)) {
            return false;
        }
        if (this.attributeNames.size() != names.size()) {
            return false;
        }
        for (i = 0; i < this.attributeNames.size(); ++i) {
            String attrName = (String)this.attributeNames.get(i);
            if (names.indexOf(attrName) >= 0) continue;
            return false;
        }
        for (i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            if (this.attributeNames.indexOf(name) >= 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "TagInstance[id=" + this.tagId + ",name=" + this.tagName + "]";
    }
}

