/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoApplication;
import com.caucho.server.http.CauchoRequest;
import com.caucho.util.Alarm;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import com.caucho.xsl.AbstractStylesheetFactory;
import com.caucho.xsl.StyleScript;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.Xsl;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.transform.Templates;

class XslManager {
    private static WriteStream dbg = LogStream.open("/caucho.com/xsl/manager");
    static L10N L = new L10N("com/caucho/jsp/messages");
    private Application application;
    private Path workPath;
    private LruCache xslCache = new LruCache(256);
    private boolean strictXsl;
    private long lastUpdate;

    public XslManager(ServletContext context) {
        this.application = (Application)context;
        this.workPath = this.application.getWorkDir();
        if (this.workPath instanceof MemoryPath) {
            String workPathName = "qa/work/" + this.application.getHost() + this.application.getContextPath();
            this.workPath = CauchoSystem.getWorkPath().lookup(workPathName);
        }
    }

    public void setStrictXsl(boolean strictXsl) {
        this.strictXsl = strictXsl;
    }

    public String getServletInfo() {
        return "Resin XTP";
    }

    Templates get(String href, CauchoRequest req) throws Exception {
        String servletPath = req.getPageServletPath();
        CauchoApplication application = req.getCauchoApplication();
        Path appDir = application.getAppDir();
        Path pwd = appDir.lookupNative(application.getRealPath(servletPath));
        pwd = pwd.getParent();
        String fullStyleSheet = pwd.toString() + "/" + href;
        Templates stylesheet = null;
        long now = Alarm.getCurrentTime();
        stylesheet = (Templates)this.xslCache.get(fullStyleSheet);
        if (stylesheet instanceof StylesheetImpl && !((StylesheetImpl)stylesheet).isModified()) {
            return stylesheet;
        }
        this.lastUpdate = now;
        stylesheet = this.getStylesheet(req, href);
        if (stylesheet == null) {
            throw new ServletException(L.l("can't find stylesheet `{0}'", href));
        }
        this.xslCache.put(fullStyleSheet, stylesheet);
        return stylesheet;
    }

    Templates getStylesheet(CauchoRequest req, String href) throws Exception {
        int p;
        String servletPath = req.getPageServletPath();
        CauchoApplication application = req.getCauchoApplication();
        Path appDir = application.getAppDir();
        Path pwd = appDir.lookupNative(application.getRealPath(servletPath));
        pwd = pwd.getParent();
        MergePath stylePath = new MergePath();
        stylePath.addMergePath(pwd);
        stylePath.addMergePath(appDir);
        stylePath.addMergePath(appDir.lookup("WEB-INF/xsl"));
        stylePath.addMergePath(CauchoSystem.getResinHome().lookup("xsl"));
        stylePath.addClassPath(application.getClassLoader());
        MergePath scriptPath = new MergePath();
        scriptPath.addMergePath(pwd);
        scriptPath.addMergePath(appDir);
        scriptPath.addMergePath(appDir.lookup("WEB-INF/scripts"));
        scriptPath.addMergePath(CauchoSystem.getResinHome().lookup("scripts"));
        scriptPath.addClassPath(application.getClassLoader());
        AbstractStylesheetFactory factory = this.strictXsl ? new Xsl() : new StyleScript();
        factory.setStylePath(stylePath);
        factory.setScriptPath(scriptPath);
        factory.setClassLoader(application.getClassLoader());
        factory.setWorkPath(this.workPath);
        String className = "";
        if (pwd.lookup(href).canRead() && (p = req.getServletPath().lastIndexOf(47)) >= 0) {
            className = className + req.getServletPath().substring(0, p);
        }
        className = className + "/" + href;
        factory.setClassName(className);
        Templates templates = factory.newTemplates(href);
        return templates;
    }
}

