/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.java;

import com.caucho.jsp.JavaGenerator;
import com.caucho.jsp.TagInstance;
import com.caucho.jsp.java.Generator;
import javax.servlet.jsp.tagext.TagInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class JstlChooseGenerator
extends Generator {
    protected Element elt;

    public JstlChooseGenerator(JavaGenerator gen, Element elt, TagInstance tag) {
        super(gen);
        this.elt = elt;
        tag.setDead(true);
    }

    public boolean generate() throws Exception {
        boolean isFirst = true;
        boolean isLast = false;
        for (Node child = this.elt.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof Text) {
                String data = ((Text)child).getData();
                for (int i = 0; i < data.length(); ++i) {
                    if (Character.isWhitespace(data.charAt(i))) continue;
                    throw this.error(L.l("c:choose text must be whitespace only."));
                }
                continue;
            }
            if (!(child instanceof Element)) continue;
            Element childElt = (Element)child;
            if (isLast) {
                throw this.error(L.l("c:choose may not have elements after c:otherwise."));
            }
            TagInstance oldTag = this.gen.pushTag(childElt);
            this.gen.getCurrentTag().setDead(true);
            if (childElt.getNodeName().endsWith("when")) {
                if (isFirst) {
                    this.print("if (");
                } else {
                    this.print("else if (");
                }
                isFirst = false;
                String value = childElt.getAttribute("test");
                if (value.equals("")) {
                    throw this.error(L.l("c:when must have a 'test' attribute."));
                }
                TagInfo tagInfo = this.gen.getCurrentTag().getTagInfo();
                String uri = tagInfo.getTagLibrary().getURI();
                String urn = tagInfo.getTagLibrary().getReliableURN();
                if (urn == null) {
                    urn = uri;
                }
                if ("http://java.sun.com/jstl/core".equals(urn)) {
                    int index = this.gen.addExpr(value);
                    this.println("_caucho_expr_" + index + ".evalBoolean(pageContext)) {");
                } else {
                    this.println(this.gen.getRuntimeAttribute(value) + ") {");
                }
                this.pushDepth();
                this.gen.generateChildren(childElt.getFirstChild());
                this.popDepth();
                this.println("}");
            } else if (childElt.getNodeName().endsWith("otherwise")) {
                if (isFirst) {
                    throw this.error(L.l("c:choose must have at least one c:when before c:otherwise."));
                }
                isLast = true;
                this.println("else {");
                this.pushDepth();
                this.gen.generateChildren(childElt.getFirstChild());
                this.popDepth();
                this.println("}");
            } else {
                throw this.error(L.l("<{0}> is an unknown tag.  c:choose only allows c:when and c:otherwise.", childElt.getNodeName()));
            }
            this.gen.popTag(oldTag);
        }
        if (isFirst) {
            throw this.error(L.l("c:choose must have at least one c:when."));
        }
        return true;
    }

    protected Exception error(String message) {
        return this.gen.error(message);
    }
}

