/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.el.VariableResolver;
import com.caucho.jstl.ResultImpl;
import com.caucho.jstl.el.CoreSetTag;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.sql.SQLExecutionTag;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.sql.DataSource;

public class SqlQueryTag
extends BodyTagSupport
implements SQLExecutionTag {
    private static WriteStream dbg = LogStream.open("/caucho.com/jsp/jstl/sql");
    private static L10N L = new L10N(class$com$caucho$jstl$el$SqlQueryTag == null ? (class$com$caucho$jstl$el$SqlQueryTag = SqlQueryTag.class$("com.caucho.jstl.el.SqlQueryTag")) : class$com$caucho$jstl$el$SqlQueryTag);
    private Expr _sql;
    private String _var;
    private String _scope;
    private Expr _dataSource;
    private Expr _maxRows;
    private Expr _startRow;
    private ArrayList _params;
    static /* synthetic */ Class class$com$caucho$jstl$el$SqlQueryTag;

    public void setSql(Expr sql) {
        this._sql = sql;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public void setDataSource(Expr dataSource) {
        this._dataSource = dataSource;
    }

    public void setMaxRows(Expr maxRows) {
        this._maxRows = maxRows;
    }

    public void setStartRow(Expr startRow) {
        this._startRow = startRow;
    }

    public void addSQLParameter(Object value) {
        if (this._params == null) {
            this._params = new ArrayList();
        }
        this._params.add(value);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doEndTag() throws JspException {
        ResultSet rs;
        Statement stmt;
        Connection conn = null;
        boolean isTransaction = false;
        VariableResolver env = (VariableResolver)this.pageContext;
        String sql = this._sql != null ? this._sql.evalString(env) : this.bodyContent.getString();
        conn = (Connection)this.pageContext.getAttribute("caucho.jstl.sql.conn");
        if (conn != null) {
            isTransaction = true;
        }
        if (!isTransaction) {
            DataSource ds = this._dataSource != null ? SqlQueryTag.getDataSource(this.pageContext, this._dataSource.evalObject(env)) : SqlQueryTag.getDataSource(this.pageContext, null);
            conn = ds.getConnection();
        }
        Object value = null;
        ArrayList params = this._params;
        this._params = null;
        if (params == null) {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
        } else {
            PreparedStatement pstmt = conn.prepareStatement(sql);
            stmt = pstmt;
            for (int i = 0; i < params.size(); ++i) {
                Object paramValue = params.get(i);
                pstmt.setObject(i + 1, paramValue);
            }
            rs = pstmt.executeQuery();
        }
        if (this._startRow != null) {
            int startRow = (int)this._startRow.evalLong(env);
            while (startRow-- > 0 && rs.next()) {
            }
        }
        ResultImpl result = this._maxRows != null ? new ResultImpl(rs, (int)this._maxRows.evalLong(env)) : new ResultImpl(rs, -1);
        rs.close();
        stmt.close();
        CoreSetTag.setValue(this.pageContext, this._var, this._scope, result);
        Object var13_14 = null;
        if (isTransaction) return 6;
        if (conn == null) return 6;
        try {
            conn.close();
            return 6;
        }
        catch (Exception e) {
            dbg.log(e);
        }
        return 6;
        {
            catch (Exception e) {
                throw new JspException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (isTransaction || conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (Exception e) {
                dbg.log(e);
            }
            throw throwable;
        }
    }

    public static DataSource getDataSource(PageContext pageContext, Object ds) throws JspException {
        if (ds == null) {
            ds = Config.find(pageContext, "javax.servlet.jsp.jstl.sql.dataSource");
        }
        if (ds instanceof DataSource) {
            return (DataSource)ds;
        }
        if (!(ds instanceof String)) {
            throw new JspException(L.l("`{0}' is an invalid DataSource.", ds));
        }
        String key = (String)ds;
        try {
            String jndiName = key.startsWith("java:comp/") ? key : "java:comp/env/" + key;
            Object value = new InitialContext().lookup(jndiName);
            if (value instanceof DataSource) {
                return (DataSource)value;
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        throw new JspException(L.l("`{0}' is an invalid DataSource.", ds));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

