/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jsp.QPageContext;
import com.caucho.jstl.NameValueTag;
import com.caucho.jstl.el.CoreSetTag;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

public class UrlTag
extends TagSupport
implements NameValueTag {
    private static L10N L;
    private static String[] _shortEncoding;
    private Expr valueExpr;
    private Expr contextExpr;
    private String var;
    private String scope;
    private CharBuffer url;
    static /* synthetic */ Class class$com$caucho$jstl$el$ImportTag;

    public void setValue(Expr value) {
        this.valueExpr = value;
    }

    public void setContext(Expr context) {
        this.contextExpr = context;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void addParam(String name, String value) {
        String encoding = this.pageContext.getResponse().getCharacterEncoding();
        UrlTag.addParam(this.url, name, value, encoding);
    }

    public int doStartTag() throws JspException {
        QPageContext pageContext = (QPageContext)this.pageContext;
        String value = this.valueExpr.evalString(pageContext);
        String context = null;
        if (this.contextExpr != null) {
            context = this.contextExpr.evalString(pageContext);
        }
        this.url = UrlTag.normalizeURL(pageContext, value, context);
        return 1;
    }

    public int doEndTag() throws JspException {
        QPageContext pageContext = (QPageContext)this.pageContext;
        String value = UrlTag.encodeURL(pageContext, this.url);
        try {
            if (this.var == null) {
                JspWriter out = pageContext.getOut();
                out.print(value);
            } else {
                CoreSetTag.setValue(pageContext, this.var, this.scope, value);
            }
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    public static CharBuffer normalizeURL(PageContext pageContext, String url, String context) throws JspException {
        CharBuffer value = CharBuffer.allocate();
        if (value == null || value.equals("")) {
            throw new JspTagException(L.l("url may not be null"));
        }
        int slash = url.indexOf(47);
        int colon = url.indexOf(58);
        if (colon > 0 && colon < slash) {
            value.append(url);
        } else if (context != null) {
            value.append(context);
            value.append(url);
        } else if (slash == 0) {
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            value.append(request.getContextPath());
            value.append(url);
        } else {
            value.append(url);
        }
        return value;
    }

    public static CharBuffer addParam(CharBuffer url, String name, String value, String encoding) {
        if (url.indexOf('?') < 0) {
            url.append('?');
        } else {
            url.append('&');
        }
        UrlTag.addEncodedString(url, name, encoding);
        url.append('=');
        UrlTag.addEncodedString(url, value, encoding);
        return url;
    }

    public static CharBuffer addEncodedString(CharBuffer cb, String value, String encoding) {
        if (encoding == null || encoding.equalsIgnoreCase("iso-8859-1")) {
            return UrlTag.addEncodedLatin1(cb, value);
        }
        if (encoding.equalsIgnoreCase("utf8") || encoding.equalsIgnoreCase("utf-8")) {
            return UrlTag.addEncodedUTF8(cb, value);
        }
        try {
            cb.append(URLEncoder.encode(value, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return cb;
    }

    public static CharBuffer addEncodedLatin1(CharBuffer cb, String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch < '\u0080') {
                cb.append(_shortEncoding[ch]);
                continue;
            }
            cb.append('%');
            cb.append(UrlTag.hex(ch >> 4));
            cb.append(UrlTag.hex(ch & 0xF));
        }
        return cb;
    }

    public static CharBuffer addEncodedUTF8(CharBuffer cb, String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            int d2;
            int d1;
            char ch = value.charAt(i);
            if (ch < '\u0080') {
                cb.append(_shortEncoding[ch]);
                continue;
            }
            if (ch < '\u0800') {
                d1 = 192 + (ch >> 6 & 0x1F);
                d2 = 128 + (ch & 0x3F);
                cb.append('%');
                cb.append(UrlTag.hex(d1 >> 4));
                cb.append(UrlTag.hex(d1 & 0xF));
                cb.append('%');
                cb.append(UrlTag.hex(d2 >> 4));
                cb.append(UrlTag.hex(d2 & 0xF));
                continue;
            }
            d1 = 224 + (ch >> 12 & 0xF);
            d2 = 128 + (ch >> 6 & 0x3F);
            int d3 = 128 + (ch & 0x3F);
            cb.append('%');
            cb.append(UrlTag.hex(d1 >> 4));
            cb.append(UrlTag.hex(d1 & 0xF));
            cb.append('%');
            cb.append(UrlTag.hex(d2 >> 4));
            cb.append(UrlTag.hex(d2 & 0xF));
            cb.append('%');
            cb.append(UrlTag.hex(d3 >> 4));
            cb.append(UrlTag.hex(d3 & 0xF));
        }
        return cb;
    }

    public static String encodeURL(PageContext pageContext, CharBuffer url) {
        String value = url.toString();
        if (value.startsWith("/")) {
            return ((HttpServletResponse)pageContext.getResponse()).encodeURL(value);
        }
        return value;
    }

    private static char hex(int d) {
        if ((d &= 0xF) < 10) {
            return (char)(48 + d);
        }
        return (char)(65 + d - 10);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int i;
        L = new L10N(class$com$caucho$jstl$el$ImportTag == null ? (class$com$caucho$jstl$el$ImportTag = UrlTag.class$("com.caucho.jstl.el.ImportTag")) : class$com$caucho$jstl$el$ImportTag);
        _shortEncoding = new String[128];
        for (i = 0; i < _shortEncoding.length; ++i) {
            UrlTag._shortEncoding[i] = "%" + UrlTag.hex(i / 16) + UrlTag.hex(i);
        }
        for (i = 97; i <= 122; ++i) {
            UrlTag._shortEncoding[i] = String.valueOf((char)i);
        }
        for (i = 65; i <= 90; ++i) {
            UrlTag._shortEncoding[i] = String.valueOf((char)i);
        }
        for (i = 48; i <= 57; ++i) {
            UrlTag._shortEncoding[i] = String.valueOf((char)i);
        }
        UrlTag._shortEncoding[32] = "+";
        UrlTag._shortEncoding[45] = "-";
        UrlTag._shortEncoding[95] = "_";
        UrlTag._shortEncoding[46] = ".";
        UrlTag._shortEncoding[33] = "!";
        UrlTag._shortEncoding[126] = "~";
        UrlTag._shortEncoding[39] = "'";
    }
}

