/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.http.session.SessionManager;
import com.caucho.server.http.Application;
import com.caucho.server.http.Authenticator;
import com.caucho.server.http.CauchoApplication;
import com.caucho.server.http.CauchoRequest;
import com.caucho.util.LruCache;
import com.caucho.util.RegistryNode;
import java.security.Principal;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class AbstractAuthenticator
implements Authenticator {
    public static final String LOGIN_NAME = "com.caucho.servlet.login.name";
    protected ServletContext application;
    protected RegistryNode params;
    protected int principalCacheSize = 4096;
    protected LruCache principalCache;
    protected boolean useCookie;
    protected String cookieDomain;
    protected long cookieMaxAge = 31536000000L;

    public int getPrincipalCacheSize() {
        return this.principalCacheSize;
    }

    public void setPrincipalCacheSize(int size) {
        this.principalCacheSize = size;
    }

    public boolean getUseCookie() {
        return this.useCookie;
    }

    public void setUseCookie(boolean useCookie) {
        this.useCookie = useCookie;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public long getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public void setCookieMaxAge(long cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public void init(CauchoApplication app, RegistryNode params) throws ServletException {
        this.application = app;
        this.params = params;
        this.principalCache = new LruCache(this.principalCacheSize);
        this.init();
    }

    public void init() throws ServletException {
    }

    public ServletContext getServletContext() {
        return this.application;
    }

    public Principal authenticate(HttpServletRequest request) throws ServletException {
        HttpSession session = request.getSession(false);
        Principal user = null;
        if (session != null) {
            user = (Principal)session.getValue(LOGIN_NAME);
        }
        if (user != null) {
            return user;
        }
        String id = request.getRequestedSessionId();
        if (this.principalCache != null) {
            user = (Principal)this.principalCache.get(id);
        }
        if (user != null) {
            return user;
        }
        user = this.getCookiePrincipal(request);
        if (user != null && session != null) {
            session.putValue(LOGIN_NAME, (Object)user);
        }
        return user;
    }

    public Principal login(HttpServletRequest request, HttpServletResponse response, ServletContext application, String user, String password, String allowCookie) {
        if (allowCookie == null || allowCookie.equals("")) {
            return this.login(request, response, application, user, password, this.useCookie);
        }
        boolean cookie = allowCookie.equals("true") || allowCookie.equals("yes");
        return this.login(request, response, application, user, password, cookie);
    }

    public Principal login(HttpServletRequest request, HttpServletResponse response, ServletContext application, String user, String password, boolean allowCookie) {
        Principal principal = this.authenticate(request, user, password);
        if (principal != null) {
            HttpSession session = request.getSession();
            session.putValue(LOGIN_NAME, (Object)principal);
            if (this.principalCache != null) {
                this.principalCache.put(session.getId(), principal);
            }
        }
        if (allowCookie && principal != null) {
            this.addCookieAuth(request, response, application, principal);
        }
        return principal;
    }

    public boolean isUserInRole(HttpServletRequest request, Principal user, String role) {
        return this.isUserInRole(user, role);
    }

    public void logout(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.removeValue(LOGIN_NAME);
            if (this.principalCache != null) {
                this.principalCache.remove(session.getId());
            }
        }
    }

    private Principal getCookiePrincipal(HttpServletRequest request) {
        Cookie cookie = ((CauchoRequest)request).getCookie("resinauthid");
        if (cookie != null) {
            String value = cookie.getValue();
            return this.authenticateCookie(request, value);
        }
        return null;
    }

    private void addCookieAuth(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal user) {
        Application app = (Application)application;
        SessionManager sm = app.getSessionManager();
        CauchoRequest req = (CauchoRequest)request;
        String id = sm.createSessionId(0, request);
        if (this.updateCookie(request, user, id)) {
            Cookie cookie = new Cookie("resinauthid", id);
            cookie.setPath("/");
            cookie.setVersion(sm.getCookieVersion());
            if (this.cookieDomain != null) {
                cookie.setDomain(this.cookieDomain);
            } else if (sm.getCookieDomain() != null) {
                cookie.setDomain(sm.getCookieDomain());
            }
            if (this.cookieMaxAge > 0L) {
                cookie.setMaxAge((int)(this.cookieMaxAge / 1000L));
            }
            response.addCookie(cookie);
        }
    }

    public Principal authenticate(HttpServletRequest request, String user, String password) {
        return this.authenticate(user, password);
    }

    public Principal authenticateCookie(HttpServletRequest request, String cookieValue) {
        return this.authenticateCookie(cookieValue);
    }

    public boolean updateCookie(HttpServletRequest request, Principal user, String cookieValue) {
        return this.updateCookie(user, cookieValue);
    }

    public Principal authenticate(String user, String password) {
        return null;
    }

    public Principal authenticateCookie(String cookieValue) {
        return null;
    }

    public boolean updateCookie(Principal user, String cookieValue) {
        return true;
    }

    public boolean isUserInRole(Principal user, String role) {
        return true;
    }
}

