/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.Version;
import com.caucho.el.MapVariableResolver;
import com.caucho.http.admin.ApplicationAdmin;
import com.caucho.http.log.AbstractErrorLog;
import com.caucho.http.security.AbstractConstraint;
import com.caucho.http.security.AbstractLogin;
import com.caucho.http.security.BasicLogin;
import com.caucho.http.security.DigestLogin;
import com.caucho.http.security.ErrorFilter;
import com.caucho.http.security.FormLogin;
import com.caucho.http.security.IPConstraint;
import com.caucho.http.security.NullAuthenticator;
import com.caucho.http.security.RoleConstraint;
import com.caucho.http.security.SecurityFilter;
import com.caucho.http.security.ServletAuthenticator;
import com.caucho.http.security.TransportConstraint;
import com.caucho.http.session.SessionManager;
import com.caucho.jsp.QJspFactory;
import com.caucho.jsp.QServlet;
import com.caucho.regexp.IllegalRegexpException;
import com.caucho.server.http.BrowserConfig;
import com.caucho.server.http.CacheInvocation;
import com.caucho.server.http.CauchoApplication;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.ClassLoaderContext;
import com.caucho.server.http.ConfigException;
import com.caucho.server.http.Configuration;
import com.caucho.server.http.DummyRequest;
import com.caucho.server.http.DummyResponse;
import com.caucho.server.http.EarConfig;
import com.caucho.server.http.EarContext;
import com.caucho.server.http.ErrorServlet;
import com.caucho.server.http.FilterChainFilter;
import com.caucho.server.http.FilterChainPage;
import com.caucho.server.http.FilterChainServlet;
import com.caucho.server.http.FilterChainSingleThreadServlet;
import com.caucho.server.http.FilterMap;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.QFilterConfig;
import com.caucho.server.http.QNamedDispatcher;
import com.caucho.server.http.QRequestDispatcher;
import com.caucho.server.http.QServletConfig;
import com.caucho.server.http.ServletAlarm;
import com.caucho.server.http.ServletServer;
import com.caucho.server.http.Statistics;
import com.caucho.server.http.UrlMap;
import com.caucho.server.http.VirtualHost;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.Alarm;
import com.caucho.util.BeanUtil;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.ClassLoaderLocal;
import com.caucho.util.DynamicClassLoader;
import com.caucho.util.ExceptionWrapper;
import com.caucho.util.ExitListener;
import com.caucho.util.FlatCache;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.util.QDate;
import com.caucho.util.Registry;
import com.caucho.util.RegistryException;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Depend;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.RotateStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.beans.Beans;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import javax.transaction.UserTransaction;

public class Application
extends ClassLoaderContext
implements CauchoApplication {
    static WriteStream dbg = LogStream.open("/caucho.com/http/application");
    static WriteStream log = LogStream.openQuiet("/log/caucho.com/http");
    static L10N L = new L10N(class$com$caucho$server$http$Application == null ? (class$com$caucho$server$http$Application = Application.class$("com.caucho.server.http.Application")) : class$com$caucho$server$http$Application);
    static HashMap _defaultMimeTypes;
    private static IntMap _filterMapElements;
    private static IntMap _loginConfigElements;
    private static IntMap _sessionElements;
    private static IntMap _errorPageElements;
    private static Object NULL;
    private static ClassLoaderLocal _workDirLocal;
    private String _contextPath;
    private volatile boolean _isInitStarted;
    private volatile boolean _isInitComplete;
    private volatile boolean _isCloseStarted;
    private volatile boolean _isClosed;
    private volatile boolean _isModified;
    private ServletServer _server;
    private VirtualHost _host;
    private String _displayName;
    private Path _war;
    RegistryNode _origRegistry;
    RegistryNode _registry;
    private UrlMap _dispatchMap;
    private ArrayList _filterMap;
    private Hashtable _filters;
    private ArrayList _filterList;
    private QServletConfig _defaultServlet;
    private UrlMap _realPathMap;
    private UrlMap _cacheMap;
    private ArrayList _welcomeFileList;
    private Hashtable _servlets;
    private boolean _allowServletEL;
    private HashMap _mimeTypes;
    private HashMap _mimeFilters;
    private HashMap _taglibMap;
    private String _appDirName;
    private Path _appDir;
    private long _classUpdateInterval;
    private long _lastClassUpdate;
    private long _configUpdateInterval;
    private long _lastConfigUpdate;
    private long _startTime;
    private int _requestCount;
    private HashMap _initParams;
    private HashMap _attributes;
    private Hashtable _instances;
    private SessionManager _sessionManager;
    private String _charEncoding;
    private boolean _doMultipartForm;
    private long _formUploadMax;
    private LruCache _realPathCache;
    private LruCache _mimeTypeCache;
    private HashMap _errorPages;
    private UrlMap _securityMap;
    private String _loginAuthMethod;
    private String _loginRealmName;
    private String _formLoginPage;
    private String _formErrorPage;
    private boolean _loginInternalForward;
    private AbstractLogin _login;
    private ServletAuthenticator _authenticator;
    private String _createMode;
    private ArrayList _cronList;
    private ArrayList _applicationListeners;
    private ArrayList _applicationAttributeListeners;
    private ArrayList _listeners;
    private UrlMap _browserMap;
    private FlatCache _browserCache;
    private Path _tempDir;
    private Path _workDir;
    Statistics _stats;
    private QDate _calendar;
    private Throwable _configException;
    private int _unique;
    private boolean _isEarApplication;
    private boolean _isLazyInit;
    private Hashtable _resourceBundleMap;
    private boolean _isCaseInsensitive;
    private ApplicationAdmin _applicationAdmin;
    private AppVar _appVar;
    static /* synthetic */ Class class$com$caucho$server$http$Application;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$javax$servlet$Servlet;

    Application(ClassLoaderContext parent, VirtualHost host, String contextPath, RegistryNode registry, Path appDir, HashMap pathVariableMap, String createMode) throws Exception {
        block10: {
            super(parent);
            this._filters = new Hashtable();
            this._filterList = new ArrayList();
            this._welcomeFileList = new ArrayList();
            this._attributes = new HashMap();
            this._instances = new Hashtable();
            this._formUploadMax = -1L;
            this._errorPages = new HashMap();
            this._securityMap = new UrlMap();
            this._cronList = new ArrayList();
            this._calendar = new QDate();
            this._resourceBundleMap = new Hashtable();
            this._appVar = new AppVar();
            this._startTime = Alarm.getCurrentTime();
            if (pathVariableMap == null) {
                pathVariableMap = (HashMap)host.getPathVariableMap().clone();
            }
            this.setPathVariableMap(pathVariableMap);
            pathVariableMap.put("app", this._appVar);
            pathVariableMap.put("resin:pwd", appDir);
            this._createMode = createMode;
            this._host = host;
            this._server = this.getServer();
            if (contextPath == null || contextPath.equals("/")) {
                contextPath = "";
            }
            this._displayName = contextPath;
            this._contextPath = contextPath.intern();
            this._appDir = appDir;
            String appName = null;
            if (contextPath.equals("")) {
                appName = "ROOT";
            } else if (contextPath.indexOf(47, 1) < 0) {
                appName = contextPath.substring(1);
            }
            if (appName != null && host.getWarDir() != null) {
                this.setWar(host.getWarDir().lookup(appName + ".war"));
            }
            this.setRootPath(appDir);
            this.setWebInfPath(appDir);
            this.setDocPath(appDir);
            this._origRegistry = registry;
            this._applicationAdmin = new ApplicationAdmin(this);
            this._applicationAdmin.setServerAdmin(this._server.getServerAdmin());
            try {
                if (registry == null) {
                    registry = new RegistryNode();
                    registry.setRoot(this._server.getRegistry().getRoot());
                } else {
                    registry = (RegistryNode)registry.clone();
                }
                RegistryNode hostDefault = host.getApplicationDefaultRegistry();
                registry = this.mergeWebXml(registry, hostDefault);
                this.setRegistry(registry);
                pathVariableMap.put("app-dir", appDir);
                this.setAddWebInfClasses(true);
                this.configure(registry);
            }
            catch (Throwable e) {
                dbg.log(e);
                this.log(e.getMessage(), e);
                if (this._configException != null) break block10;
                this._configException = e;
            }
        }
    }

    public ApplicationAdmin getAdmin() {
        return this._applicationAdmin;
    }

    public String getJ2EEServerName() {
        return this.getServer().getServerId();
    }

    public long getStartTime() {
        return this._startTime;
    }

    public boolean isEarApplication() {
        return this._isEarApplication;
    }

    public void setEarApplication(boolean isEarApplication) {
        this._isEarApplication = isEarApplication;
    }

    public int getCacheMaxLength() {
        return 0x100000;
    }

    public boolean isLazyInit() {
        return this._isLazyInit;
    }

    public long getRandomLong() {
        return this.getServer().getRandomLong();
    }

    static RegistryNode selectDefault(RegistryNode registry) {
        return Application.selectDefault(registry, _appDefaultElements);
    }

    static RegistryNode selectHostDefault(RegistryNode registry) {
        return Application.selectDefault(registry, _hostDefaultElements);
    }

    private RegistryNode mergeWebXml(RegistryNode appNode, RegistryNode hostNode) throws Exception {
        boolean allowAdmin = hostNode.getELBoolean("allow-admin", false, this.getVirtualHost().getEnv());
        if (allowAdmin = appNode.getELBoolean("allow-admin", allowAdmin, this.getEnv())) {
            this.setAttribute("caucho.admin", this._applicationAdmin);
        }
        Path resinXml = this.getWebInfPath().lookup("WEB-INF/resin-web.xml");
        this.addDepend(resinXml);
        if (resinXml.canRead()) {
            RegistryNode webResin;
            if (dbg.canWrite()) {
                dbg.log("using: " + resinXml);
            }
            resinXml.setUserPath(resinXml.getNativePath());
            Registry root = Registry.parse(resinXml);
            RegistryNode top = root.getTop();
            if (appNode != null) {
                appNode = (RegistryNode)appNode.clone();
            }
            if ((webResin = top.lookup("web-app")) == null) {
                throw Application.error(top, L.l("resin-web.xml is missing top-level <web-app>"));
            }
            Application.verifyElements(webResin, _webAppElements);
            if (appNode == null) {
                appNode = webResin;
            } else {
                Application.mergeRegistry(appNode, webResin);
            }
        }
        String webXmlName = hostNode.getELString("web-xml", "web.xml", this.getVirtualHost().getEnv());
        webXmlName = appNode.getELString("web-xml", webXmlName, this.getEnv());
        Path webXml = this._appDir.lookup("WEB-INF").lookup(webXmlName);
        this.addDepend(webXml);
        if (webXml.canRead()) {
            RegistryNode webApp;
            if (dbg.canWrite()) {
                dbg.log("using: " + webXml);
            }
            webXml.setUserPath(webXml.getNativePath());
            Registry root = Registry.parse(webXml);
            RegistryNode top = root.getTop();
            if (appNode != null) {
                appNode = (RegistryNode)appNode.clone();
            }
            if ((webApp = top.lookup("web-app")) == null) {
                throw Application.error(top, L.l("web.xml is missing top-level web-app"));
            }
            if (appNode == null) {
                appNode = webApp;
            } else {
                Application.mergeRegistry(appNode, webApp);
            }
        }
        if (appNode == null) {
            appNode = hostNode;
        } else {
            Application.mergeRegistry(appNode, hostNode);
        }
        return appNode;
    }

    private String getDisplayName() {
        VirtualHost host = this.getVirtualHost();
        CharBuffer cb = CharBuffer.allocate();
        cb.append(host.getURL());
        if (this.getContextPath().equals("")) {
            cb.append("/");
        } else {
            cb.append(this.getContextPath());
        }
        return cb.close();
    }

    private void configure(RegistryNode registry) throws Exception {
        if (_dbgLife.canWrite()) {
            _dbgLife.log("configuring: " + this);
        }
        if (registry == null) {
            registry = new Registry().createNode("top", null);
        }
        this._registry = registry;
        this.setRegistry(registry);
        Iterator iter = registry.select("error-page");
        while (iter.hasNext()) {
            RegistryNode node = (RegistryNode)iter.next();
            String location = node.getELString("location", null, this.getEnv());
            String errorCode = node.getELString("error-code", null, this.getEnv());
            String exception = node.getELString("exception-type", null, this.getEnv());
            Application.verifyElements(node, _errorPageElements);
            if (location == null) {
                throw Application.error(node, L.l("<{0}> expects `{1}'", (Object)"error-page", "location"));
            }
            if (!location.startsWith("/")) {
                throw Application.error(node, L.l("error-page location `{0}' must be absolute.", location));
            }
            if (exception != null) {
                this._errorPages.put(exception, location);
                continue;
            }
            if (errorCode != null) {
                this._errorPages.put(errorCode, location);
                continue;
            }
            this._errorPages.put("0", location);
        }
        try {
            super.init();
        }
        catch (Throwable e) {
            dbg.log(e);
            this._configException = e;
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new ServletException(e);
        }
        this._initParams = new HashMap();
        this._instances = new Hashtable();
        this._isLazyInit = registry.getELBoolean("lazy-init", false, this.getEnv());
        this._allowServletEL = registry.getELBoolean("allow-servlet-el", false, this.getEnv());
        this._isCaseInsensitive = CauchoSystem.isCaseInsensitive();
        this._isCaseInsensitive = !registry.getELBoolean("case-sensitive", !this._isCaseInsensitive, this.getEnv());
        this._isCaseInsensitive = registry.getELBoolean("case-insensitive", this._isCaseInsensitive, this.getEnv());
        this._charEncoding = registry.getELString("character-encoding", null, this.getEnv());
        this.configureMultipartForm(registry);
        this._instances.clear();
        this._classUpdateInterval = this.getClassUpdateInterval();
        this._configUpdateInterval = this.getConfigUpdateInterval();
        DynamicClassLoader classLoader = this.getClassLoader();
        classLoader.setAttribute("caucho.application", this);
        classLoader.addPermission(this._appDir.lookup("-").getNativePath(), "read,write,delete");
        CauchoSystem.setContextClassLoader(this.getClassLoader());
        this.preServletConfigure(this._createMode);
        this._sessionManager = new SessionManager(this, registry);
        this._sessionManager.init();
        this.configureServlets();
        this.postServletConfigure(this._createMode);
        this._realPathCache = new LruCache(256);
        this._mimeTypeCache = new LruCache(256);
        this._cronList = new ArrayList();
        if (this._authenticator == null) {
            this._authenticator = new NullAuthenticator();
        }
        this._tempDir = this.getRootPath().lookup("WEB-INF/tmp");
        this._tempDir = Application.lookupPath(this._registry, "temp-dir", this._tempDir, this.getEnv());
        try {
            this._tempDir.mkdirs();
        }
        catch (IOException e) {
            // empty catch block
        }
        this._workDir = this.getRootPath().lookup("WEB-INF/work");
        this._workDir = Application.lookupPath(this._registry, "work-dir", this._workDir, this.getEnv());
        if (this._workDir instanceof MemoryPath) {
            String workPathName = "qa/work/" + this.getHost() + this.getContextPath();
            this._workDir = Vfs.lookup("/tmp/caucho").lookup(workPathName);
        }
        _workDirLocal.set(this._workDir);
        this._attributes.put("javax.servlet.context.tempdir", new File(this._tempDir.getNativePath()));
        this._stats = new Statistics(this.getServer());
        this._attributes.put("caucho.statistics", this._stats);
        this._attributes.put("caucho.class-loader", this.getClassLoader());
        this._attributes.put("caucho.class.path", this.getClassLoader().getClassPath());
        if (this.getServer().getServerId() != null) {
            this._attributes.put("caucho.server-id", this.getServer().getServerId());
        }
    }

    private void configureMultipartForm(RegistryNode node) throws Exception {
        if (!node.getELBoolean("multipart-form", false, this.getEnv())) {
            return;
        }
        RegistryNode multipart = node.lookup("multipart-form");
        if (multipart.getELBoolean("enable", true, this.getEnv())) {
            this._doMultipartForm = true;
        }
        this._formUploadMax = multipart.getELBytes("upload-max", this._formUploadMax, this.getEnv());
    }

    private void preServletConfigure(String createMode) throws Exception {
        if (this.getServer().isCompileOnly()) {
            return;
        }
        Context jndiContext = this.getJndiContext();
        if (jndiContext != null) {
            UserTransaction ut;
            Context env;
            Context comp = (Context)jndiContext.lookup("java:comp");
            if (comp.lookup("env") == null) {
                comp.createSubcontext("env");
            }
            if ((env = (Context)comp.lookup("env")).lookup("servlet") == null) {
                env.createSubcontext("servlet");
            }
            env.rebind("servlet/Application", (Object)this);
            if (comp.lookup("servlet") == null) {
                comp.createSubcontext("servlet");
            }
            comp.rebind("servlet/Application", (Object)this);
            TransactionManagerImpl tm = this.getTransactionManager();
            if (tm != null) {
                comp.rebind("TransactionManager", (Object)tm);
                try {
                    jndiContext.createSubcontext("java:pm");
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    jndiContext.rebind("TransactionManager", (Object)tm);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if ((ut = this._server.getUserTransaction()) != null) {
                comp.rebind("UserTransaction", (Object)ut);
            }
        }
        try {
            Class.forName("com.caucho.sql.DBPool");
        }
        catch (Exception e) {
            // empty catch block
        }
        Iterator iter = this._registry.iterator();
        while (iter.hasNext()) {
            RegistryNode node = (RegistryNode)iter.next();
            if (node.getName().equals("db-pool")) {
                throw Application.error(node, L.l("db-pool no longer supported, use resource-ref"));
            }
            if ("web-app".equals(createMode) && _webAppElements.get(node.getName()) < 0) {
                throw Application.error(node, L.l("unknown element `{0}' in {1}", (Object)node.getName(), createMode));
            }
            if ("host".equals(createMode) && _hostElements.get(node.getName()) < 0) {
                throw Application.error(node, L.l("unknown element `{0}' in {1}", (Object)node.getName(), createMode));
            }
            if (!"http-server".equals(createMode) || _serverElements.get(node.getName()) >= 0) continue;
            throw Application.error(node, L.l("unknown element `{0}' in {1}", (Object)node.getName(), createMode));
        }
        EarConfig earConfig = new EarConfig(this);
        if (!earConfig.configure() && this._host.hasEjb()) {
            this.initEjbJndi();
        }
    }

    String getEarName() {
        if (this.getParent() instanceof EarContext) {
            return this.getParent().getName();
        }
        return null;
    }

    private void initEjbJndi() throws ServletException, IOException, RegistryException {
        Context env = null;
        String earName = this.getEarName();
        if (earName == null) {
            return;
        }
        try {
            env = (Context)new InitialContext().lookup("java:comp/env");
            if (env == null) {
                return;
            }
        }
        catch (Exception e) {
            dbg.log(e);
        }
        Object ejb = null;
        try {
            ejb = env.lookup("ejb");
        }
        catch (Exception e) {
            dbg.log(e);
        }
        if (ejb == null) {
            try {
                Class<?> factoryCl = Class.forName("com.caucho.burlap.BurlapContextFactory");
                InitialContextFactory factory = (InitialContextFactory)factoryCl.newInstance();
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("java.naming.provider.url", this.getVirtualHost().getURL() + "/_" + earName + "/burlap");
                ejb = factory.getInitialContext(props);
                env.bind("ejb", ejb);
            }
            catch (Exception e) {
                dbg.log(e);
            }
        }
        Object cmp = null;
        try {
            cmp = env.lookup("cmp");
        }
        catch (Exception e) {
            dbg.log(e);
        }
        if (cmp == null) {
            try {
                Class<?> factoryCl = Class.forName("com.caucho.ejb.LocalContextFactory");
                InitialContextFactory factory = (InitialContextFactory)factoryCl.newInstance();
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("java.naming.provider.url", "/_" + earName);
                cmp = factory.getInitialContext(props);
                env.bind("cmp", cmp);
            }
            catch (Exception e) {
                dbg.log(e);
            }
        }
    }

    private void configureServlets() throws IOException, Exception {
        this._servlets = new Hashtable();
        Iterator iter = this._registry.iterator();
        while (iter.hasNext()) {
            String name;
            RegistryNode node = (RegistryNode)iter.next();
            if (node.getName().equals("servlet")) {
                name = node.getELString("servlet-name", null, this.getEnv());
                if (name == null) {
                    throw Application.error(node, L.l("<{0}> expects `{1}'", (Object)"servlet", "servlet-name"));
                }
                if (this._servlets.get(name) != null) {
                    throw Application.error(node, L.l("duplicate servlet `{0}'", name));
                }
                QServletConfig servlet = new QServletConfig(this, name, null, node);
                this._servlets.put(name, servlet);
                continue;
            }
            if (node.getName().equals("filter")) {
                name = node.getELString("filter-name", null, this.getEnv());
                if (name == null) {
                    throw Application.error(node, L.l("<{0}> expects `{1}'", (Object)"filter", "filter-name"));
                }
                if (this._filters.get(name) != null) {
                    throw Application.error(node, L.l("duplicate filter `{0}'", name));
                }
                QFilterConfig filter = new QFilterConfig(this, name, null, node);
                this._filters.put(name, filter);
                this._filterList.add(filter);
                continue;
            }
            if (node.getName().equals("listener")) {
                Object obj;
                String className = node.getELString("listener-class", null, this.getEnv());
                if (className == null) {
                    throw Application.error(node, L.l("<{0}> expects `{1}'", (Object)"listener", "listener-class"));
                }
                try {
                    Class cl = CauchoSystem.loadClass(className, false, this.getClassLoader());
                    obj = cl.newInstance();
                }
                catch (Exception e) {
                    throw Application.error(node, e);
                }
                boolean hasValue = false;
                if (obj instanceof ServletContextListener) {
                    hasValue = true;
                    if (this._applicationListeners == null) {
                        this._applicationListeners = new ArrayList();
                    }
                    this._applicationListeners.add(obj);
                }
                if (obj instanceof ServletContextAttributeListener) {
                    hasValue = true;
                    if (this._applicationAttributeListeners == null) {
                        this._applicationAttributeListeners = new ArrayList();
                    }
                    this._applicationAttributeListeners.add(obj);
                }
                if (obj instanceof HttpSessionListener) {
                    hasValue = true;
                    this._sessionManager.addListener((HttpSessionListener)obj);
                }
                if (obj instanceof HttpSessionActivationListener) {
                    hasValue = true;
                    this._sessionManager.addActivationListener((HttpSessionActivationListener)obj);
                }
                if (obj instanceof HttpSessionAttributeListener) {
                    hasValue = true;
                    this._sessionManager.addAttributeListener((HttpSessionAttributeListener)obj);
                }
                if (hasValue) continue;
                throw Application.error(node, L.l("`{0}' is an unknown listener-class", className));
            }
            if (!node.getName().equals("context-param")) continue;
            this.fillParam(node, this._initParams);
        }
    }

    private void postServletConfigure(String createMode) throws IOException, Exception {
        this._dispatchMap = new UrlMap(true);
        this._realPathMap = new UrlMap(true);
        this._filterMap = new ArrayList();
        this._cacheMap = null;
        this._mimeTypes = new HashMap();
        this._mimeFilters = new HashMap();
        this._taglibMap = new HashMap();
        try {
            QServletConfig file;
            QServletConfig jsp = this.createServlet("jsp", "com.caucho.jsp.JspServlet", null);
            if (JspFactory.getDefaultFactory() == null) {
                JspFactory.setDefaultFactory((JspFactory)QJspFactory.create());
            }
            if (this._registry.getELBoolean("strict-mapping", false, this.getEnv())) {
                this._dispatchMap.addStrictMap("*.jsp", null, "", "", jsp);
            } else {
                this._dispatchMap.addMap("*.jsp", jsp);
            }
            QServletConfig xtp = this.createServlet("xtp", "com.caucho.jsp.XtpServlet", null);
            if (this._registry.getELBoolean("strict-mapping", false, this.getEnv())) {
                this._dispatchMap.addStrictMap("*.xtp", null, "", "", xtp);
            } else {
                this._dispatchMap.addMap("*.xtp", xtp);
            }
            this._defaultServlet = file = this.createServlet("file", "com.caucho.server.http.FileServlet", null);
        }
        catch (IllegalRegexpException e) {
            // empty catch block
        }
        this._mimeFilters.put("x-application/xslt", "com.caucho.jsp.XslFilter");
        this._mimeFilters.put("x-application/stylescript", "com.caucho.jsp.StyleScriptFilter");
        this._mimeFilters.put("x-application/xsl", "com.caucho.jsp.StyleScriptFilter");
        Iterator iter = this._registry.iterator();
        while (iter.hasNext()) {
            RegistryNode node = (RegistryNode)iter.next();
            try {
                this.webAppEntryConfigure(node, this._createMode);
            }
            catch (IllegalRegexpException e) {
                throw Application.error(node, e.toString());
            }
        }
        this.initLoginConfig(this._registry);
        this.configWelcomeFileList(this._registry);
        if (this.getServer().isCompileOnly()) {
            return;
        }
        if (this._login == null) {
            BasicLogin basicLogin = new BasicLogin();
            basicLogin.setRealmName("resin");
            this._login = basicLogin;
        }
        Configuration hostConfig = this.getVirtualHost().getConfiguration();
        Configuration serverConfig = this.getServer().getConfiguration();
        this._authenticator = this.getConfiguration().getAuthenticator();
        if (this._authenticator == null) {
            this._authenticator = hostConfig.getAuthenticator();
        }
        if (this._authenticator == null) {
            this._authenticator = serverConfig.getAuthenticator();
        }
        this._login.setAuthenticator(this._authenticator);
        this._login.init();
        this.setAttribute("caucho.authenticator", this._authenticator);
        this.setAttribute("caucho.login", this._login);
        try {
            Context env = (Context)new InitialContext().lookup("java:comp/env");
            if (env != null && env.lookup("caucho") == null) {
                env.createSubcontext("caucho");
            }
            if (env != null && env.lookup("caucho") instanceof Context) {
                env.rebind("caucho/authenticator", (Object)this._authenticator);
                env.rebind("caucho/login", (Object)this._login);
            }
        }
        catch (NamingException e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void webAppEntryConfigure(RegistryNode node, String createMode) throws IOException, Exception {
        if (node.getName().equals("servlet-mapping")) {
            String pattern = node.getString("url-pattern", null);
            String regexp = node.getString("url-regexp", null);
            String pathInfo = node.getString("path-info", null);
            String servletName = node.getString("servlet-name", null);
            boolean isStrict = node.getParent().getBoolean("strict-mapping", false);
            isStrict = node.getBoolean("strict-mapping", isStrict);
            if (servletName == null) {
                throw Application.error(node, L.l("<{0}> expects `{1}'", (Object)"servlet-mapping", "servlet-name"));
            }
            if (servletName.equals("plugin_match")) {
                return;
            }
            if (servletName.equals("plugin_ignore")) {
                return;
            }
            RegistryNode parent = node.getParent();
            boolean caseInsensitive = this._isCaseInsensitive;
            caseInsensitive = !node.getELBoolean("case-sensitive", !caseInsensitive, this.getEnv());
            caseInsensitive = node.getELBoolean("case-insensitive", caseInsensitive, this.getEnv());
            String flags = caseInsensitive ? "i" : "";
            QServletConfig servlet = null;
            if (regexp == null || servletName.indexOf(36) < 0) {
                servlet = this.createServlet(servletName, null, node);
            }
            if (pattern != null && isStrict) {
                this._dispatchMap.addStrictMap(pattern, flags, pathInfo, servletName, servlet);
            } else if (pattern != null) {
                this._dispatchMap.addMap(pattern, flags, pathInfo, servletName, servlet);
            } else {
                if (regexp == null) throw Application.error(node, L.l("<{0}> expects `{1}' or `{2}'", "servlet-mapping", "url-pattern", "url-regexp"));
                this._dispatchMap.addRegexp(regexp, flags, pathInfo, servletName, servlet);
            }
            if (dbg.canWrite() && pattern != null) {
                dbg.log("servlet-mapping: " + pattern + " " + servletName);
                return;
            } else {
                if (!dbg.canWrite()) return;
                dbg.log("servlet-mapping: " + regexp + " " + servletName);
            }
            return;
        } else if (node.getName().equals("filter-mapping")) {
            FilterMap map = this.configureFilter(node);
            this._filterMap.add(map);
            return;
        } else if (node.getName().equals("path-mapping")) {
            String urlPattern = node.getString("url-pattern", null);
            String urlRegexp = node.getString("url-regexp", null);
            String realPath = node.getString("real-path", null);
            if (urlPattern == null && urlRegexp == null) {
                throw Application.error(node, L.l("<{0}> expects `{1}' or `{2}'", "path-mapping", "url-pattern", "url-regexp"));
            }
            if (realPath == null) {
                throw Application.error(node, L.l("<{0}> expects `{1}'", (Object)"path-mapping", "real-path"));
            }
            boolean caseSensitive = !CauchoSystem.isCaseInsensitive();
            RegistryNode parent = node.getParent();
            caseSensitive = parent.getELBoolean("case-sensitive", caseSensitive, this.getEnv());
            caseSensitive = node.getELBoolean("case-sensitive", caseSensitive, this.getEnv());
            String flags = caseSensitive ? "" : "i";
            try {
                if (urlPattern != null) {
                    this._realPathMap.addMap(urlPattern, flags, realPath, null, node);
                    return;
                }
                this._realPathMap.addRegexp(urlRegexp, flags, realPath, null, node);
                return;
            }
            catch (IllegalRegexpException e) {
                throw Application.error(node, e.toString());
            }
        } else if (node.getName().equals("mime-mapping")) {
            String extension = node.getELString("extension", null, this.getEnv());
            String mimeType = node.getELString("mime-type", null, this.getEnv());
            if (extension == null) {
                throw Application.error(node, L.l("<{0}> expects `{1}'", (Object)"mime-mapping", "extension"));
            }
            if (mimeType == null) {
                throw Application.error(node, L.l("<{0}> expects `{1}'", (Object)"mime-mapping", "mime-type"));
            }
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            this._mimeTypes.put(extension, mimeType);
            return;
        } else if (node.getName().equals("chain-mapping")) {
            String mimeType = node.getELString("mime-type", null, this.getEnv());
            if (mimeType == null) {
                throw Application.error(node, L.l("<{0}> expects `{1}'", (Object)"chain-mapping", "mime-type"));
            }
            String servletName = node.getELString("servlet-name", null, this.getEnv());
            if (servletName == null) {
                throw Application.error(node, L.l("<{0}> expects `{1}'", (Object)"chain-mapping", "servlet-name"));
            }
            if (dbg.canWrite()) {
                dbg.log("chain-mapping: " + mimeType + " " + servletName);
            }
            if (servletName.equals("none")) {
                this._mimeFilters.remove(mimeType);
                return;
            } else {
                this._mimeFilters.put(mimeType, servletName);
            }
            return;
        } else if (node.getName().equals("cache-mapping")) {
            String pattern = node.getELString("url-pattern", null, this.getEnv());
            String regexp = node.getString("url-regexp", null);
            long expires = node.getELPeriod("expires", -1L, this.getEnv());
            if (this._cacheMap == null) {
                this._cacheMap = new UrlMap(true);
            }
            if (pattern != null) {
                this._cacheMap.addMap(pattern, null, null, null, new Long(expires));
                return;
            } else {
                if (regexp == null) throw Application.error(node, L.l("<{0}> expects `{1}' or `{2}'", "cache-mapping", "url-pattern", "url-regexp"));
                this._cacheMap.addRegexp(pattern, null, null, null, new Long(expires));
            }
            return;
        } else {
            if (node.getName().equals("taglib")) {
                String uri = node.getELString("taglib-uri", null, this.getEnv());
                String location = node.getELString("taglib-location", null, this.getEnv());
                RegistryNode tag = node.lookup("tag");
                if (uri == null) {
                    throw Application.error(node, L.l("<{0}> expects `{1}'", (Object)"taglib", "taglib-uri"));
                }
                if (location != null || tag != null) return;
                throw Application.error(node, L.l("<{0}> expects `{1}' or `{2}'", "taglib", "taglib-location", "tag"));
            }
            if (node.getName().equals("security-constraint")) {
                this.initSecurityConstraint(node);
                return;
            } else if (node.getName().equals("secure")) {
                boolean isSecure = node.getBoolean();
                TransportConstraint constraint = new TransportConstraint();
                TransportConstraint[] constraints = new TransportConstraint[]{constraint};
                constraint.setTransportGuarantee("secure");
                this._securityMap.addRegexp("", null, null, null, constraints);
                return;
            } else if (node.getName().equals("browser-mapping")) {
                String regexp = node.getString("regexp", null);
                boolean force10 = node.getBoolean("force10", false);
                if (regexp == null) {
                    throw Application.error(node, L.l("<{0}> expects `{1}'", (Object)"browser-mapping", "regexp"));
                }
                this.addBrowserMapping(regexp, force10);
                return;
            } else {
                if (!"web-app".equals(createMode) || _webAppElements.get(node.getName()) >= 0) return;
                throw Application.error(node, L.l("unknown element `{0}' in {1}", (Object)node.getName(), createMode));
            }
        }
    }

    private void configWelcomeFileList(RegistryNode node) throws Exception {
        String files = node.getELString("welcome-file-list", "index.xtp, index.jsp, index.html", this.getEnv());
        RegistryNode list = node.lookup("welcome-file-list");
        if (list != null) {
            Iterator iter = list.select("welcome-file");
            while (iter.hasNext()) {
                RegistryNode subnode = (RegistryNode)iter.next();
                String file = subnode.getString();
                if (file == null) continue;
                files = files + ", " + file;
            }
        }
        int len = files.length();
        int i = 0;
        CharBuffer cb = new CharBuffer();
        while (i < len) {
            char ch = '\u0000';
            while (true) {
                block9: {
                    block8: {
                        if (i >= len) break block8;
                        char c = files.charAt(i);
                        ch = c;
                        if (c == ' ') break block9;
                    }
                    if (ch != ',' && ch != 9) break;
                }
                ++i;
            }
            if (i >= len) break;
            cb.clear();
            while (i < len) {
                char c = files.charAt(i);
                ch = c;
                if (c == ' ' || ch == 44 || ch == 9) break;
                cb.append(ch);
                ++i;
            }
            this._welcomeFileList.add(cb.toString());
        }
    }

    private RotateStream configLog(RegistryNode node) throws ServletException, IOException {
        String errorLogPath = node.getValue();
        Path errorPath = Application.lookupPath(node, null, null, this.getEnv());
        if ((errorPath = Application.lookupPath(node, "href", errorPath, this.getEnv())) == null) {
            return null;
        }
        try {
            long rolloverPeriod = node.getELPeriod("rollover-period", -1L, this.getEnv());
            int rolloverSize = node.getELInt("rollover-size", -1, this.getEnv());
            String timestamp = node.getELString("timestamp", null, this.getEnv());
            errorPath.getParent().mkdirs();
            RotateStream rotateStream = RotateStream.create(errorPath);
            if (rotateStream != null) {
                if (rolloverPeriod > 0L) {
                    rotateStream.setRolloverPeriod(rolloverPeriod);
                } else if (rolloverSize > 0) {
                    rotateStream.setRolloverSize(rolloverSize);
                }
            }
            if (rotateStream != null && timestamp != null) {
                rotateStream.setTimestamp(timestamp);
            }
            return rotateStream;
        }
        catch (RegistryException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private FilterMap configureFilter(RegistryNode node) throws Exception {
        String flags;
        FilterMap filterMap = new FilterMap();
        String filterName = node.getString("filter-name", null);
        String servletName = node.getELString("servlet-name", null, this.getEnv());
        if (filterName == null) {
            throw Application.error(node, L.l("{0} needs a filter-name attribute.  All filters need a filter-name.", node.getName()));
        }
        filterMap.setServletName(servletName);
        String urlPattern = node.getString("url-pattern", null);
        String regexpPattern = node.getString("url-regexp", null);
        boolean caseSensitive = !CauchoSystem.isWindows();
        RegistryNode parent = node.getParent();
        try {
            caseSensitive = parent.getELBoolean("case-sensitive", caseSensitive, this.getEnv());
            caseSensitive = node.getELBoolean("case-sensitive", caseSensitive, this.getEnv());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        String string = flags = caseSensitive ? "" : "i";
        if (urlPattern != null) {
            filterMap.setURLPattern(urlPattern, flags);
        } else if (regexpPattern != null) {
            try {
                filterMap.setRegexp(regexpPattern, flags);
            }
            catch (Exception e) {
                throw Application.error(node, L.l("illegal regexp `{0}'", regexpPattern));
            }
        }
        if (servletName == null && urlPattern == null && regexpPattern == null) {
            throw Application.error(node, L.l("{0} expects url-pattern or servlet-name", node.getName()));
        }
        QFilterConfig filterConfig = this.getFilterConfig(filterName);
        if (filterConfig == null) {
            filterConfig = new QFilterConfig(this, filterName, filterName, node);
            this.addFilterConfig(filterConfig);
        }
        filterMap.setData(filterConfig);
        this.validateNodeChildren(node, _filterMapElements);
        return filterMap;
    }

    private void addBrowserMapping(String regexp, boolean force10) throws IllegalRegexpException {
        if (this._browserMap == null) {
            this._browserMap = new UrlMap();
            this._browserCache = new FlatCache(1024);
        }
        BrowserConfig config = new BrowserConfig(force10);
        this._browserMap.addRegexp(regexp, "", null, null, config);
    }

    private void initSecurityConstraint(RegistryNode node) throws IOException, ServletException {
        ArrayList<Object> constraints = new ArrayList<Object>();
        String transport = node.getString("transport-guarantee", null);
        if (transport == null) {
            transport = node.getString("user-data-constraint/transport-guarantee", null);
        }
        if (transport == null && node.lookup("user-data-constraint") != null) {
            throw Application.error(node.lookup("user-data-constraint"), L.l("user-data-constraint requires a transport-guarantee"));
        }
        if (transport != null && !transport.equals("") && !transport.equalsIgnoreCase("NONE")) {
            TransportConstraint constraint = new TransportConstraint();
            constraint.setTransportGuarantee(transport);
            constraints.add(constraint);
        }
        RoleConstraint roleConstraint = null;
        Iterator iter = node.select("auth-constraint");
        while (iter.hasNext()) {
            RegistryNode subnode = (RegistryNode)iter.next();
            Iterator subiter = subnode.iterator();
            while (subiter.hasNext()) {
                RegistryNode constraintNode = (RegistryNode)subiter.next();
                if (!constraintNode.getName().equals("role-name")) continue;
                if (roleConstraint == null) {
                    roleConstraint = new RoleConstraint();
                }
                roleConstraint.addRoleName(constraintNode.getELString(null, null, this.getEnv()));
            }
        }
        String role = node.getELString("role-name", null, this.getEnv());
        if (role != null) {
            if (roleConstraint == null) {
                roleConstraint = new RoleConstraint();
            }
            roleConstraint.addRoleName(role);
        }
        if (roleConstraint != null) {
            constraints.add(roleConstraint);
        }
        IPConstraint constraint = null;
        iter = node.select("ip-constraint");
        while (iter.hasNext()) {
            RegistryNode ipNode = (RegistryNode)iter.next();
            if (constraint == null) {
                constraint = new IPConstraint();
                constraints.add(constraint);
            }
            constraint.addIPNetwork(ipNode.getValue());
        }
        iter = node.select("constraint");
        while (iter.hasNext()) {
            RegistryNode subnode = (RegistryNode)iter.next();
            String className = subnode.getString("class-name", null);
            if (className == null) {
                throw Application.error(subnode, L.l("Custom constraint requires a class-name."));
            }
            Object obj = BeanUtil.createBean(subnode, this.getEnv());
            if (!(obj instanceof AbstractConstraint)) {
                throw Application.error(subnode, L.l("Custom constraint `{0}' must extend AbstractConstraint.", className));
            }
            constraints.add(obj);
        }
        AbstractConstraint[] secList = new AbstractConstraint[constraints.size()];
        constraints.toArray(secList);
        this.configSecurityMapping(node, secList);
    }

    private void configSecurityMapping(RegistryNode node, AbstractConstraint[] constraints) throws ServletException {
        String method = node.getString("method", null);
        String urlPattern = node.getString("url-pattern", null);
        String urlRegexp = node.getString("url-regexp", null);
        try {
            HashMap<String, AbstractConstraint[]> methodMap = null;
            Object value = constraints;
            if (method != null) {
                methodMap = new HashMap<String, AbstractConstraint[]>();
                methodMap.put(method, constraints);
                value = methodMap;
            }
            if (urlPattern != null) {
                this._securityMap.addMap(urlPattern, null, null, null, value);
            } else if (urlRegexp != null) {
                this._securityMap.addRegexp(urlRegexp, null, null, null, value);
            } else if (method != null) {
                this._securityMap.addRegexp("", null, null, null, value);
            }
            Iterator iter = node.select("web-resource-collection");
            while (iter.hasNext()) {
                boolean hasMethod = false;
                RegistryNode subnode = (RegistryNode)iter.next();
                methodMap = new HashMap();
                value = constraints;
                Iterator subiter = subnode.select("method");
                while (subiter.hasNext()) {
                    RegistryNode methodNode = (RegistryNode)subiter.next();
                    methodMap.put(methodNode.getValue(), constraints);
                    value = methodMap;
                    hasMethod = true;
                }
                boolean hasItem = false;
                subiter = subnode.iterator();
                while (subiter.hasNext()) {
                    String pattern;
                    RegistryNode child = (RegistryNode)subiter.next();
                    if (child.getName().equals("url-pattern")) {
                        pattern = child.getValue();
                        this._securityMap.addMap(pattern, null, null, null, value);
                        hasItem = true;
                        continue;
                    }
                    if (!child.getName().equals("url-regexp")) continue;
                    pattern = child.getValue();
                    this._securityMap.addRegexp(pattern, null, null, null, value);
                    hasItem = true;
                }
                if (!hasMethod || hasItem) continue;
                this._securityMap.addRegexp("", null, null, null, value);
            }
        }
        catch (Exception e) {
            throw Application.error(node, e);
        }
        if (this._securityMap.size() == 0) {
            throw Application.error(node, L.l("<{0}> expects `{1}'", (Object)"security-constraint", "web-resource-collection"));
        }
    }

    private void initLoginConfig(RegistryNode registry) throws IOException, ServletException {
        if (this._login != null) {
            return;
        }
        RegistryNode node = null;
        for (ClassLoaderContext cxt = this; cxt != null && node == null; cxt = cxt.getParent()) {
            node = cxt.getRegistry().lookup("login-config");
        }
        if (node == null) {
            return;
        }
        this.validateNodeChildren(node, _loginConfigElements);
        this._loginAuthMethod = node.getString("auth-method", "Basic");
        this._loginRealmName = node.getString("realm-name", null);
        this._formLoginPage = node.getString("form-login-config/form-login-page", null);
        this._formErrorPage = node.getString("form-login-config/form-error-page", null);
        this._loginInternalForward = node.getBoolean("form-login-config/internal-forward", false);
        boolean formURIPriority = node.getBoolean("form-login-config/form-uri-priority", false);
        if (this._loginAuthMethod == null) {
            throw Application.error(node, L.l("<{0}> expects `{1}'", (Object)"login_config", "auth-method"));
        }
        this._loginAuthMethod = this._loginAuthMethod.toLowerCase();
        if (this._loginAuthMethod.equals("basic")) {
            BasicLogin basicLogin = new BasicLogin();
            basicLogin.setRealmName(this._loginRealmName);
            this._login = basicLogin;
        } else if (this._loginAuthMethod.equals("digest")) {
            DigestLogin digestLogin = new DigestLogin();
            digestLogin.setRealmName(this._loginRealmName);
            this._login = digestLogin;
        } else if (this._loginAuthMethod.equals("form")) {
            FormLogin formLogin = new FormLogin();
            this._login = formLogin;
            if (this._formLoginPage == null || this._formLoginPage.length() == 0) {
                throw Application.error(node, L.l("form login expects `{0}'", "form-login-page"));
            }
            if (this._formErrorPage == null || this._formErrorPage.length() == 0) {
                throw Application.error(node, L.l("form login expects `{0}'", "form-error-page"));
            }
            if (!(this._formLoginPage.startsWith("/") || this._formLoginPage.startsWith("http:") || this._formLoginPage.startsWith("https:"))) {
                throw Application.error(node, L.l("form-login-page `{0}' must start with '/'.  The form-login-page is relative to the web-app root.", this._formLoginPage));
            }
            if (!(this._formErrorPage.startsWith("/") || this._formErrorPage.startsWith("http:") || this._formErrorPage.startsWith("https:"))) {
                throw Application.error(node, L.l("form-error-page `{0}' must start with '/'.  The form-error-page is relative to the web-app root.", this._formErrorPage));
            }
            formLogin.setFormLoginPage(this._formLoginPage);
            formLogin.setFormErrorPage(this._formErrorPage);
            formLogin.setInternalForward(this._loginInternalForward);
            formLogin.setFormURIPriority(formURIPriority);
        } else if (node.getString("class-name", null) != null) {
            Object obj = BeanUtil.createBean(node, this.getEnv(), false);
            if (!(obj instanceof AbstractLogin)) {
                throw Application.error(node.lookup("class-name"), L.l("login class `{0}' must extend AbstractLogin", node.getString("class-name", null)));
            }
            this._login = (AbstractLogin)obj;
        } else {
            this._login = new BasicLogin();
        }
    }

    private void validateNodeChildren(RegistryNode node, IntMap children) throws ServletException {
        Iterator iter = node.iterator();
        while (iter.hasNext()) {
            RegistryNode child = (RegistryNode)iter.next();
            if (children.get(child.getName()) >= 0) continue;
            throw Application.error(child, L.l("unknown element `{0}' in <{1}>", (Object)child.getName(), node.getName()));
        }
    }

    private QServletConfig createServlet(String servletName) throws ServletException {
        return this.createServlet(servletName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QServletConfig createServlet(String servletName, String servletClass, RegistryNode node) throws ServletException {
        Hashtable servlets = this._servlets;
        if (servlets == null) {
            throw new ServletException(L.l("servlet engine is restarting."));
        }
        QServletConfig conf = (QServletConfig)this._servlets.get(servletName);
        if (conf != null) {
            return conf;
        }
        Hashtable hashtable = servlets;
        synchronized (hashtable) {
            conf = (QServletConfig)servlets.get(servletName);
            if (conf != null) {
                return conf;
            }
            try {
                conf = new QServletConfig(this, servletName, servletClass, node);
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            servlets.put(servletName, conf);
        }
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QServletConfig addServlet(String name, String className) throws ServletException {
        QServletConfig config;
        Hashtable servlets = this._servlets;
        if (servlets == null) {
            throw new ServletException(L.l("servlet engine is restarting."));
        }
        if (name == null) {
            throw new ServletException(L.l("empty servlet name."));
        }
        Hashtable hashtable = servlets;
        synchronized (hashtable) {
            config = (QServletConfig)servlets.get(name);
            if (config != null) {
                return config;
            }
            try {
                config = new QServletConfig(this, name, className, null);
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            servlets.put(name, config);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QFilterConfig createFilter(String filterName, String filterClass, RegistryNode node) throws ServletException {
        Hashtable filters = this._filters;
        if (filters == null) {
            throw new ServletException(L.l("servlet engine is restarting."));
        }
        QFilterConfig filter = (QFilterConfig)filters.get(filterName);
        if (filter != null) {
            return filter;
        }
        Hashtable hashtable = filters;
        synchronized (hashtable) {
            filter = (QFilterConfig)filters.get(filterName);
            if (filter != null) {
                return filter;
            }
            filter = new QFilterConfig(this, filterName, filterClass, node);
            filters.put(filterName, filter);
            this._filterList.add(filter);
        }
        return filter;
    }

    void fillParam(RegistryNode node, HashMap attributes) throws Exception {
        Iterator subIter = node.iterator();
        while (subIter.hasNext()) {
            String initValue;
            String initName;
            RegistryNode subnode = (RegistryNode)subIter.next();
            if (subnode.getName().equals("param-name")) {
                initName = subnode.getValue();
                initValue = this._allowServletEL ? node.getELString("param-value", null, this.getEnv()) : node.getString("param-value", null);
                String string = initValue = initValue == null ? "" : initValue;
                if (attributes.get(initName) != null) continue;
                attributes.put(initName, initValue);
                continue;
            }
            if (subnode.getName().equals("param-value") || subnode.getName().equals("description")) continue;
            initName = subnode.getName();
            initValue = this._allowServletEL ? subnode.getELString(null, null, this.getEnv()) : subnode.getString();
            if (attributes.get(initName) != null) continue;
            attributes.put(initName, initValue);
        }
    }

    void addDispatchMap(String urlPattern, QServletConfig servlet) throws IllegalRegexpException {
        this._dispatchMap.addMap(urlPattern, servlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        Application application = this;
        synchronized (application) {
            if (this._isInitComplete || this._isInitStarted || this._isClosed) {
                return;
            }
            this._isInitStarted = true;
        }
        if (log.canWrite()) {
            log.log("initializing application " + this.getDisplayName());
        }
        this._lastClassUpdate = Alarm.getCurrentTime();
        this._lastConfigUpdate = Alarm.getCurrentTime();
        Thread currentThread = Thread.currentThread();
        ClassLoader oldLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.getClassLoader());
        try {
            if (this._applicationListeners != null) {
                ServletContextEvent event = new ServletContextEvent((ServletContext)this);
                for (int i = 0; i < this._applicationListeners.size(); ++i) {
                    ServletContextListener listener = (ServletContextListener)this._applicationListeners.get(i);
                    listener.contextInitialized(event);
                }
            }
            this.initServlets();
        }
        catch (Throwable e) {
            this.log(String.valueOf(e), e);
            if (this._configException == null) {
                this._configException = e;
            }
        }
        finally {
            currentThread.setContextClassLoader(oldLoader);
            this._isInitComplete = true;
        }
    }

    private void initServlets() {
        if (this._configException != null) {
            return;
        }
        if (this.getServer().isCompileOnly()) {
            return;
        }
        ArrayList<QServletConfig> loadOnStartup = new ArrayList<QServletConfig>();
        Enumeration e = this._servlets.elements();
        while (e.hasMoreElements()) {
            int i;
            QServletConfig config = (QServletConfig)e.nextElement();
            if (loadOnStartup.contains(config) || config.loadOnStartup() == Integer.MIN_VALUE) continue;
            for (i = 0; i < loadOnStartup.size(); ++i) {
                QServletConfig config2 = (QServletConfig)loadOnStartup.get(i);
                if (config.loadOnStartup() >= config2.loadOnStartup()) continue;
                loadOnStartup.add(i, config);
                break;
            }
            if (i != loadOnStartup.size()) continue;
            loadOnStartup.add(config);
        }
        this._cronList.clear();
        for (int i = 0; i < loadOnStartup.size() && !this._isClosed; ++i) {
            QServletConfig config = (QServletConfig)loadOnStartup.get(i);
            try {
                String jspFile = config.getJspFile();
                if (jspFile != null) {
                    CharBuffer fullUri = CharBuffer.allocate();
                    fullUri.append(this.getContextPath());
                    fullUri.append(jspFile);
                    fullUri.append("?jsp_precompile");
                    Invocation invocation = null;
                    invocation = this._server.getLoginInvocation(this._host, fullUri.close());
                    QRequestDispatcher disp = new QRequestDispatcher(invocation, this);
                    DummyRequest req = new DummyRequest();
                    DummyResponse res = new DummyResponse();
                    disp.include((ServletRequest)req, (ServletResponse)res);
                    continue;
                }
                Servlet servlet = this.loadServlet(config, true);
                if (!config.isCron()) continue;
                this._cronList.add(new ServletAlarm(config, servlet));
                continue;
            }
            catch (ServletException exn) {
                config.setInitException(exn);
                this.log(L.l("init exception for `{0}'", config.getServletName()), exn);
                continue;
            }
            catch (Exception exn) {
                this._configException = exn;
                dbg.log(exn);
                this.log(L.l("can't load servlet `{0}'", config.getServletName()), exn);
            }
        }
        if (this._cronList.size() > 0) {
            dbg.log("cron-list: " + this._cronList);
        }
    }

    Throwable getConfigException() {
        return this._configException;
    }

    String getCreateMode() {
        return this._createMode;
    }

    public VirtualHost getVirtualHost() {
        return this._host;
    }

    public ServletServer getServer() {
        return this.getVirtualHost().getServer();
    }

    public String getServerInfo() {
        return "Resin/" + Version.VERSION;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 3;
    }

    public ServletContext getContext(String name) {
        try {
            Invocation invocation = this._server.getDispatchInvocation(this._host, name);
            return invocation._application;
        }
        catch (Exception e) {
            dbg.log(e);
            return null;
        }
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public String getRealPath(String uri) {
        if (uri == null) {
            return null;
        }
        String realPath = null;
        realPath = (String)this._realPathCache.get(uri);
        if (realPath == null) {
            Invocation invocation;
            try {
                CharBuffer cb = CharBuffer.allocate();
                if (this._contextPath.length() > 0) {
                    cb.append(this._contextPath);
                    cb.append('/');
                }
                cb.append(uri);
                invocation = this._server.getInvocation(this._host, cb.close());
            }
            catch (Exception e) {
                dbg.log(e);
                return null;
            }
            Application app = invocation.getApplication();
            Path path = app._appDir;
            String fullPath = invocation.getUri();
            String contextPath = invocation.getContextPath();
            String appPath = fullPath.substring(contextPath.length());
            CharBuffer realMap = new CharBuffer();
            ArrayList vars = new ArrayList();
            RegistryNode node = (RegistryNode)app._realPathMap.map(appPath, null, realMap, null, vars);
            HashMap map = new HashMap();
            map.put("regexp", vars);
            MapVariableResolver env = new MapVariableResolver(map, this.getEnv());
            if (node != null) {
                try {
                    realPath = Application.lookupPath(realMap.toString(), env).getNativePath();
                }
                catch (RegistryException e) {
                    dbg.log(e);
                }
            } else {
                realPath = path.lookup("./" + appPath).getNativePath();
            }
            this._realPathCache.put(uri, realPath);
        }
        if (dbg.canWrite()) {
            dbg.log("realPath: " + uri + " -> " + realPath);
        }
        return realPath;
    }

    public String getMimeType(String path) {
        if (path == null) {
            return null;
        }
        String mimeType = null;
        mimeType = (String)this._mimeTypeCache.get(path);
        if (mimeType == null) {
            Invocation invocation;
            try {
                CharBuffer cb = CharBuffer.allocate();
                cb.append(this._contextPath);
                cb.append('/');
                cb.append(path);
                invocation = this._server.getInvocation(this._host, cb.close());
            }
            catch (Exception e) {
                dbg.log(e);
                return null;
            }
            String normal = invocation.getPathInfo();
            if (normal == null) {
                normal = invocation.getServletPath();
            }
            if (normal == null) {
                return null;
            }
            Application app = invocation.getApplication();
            int p = normal.lastIndexOf(46);
            if (p < 0) {
                return null;
            }
            String ext = normal.substring(p);
            if (this._isCaseInsensitive) {
                ext = ext.toLowerCase();
            }
            if ((mimeType = (String)app._mimeTypes.get(ext)) == null) {
                mimeType = (String)_defaultMimeTypes.get(ext);
            }
            this._mimeTypeCache.put(path, mimeType);
        }
        return mimeType;
    }

    long getCacheTime(String uri) {
        if (this._cacheMap == null) {
            return CacheInvocation.DEFAULT_EXPIRES;
        }
        Long time = (Long)this._cacheMap.map(uri, null, null, null, null);
        if (time == null) {
            return CacheInvocation.DEFAULT_EXPIRES;
        }
        return time;
    }

    String getErrorPage(Throwable e) {
        return this.getErrorPage(e, class$java$lang$Throwable == null ? (class$java$lang$Throwable = Application.class$("java.lang.Throwable")) : class$java$lang$Throwable);
    }

    String getErrorPage(Throwable e, Class limit) {
        Class<?> cl;
        for (cl = e.getClass(); cl != null; cl = cl.getSuperclass()) {
            String location = (String)this._errorPages.get(cl.getName());
            if (location != null) {
                return location;
            }
            if (cl == limit) break;
        }
        for (cl = e.getClass(); cl != null; cl = cl.getSuperclass()) {
            String location;
            String name = cl.getName();
            int p = name.lastIndexOf(46);
            if (p > 0 && (location = (String)this._errorPages.get(name = name.substring(p + 1))) != null) {
                return location;
            }
            if (cl == limit) break;
        }
        return null;
    }

    String getErrorPage(int code) {
        String location = (String)this._errorPages.get(String.valueOf(code));
        if (location == null) {
            location = (String)this._errorPages.get("0");
        }
        return location;
    }

    String getLoginMethod() {
        return this._loginAuthMethod;
    }

    AbstractLogin getLogin() {
        return this._login;
    }

    String getLoginRealm() {
        return this._loginRealmName;
    }

    String getLoginForm() {
        return this._formLoginPage;
    }

    String getLoginError() {
        return this._formErrorPage;
    }

    boolean getLoginInternalForward() {
        return this._loginInternalForward;
    }

    public ServletAuthenticator getAuthenticator() {
        return this._authenticator;
    }

    public URL getResource(String name) {
        String realPath = this.getRealPath(name);
        try {
            Path path = this._appDir.lookupNative(realPath);
            if (path.canRead()) {
                return new URL(path.getURL());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.getClassLoader().getResource(name);
    }

    public InputStream getResourceAsStream(String uripath) {
        Path path = this.getDocPath().lookupNative(this.getRealPath(uripath));
        try {
            return path.openRead();
        }
        catch (IOException e) {
            dbg.log(e);
            return this.getClassLoader().getResourceAsStream(uripath);
        }
    }

    public Set getResourcePaths(String prefix) {
        if (!prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        Path path = this.getDocPath().lookup(this.getRealPath(prefix));
        HashSet<String> set = new HashSet<String>();
        String appPrefix = this.getContextPath() + prefix;
        ArrayList adminList = this.getVirtualHost().getApplicationAdminList();
        for (int i = 0; i < adminList.size(); ++i) {
            ApplicationAdmin admin = (ApplicationAdmin)adminList.get(i);
            String adminPath = admin.getContextPath();
            if (!adminPath.startsWith(appPrefix)) continue;
            int p = adminPath.indexOf(47, appPrefix.length() + 1);
            if (p > 0) {
                set.add(adminPath.substring(0, p + 1));
                continue;
            }
            set.add(adminPath + "/");
        }
        try {
            String[] list = path.list();
            for (int i = 0; i < list.length; ++i) {
                if (path.lookup(list[i]).isDirectory()) {
                    set.add(prefix + list[i] + '/');
                    continue;
                }
                set.add(prefix + list[i]);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return set;
    }

    public LocalizationContext getBundle(String name, String cacheKey, Enumeration locales) {
        Object cachedValue = this._resourceBundleMap.get(cacheKey);
        if (cachedValue instanceof LocalizationContext) {
            return (LocalizationContext)cachedValue;
        }
        if (cachedValue != null) {
            return null;
        }
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            LocalizationContext bundle = this.getBundle(name, locale);
            if (bundle == null) continue;
            this._resourceBundleMap.put(cacheKey, bundle);
            return bundle;
        }
        this._resourceBundleMap.put(cacheKey, new Object());
        return null;
    }

    public LocalizationContext getBundle(String name, Locale locale) {
        String cacheName = name + '_' + locale.getLanguage() + '_' + locale.getCountry() + '_' + locale.getVariant();
        LocalizationContext bundle = (LocalizationContext)this._resourceBundleMap.get(cacheName);
        if (bundle != null) {
            return bundle;
        }
        String fullName = cacheName;
        ResourceBundle resourceBundle = this.getBundle(fullName);
        if (resourceBundle != null) {
            bundle = new LocalizationContext(resourceBundle, locale);
            this._resourceBundleMap.put(cacheName, bundle);
            return bundle;
        }
        fullName = name + '_' + locale.getLanguage() + '_' + locale.getCountry();
        resourceBundle = this.getBundle(fullName);
        if (resourceBundle != null) {
            bundle = new LocalizationContext(resourceBundle, locale);
            this._resourceBundleMap.put(cacheName, bundle);
            return bundle;
        }
        fullName = name + '_' + locale.getLanguage();
        resourceBundle = this.getBundle(fullName);
        if (resourceBundle != null) {
            bundle = new LocalizationContext(resourceBundle, locale);
            this._resourceBundleMap.put(cacheName, bundle);
            return bundle;
        }
        return null;
    }

    public ResourceBundle getBaseBundle(String name) {
        return this.getBundle(name);
    }

    private ResourceBundle getBundle(String name) {
        try {
            ResourceBundle rb;
            Class<?> cl = Class.forName(name, false, this.getClassLoader());
            if (cl != null && (rb = (ResourceBundle)cl.newInstance()) != null) {
                return rb;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            InputStream is = this.getClassLoader().getResourceAsStream(name.replace('.', '/') + ".properties");
            if (is instanceof ReadStream) {
                Path path = ((ReadStream)is).getPath();
                this.addDepend(path);
            }
            PropertyResourceBundle bundle = new PropertyResourceBundle(is);
            is.close();
            return bundle;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String uriPath) {
        if (uriPath.length() == 0 || uriPath.charAt(0) != '/') {
            throw new IllegalArgumentException(L.l("path must be absolute: `{0}'", uriPath));
        }
        Invocation invocation = null;
        CharBuffer fullUri = CharBuffer.allocate();
        fullUri.append(this.getContextPath());
        fullUri.append(uriPath);
        try {
            invocation = this._server.getDispatchInvocation(this._host, fullUri.close());
        }
        catch (Exception e) {
            this.log(String.valueOf(e), e);
            dbg.log(e);
            return null;
        }
        return new QRequestDispatcher(invocation, this);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        int query = name.indexOf(63);
        String queryString = null;
        if (query >= 0) {
            queryString = name.substring(query + 1);
            name = name.substring(0, query);
        }
        try {
            QServletConfig config = this.addServlet(name, null);
            FilterChain chain = this.getFilterChainServlet(config, false);
            return new QNamedDispatcher(chain, queryString, this);
        }
        catch (ServletException e) {
            this.log(String.valueOf((Object)e), e);
            dbg.log(e);
            return null;
        }
    }

    public RequestDispatcher getLoginDispatcher(String uriPath) throws ServletException {
        if (uriPath.length() == 0 || uriPath.charAt(0) != '/') {
            throw new IllegalArgumentException(L.l("path must be absolute: `{0}'", uriPath));
        }
        Invocation invocation = null;
        CharBuffer fullUri = CharBuffer.allocate();
        fullUri.append(this.getContextPath());
        fullUri.append(uriPath);
        try {
            invocation = this._server.getLoginInvocation(this._host, fullUri.close());
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        QRequestDispatcher disp = new QRequestDispatcher(invocation, this);
        disp.setLogin(true);
        return disp;
    }

    QFilterConfig getFilterConfig(String name) {
        Hashtable filters = this._filters;
        if (filters == null || name == null) {
            return null;
        }
        return (QFilterConfig)filters.get(name);
    }

    void addFilterConfig(QFilterConfig config) {
        this._filterList.add(config);
    }

    void getServlet(Invocation invocation) throws ServletException {
        String tail = invocation._pathInfo;
        QServletConfig conf = null;
        if (tail != null && tail.endsWith("/j_security_check") && "form".equals(this.getLoginMethod())) {
            conf = this.addServlet("j_security_check", "com.caucho.http.security.FormLoginServlet");
            invocation.setServletConfig(conf);
            return;
        }
        conf = this.mapServlet(invocation);
        if (conf != null) {
            if (conf.getServletName().equals("invoker")) {
                conf = this.handleInvoker(invocation, conf);
            } else if (!invocation.isSubrequest() && conf.getServletName().equals("file") && invocation._uri.endsWith("/")) {
                conf = this.handleWelcomeFile(invocation, conf);
            }
        }
        invocation.setServletConfig(conf);
    }

    private QServletConfig handleInvoker(Invocation invocation, QServletConfig conf) throws ServletException {
        String tail = invocation._pathInfo != null ? invocation._pathInfo : invocation._servletPath;
        if (!tail.startsWith("/")) {
            throw new ServletException("expected '/' starting  sp:" + invocation._servletPath + " pi:" + invocation._pathInfo + " sn:invocation" + " config:" + conf);
        }
        int next = tail.indexOf(47, 1);
        String servletName = next < 0 ? tail.substring(1) : tail.substring(1, next);
        if (servletName.startsWith("com.caucho.server") || servletName.startsWith("com.caucho.http")) {
            throw new ServletException(L.l("servlet `{0}' forbidden from invoker. com.caucho.server.* classes are forbidden.", servletName));
        }
        if (servletName.equals("")) {
            throw new ServletException(L.l("invoker needs a servlet name at `{0}'.", invocation._uri));
        }
        conf = this.addServlet(servletName, null);
        if (invocation._pathInfo != null) {
            if (next < 0) {
                invocation._servletPath = invocation._servletPath + tail;
                invocation._pathInfo = null;
            } else if (next < tail.length()) {
                invocation._servletPath = invocation._servletPath + tail.substring(0, next);
                invocation._pathInfo = tail.substring(next);
            } else {
                invocation._servletPath = invocation._servletPath + tail;
                invocation._pathInfo = null;
            }
        }
        return conf;
    }

    private QServletConfig handleWelcomeFile(Invocation invocation, QServletConfig conf) throws ServletException {
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < this._welcomeFileList.size(); ++i) {
            cb.clear();
            if (invocation._servletPath != null) {
                cb.append(invocation._servletPath);
            }
            if (invocation._pathInfo != null) {
                cb.append(invocation._pathInfo);
            }
            if (cb.length() == 0) {
                cb.append('/');
            }
            cb.append(this._welcomeFileList.get(i));
            String path = cb.toString();
            String realPath = this.getRealPath(path);
            if (!this._appDir.lookup(realPath).canRead()) continue;
            invocation._rawUri = invocation._contextPath + path;
            invocation._uri = invocation._contextPath + path;
            invocation._servletPath = null;
            invocation._pathInfo = path;
            return this.mapServlet(invocation);
        }
        return conf;
    }

    private QServletConfig mapServlet(Invocation invocation) throws ServletException {
        QServletConfig conf = null;
        String tail = invocation._pathInfo;
        CharBuffer servletPath = CharBuffer.allocate();
        CharBuffer pathInfo = CharBuffer.allocate();
        CharBuffer servletNameBuffer = CharBuffer.allocate();
        if (this._dispatchMap != null) {
            conf = (QServletConfig)this._dispatchMap.map(tail, servletPath, pathInfo, servletNameBuffer, null);
        }
        if (conf == null && servletNameBuffer.length() > 0) {
            conf = this.createServlet(servletNameBuffer.toString());
            invocation._servletPath = servletPath.toString();
            invocation._pathInfo = pathInfo.length() > 0 ? pathInfo.toString() : null;
        } else if (conf == null) {
            conf = this._defaultServlet;
            invocation._servletPath = tail;
            invocation._pathInfo = null;
        } else if (pathInfo.length() > 0) {
            invocation._servletPath = servletPath.toString();
            invocation._pathInfo = pathInfo.toString();
        } else {
            invocation._servletPath = servletPath.toString();
            invocation._pathInfo = null;
        }
        servletPath.free();
        pathInfo.free();
        servletNameBuffer.free();
        return conf;
    }

    FilterChain buildFilterChain(Invocation invocation, QServletConfig config) throws ServletException {
        boolean isTop;
        boolean bl = isTop = !invocation.isSubrequest();
        if (this._configException != null && isTop) {
            throw new ServletException(this._configException);
        }
        String servletName = config.getServletName();
        FilterChain filterChain = this.getFilterChainServlet(config, isTop);
        return this.buildFilterChain(invocation, servletName, filterChain);
    }

    FilterChain getFilterChainServlet(QServletConfig config, boolean isTop) throws ServletException {
        try {
            if (config.getJspFile() != null) {
                if (isTop && config.getTopFilterChain() != null) {
                    return config.getTopFilterChain();
                }
                if (!isTop && config.getIncFilterChain() != null) {
                    return config.getIncFilterChain();
                }
                String jspFile = config.getJspFile();
                QServletConfig jsp = this.createServlet("jsp", "com.caucho.jsp.JspServlet", null);
                Servlet servlet = this.loadServlet(jsp, isTop);
                FilterChainPage filterChain = new FilterChainPage((QServlet)servlet, jspFile, config);
                filterChain.setApplication(this);
                if (isTop) {
                    config.setTopFilterChain(filterChain);
                } else {
                    config.setIncFilterChain(filterChain);
                }
                return filterChain;
            }
            Servlet servlet = config.loadServlet(isTop);
            if (servlet instanceof QServlet) {
                FilterChainPage filterChain = new FilterChainPage((QServlet)servlet);
                filterChain.setApplication(this);
                return filterChain;
            }
            FilterChainServlet filterChain = servlet instanceof SingleThreadModel ? new FilterChainSingleThreadServlet(config, servlet) : new FilterChainServlet(config, servlet);
            filterChain.setApplication(this);
            return filterChain;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FilterChain buildFilterChain(Invocation invocation, String servletName, FilterChain filterChain) throws ServletException {
        ArrayList filterMap = this._filterMap;
        if (filterMap == null) {
            return filterChain;
        }
        ArrayList arrayList = filterMap;
        synchronized (arrayList) {
            for (int i = filterMap.size() - 1; i >= 0; --i) {
                FilterMap map = (FilterMap)filterMap.get(i);
                if (!map.isMatch(invocation, servletName)) continue;
                QFilterConfig conf = (QFilterConfig)map.getData();
                Filter filter = conf.createFilter();
                filterChain = new FilterChainFilter(filterChain, filter);
            }
        }
        return this.getSecurityFilter(invocation, servletName, filterChain);
    }

    FilterChain getSecurityFilter(Invocation invocation, String servletName, FilterChain filterChain) throws ServletException {
        if (invocation == null) {
            return filterChain;
        }
        String uri = invocation.getServletPath();
        String pathInfo = invocation.getPathInfo();
        if (uri == null) {
            uri = pathInfo;
        } else if (pathInfo != null) {
            uri = uri + pathInfo;
        }
        String lower = uri.toLowerCase();
        if (lower.startsWith("/web-inf") || lower.startsWith("/meta-inf")) {
            QFilterConfig config = new QFilterConfig(this, "error", null, null);
            ErrorFilter filter = new ErrorFilter();
            filter.setErrorCode(403);
            filter.init(config);
            return new FilterChainFilter(filterChain, filter);
        }
        if (this._securityMap == null || this._securityMap.size() == 0) {
            return filterChain;
        }
        Object constraints = this._securityMap.map(uri, null, null, null, null);
        if (constraints != null) {
            SecurityFilter securityFilter = new SecurityFilter();
            if (constraints instanceof HashMap) {
                securityFilter.setMethodMap((HashMap)constraints);
            } else {
                securityFilter.setConstraints((AbstractConstraint[])constraints);
            }
            QFilterConfig config = new QFilterConfig(this, "security", null, null);
            securityFilter.init(config);
            return new FilterChainFilter(filterChain, securityFilter);
        }
        return filterChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isModified() {
        DynamicClassLoader classLoader = this.getClassLoader();
        long now = Alarm.getCurrentTime();
        if (!this._isInitComplete) {
            return false;
        }
        if (this._isModified) {
            return true;
        }
        if (this._configException != null) {
            log.log(this._displayName + " reload on error: " + this._configException);
            if (_dbgLife.canWrite()) {
                _dbgLife.log(this._displayName + " reload on error: " + this._configException);
            }
            this._isModified = true;
            return true;
        }
        if (classLoader == null || this._isClosed) {
            if (_dbgLife.canWrite()) {
                _dbgLife.log(this._displayName + " reload on close");
            }
            this._isModified = true;
            return true;
        }
        if (now < this._lastClassUpdate + this._classUpdateInterval && now < this._lastConfigUpdate + this._configUpdateInterval) {
            return false;
        }
        ClassLoaderContext parent = this.getParent();
        if (parent != null && parent.isModified()) {
            this._isModified = true;
            return true;
        }
        ArrayList arrayList = this._depends;
        synchronized (arrayList) {
            now = Alarm.getCurrentTime();
            if (this._isModified) {
                return true;
            }
            if (now < this._lastClassUpdate + this._classUpdateInterval && now < this._lastConfigUpdate + this._configUpdateInterval) {
                return false;
            }
            if (this._lastClassUpdate + this._classUpdateInterval <= now) {
                if (classLoader != null && classLoader.isModified()) {
                    if (_dbgLife.canWrite()) {
                        _dbgLife.log(this._displayName + " classes modified " + classLoader);
                    }
                    this._isModified = true;
                    return true;
                }
                this._lastClassUpdate = Alarm.getCurrentTime();
            }
            if (this._lastConfigUpdate + this._configUpdateInterval <= now) {
                if (this._registry != null && this._registry.isModified()) {
                    if (_dbgLife.canWrite()) {
                        _dbgLife.log(this._displayName + " registry modified");
                    }
                    this._isModified = true;
                    return true;
                }
                for (int i = 0; i < this._depends.size(); ++i) {
                    Depend depend = (Depend)this._depends.get(i);
                    if (!depend.isModified()) continue;
                    if (_dbgLife.canWrite()) {
                        _dbgLife.log(this._displayName + " depend modified: " + depend);
                    }
                    this._isModified = true;
                    return true;
                }
                this._lastConfigUpdate = Alarm.getCurrentTime();
            }
        }
        return false;
    }

    public void restart() {
        _dbgLife.log(this._displayName + " restart by admin");
        this._isModified = true;
    }

    void restartInt() {
        this._isModified = true;
    }

    Servlet loadServlet(QServletConfig config, boolean isTop) throws ServletException, IOException, ClassNotFoundException {
        if (this._configException != null && isTop) {
            return new ErrorServlet(this._configException);
        }
        return this.createServlet(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Servlet createServlet(QServletConfig config) throws ServletException, IOException, ClassNotFoundException {
        Servlet servlet;
        ClassLoader oldLoader;
        boolean isValid;
        String servletName;
        block17: {
            Servlet servlet2;
            block16: {
                servletName = config.getServletName();
                String className = config.getClassName();
                String jspFile = config.getJspFile();
                if (className == null && jspFile == null) {
                    throw new ServletException(L.l("Tried to create servlet `{0}' with no servlet-class.  Each servlet must either define servlet-class or jsp-file.", servletName));
                }
                if (!config.isAvailable(Alarm.getCurrentTime())) {
                    throw config.getInitException();
                }
                isValid = false;
                oldLoader = CauchoSystem.getContextClassLoader();
                try {
                    try {
                        CauchoSystem.setContextClassLoader(this.getClassLoader());
                        QServletConfig qServletConfig = config;
                        synchronized (qServletConfig) {
                            Servlet oldServlet;
                            if (servletName != null && this._instances != null && (oldServlet = (Servlet)this._instances.get(servletName)) != null) {
                                isValid = true;
                                servlet2 = oldServlet;
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 15] lbl18 : MonitorExitStatement: MONITOREXIT : var7_7
                                Object var13_13 = null;
                                if (!isValid && servletName != null && this._instances != null) {
                                    this._instances.remove(servletName);
                                }
                                break block16;
                            }
                            Servlet servlet3 = this.instantiateServlet(this.getClassLoader(), className);
                            RegistryNode initNode = config.getInitRegistry();
                            if (initNode != null) {
                                servlet3 = (Servlet)BeanUtil.configure(servlet3, initNode, this.getEnv(), false);
                            }
                            servlet3.init((ServletConfig)config);
                            if (servletName != null && this._instances != null) {
                                this._instances.put(servletName, servlet3);
                            }
                            isValid = true;
                            servlet = servlet3;
                        }
                        break block17;
                    }
                    catch (ServletException e) {
                        this.log(e.getMessage(), e);
                        config.setInitException(e);
                        throw e;
                    }
                    catch (Throwable e) {
                        this.log(e.getMessage(), e);
                        throw new ServletException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    if (!isValid && servletName != null && this._instances != null) {
                        this._instances.remove(servletName);
                    }
                    CauchoSystem.setContextClassLoader(oldLoader);
                    throw throwable;
                }
            }
            CauchoSystem.setContextClassLoader(oldLoader);
            return servlet2;
        }
        Object var13_14 = null;
        if (!isValid && servletName != null && this._instances != null) {
            this._instances.remove(servletName);
        }
        CauchoSystem.setContextClassLoader(oldLoader);
        return servlet;
    }

    void killServlet(Servlet servlet, QServletConfig config) throws ServletException {
        if (servlet == null) {
            return;
        }
        Servlet old = (Servlet)this._instances.remove(config.getServletName());
        servlet.destroy();
        if (old != servlet) {
            old.destroy();
        }
    }

    private Servlet instantiateServlet(ClassLoader loader, String className) throws ServletException {
        if (className == null) {
            throw new ServletException("Can't instiantiate null servlet.");
        }
        try {
            return (Servlet)Beans.instantiate(this.getClassLoader(), className);
        }
        catch (Exception e) {
            Exception exn = e;
            Class cl = null;
            try {
                cl = CauchoSystem.loadClass(className, false, this.getClassLoader());
            }
            catch (Exception e1) {
                String message = L.l("Class `{0}' was not found in classpath.\nClasses normally belong in {1}.", (Object)className, this.getContextPath() + "/WEB-INF/classes");
                this.log(e1.getMessage(), e1);
                throw new ServletException(message);
            }
            if (Modifier.isAbstract(cl.getModifiers())) {
                String message = L.l("Servlet `{0}' must not be abstract", cl.getName());
                this.log(message, exn);
                throw new ServletException(message);
            }
            if (!Modifier.isPublic(cl.getModifiers())) {
                String message = L.l("Servlet `{0}' must be public", cl.getName());
                this.log(message, exn);
                throw new ServletException(message);
            }
            if (!(class$javax$servlet$Servlet == null ? (class$javax$servlet$Servlet = Application.class$("javax.servlet.Servlet")) : class$javax$servlet$Servlet).isAssignableFrom(cl)) {
                String message = L.l("`{0}' must implement javax.servlet.Servlet.  All servlets must implement the Servlet interface.", cl.getName());
                this.log(message, exn);
                throw new ServletException(message);
            }
            Constructor constructor = null;
            try {
                constructor = cl.getConstructor(new Class[0]);
            }
            catch (Exception e2) {
                // empty catch block
            }
            if (constructor == null) {
                String message = L.l("`{0}' must have a public zero-arg constructor", cl.getName());
                this.log(message, exn);
                throw new ServletException(message);
            }
            this.log(exn.getMessage(), exn);
            throw new ServletException((Throwable)exn);
        }
    }

    public void log(String message) {
        try {
            AbstractErrorLog errorLog = this.getErrorLog();
            if (errorLog != null) {
                errorLog.log(message, null, null, this);
            } else if (dbg.canWrite()) {
                dbg.log(message);
            }
        }
        catch (Exception exn) {
            dbg.log(exn);
        }
    }

    public void log(Exception e, String msg) {
        this.log(msg, e);
    }

    public void log(String message, Throwable e) {
        this.log(message, e, null, null);
    }

    public void log(String message, Throwable e, HttpServletRequest request, HttpServletResponse response) {
        try {
            AbstractErrorLog errorLog = this.getErrorLog();
            if (errorLog != null) {
                errorLog.log(message, e, request, response, this);
            } else if (dbg.canWrite()) {
                this.log(dbg, message, e);
            }
        }
        catch (Exception exn) {
            dbg.log(exn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(WriteStream log, String message, Throwable e) throws IOException {
        if (log == null) {
            return;
        }
        Throwable t = e;
        while (t != null) {
            e = t;
            if (e instanceof ServletException) {
                t = ((ServletException)e).getRootCause();
                continue;
            }
            if (e instanceof ExceptionWrapper) {
                t = ((ExceptionWrapper)((Object)e)).getRootCause();
                continue;
            }
            t = null;
        }
        WriteStream writeStream = log;
        synchronized (writeStream) {
            long testDate = this.getVirtualHost().getTestDate();
            long date = testDate > 0L ? testDate : Alarm.getCurrentTime();
            log.print("[");
            this.timestamp(log, date);
            log.print("] ");
            log.println(message);
            if (e != null) {
                PrintWriter pw = log.getPrintWriter();
                e.printStackTrace(pw);
                pw.flush();
            }
            log.flush();
        }
    }

    private void timestamp(WriteStream stream, long date) throws IOException {
        this._calendar.calculate(date, true);
        stream.print(this._calendar.get(0));
        stream.print('/');
        long v = this._calendar.get(1) + 1L;
        stream.print(v / 10L);
        stream.print(v % 10L);
        stream.print('/');
        v = this._calendar.get(2) + 1L;
        stream.print(v / 10L);
        stream.print(v % 10L);
        stream.print(' ');
        v = this._calendar.get(5);
        stream.print(v / 10L);
        stream.print(v % 10L);
        stream.print(':');
        v = this._calendar.get(6);
        stream.print(v / 10L);
        stream.print(v % 10L);
        stream.print(':');
        v = this._calendar.get(7);
        stream.print(v / 10L);
        stream.print(v % 10L);
        v = this._calendar.get(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        HashMap hashMap = this._attributes;
        synchronized (hashMap) {
            return this._attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        HashMap hashMap = this._attributes;
        synchronized (hashMap) {
            return Collections.enumeration(this._attributes.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        Object oldValue;
        HashMap hashMap = this._attributes;
        synchronized (hashMap) {
            oldValue = value != null ? this._attributes.put(name, value) : this._attributes.remove(name);
        }
        if (this._applicationAttributeListeners != null) {
            ServletContextAttributeEvent event = oldValue != null ? new ServletContextAttributeEvent((ServletContext)this, name, oldValue) : new ServletContextAttributeEvent((ServletContext)this, name, value);
            for (int i = 0; i < this._applicationAttributeListeners.size(); ++i) {
                Object objListener = this._applicationAttributeListeners.get(i);
                ServletContextAttributeListener listener = (ServletContextAttributeListener)objListener;
                try {
                    if (oldValue != null) {
                        listener.attributeReplaced(event);
                        continue;
                    }
                    listener.attributeAdded(event);
                    continue;
                }
                catch (Throwable e) {
                    dbg.log(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        Object oldValue;
        HashMap hashMap = this._attributes;
        synchronized (hashMap) {
            oldValue = this._attributes.remove(name);
        }
        if (this._applicationAttributeListeners != null) {
            ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, name, oldValue);
            for (int i = 0; i < this._applicationAttributeListeners.size(); ++i) {
                Object objListener = this._applicationAttributeListeners.get(i);
                ServletContextAttributeListener listener = (ServletContextAttributeListener)objListener;
                try {
                    listener.attributeRemoved(event);
                    continue;
                }
                catch (Throwable e) {
                    dbg.log(e);
                }
            }
        }
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public Enumeration getServlets() {
        return new NullEnum();
    }

    public Enumeration getServletNames() {
        return new NullEnum();
    }

    public String getServletContextName() {
        return this._displayName;
    }

    public String getInitParameter(String name) {
        return (String)this._initParams.get(name);
    }

    public Enumeration getInitParameterNames() {
        return Collections.enumeration(this._initParams.keySet());
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public String getURL() {
        return this.getVirtualHost().getURL() + this._contextPath;
    }

    public Path getAppDir() {
        return this.getDocPath();
    }

    public String getAppDirName() {
        return this._appDirName;
    }

    public Path getAppInf() {
        Path warExpandDir = this.getVirtualHost().getWarExpandDir();
        if (warExpandDir == null) {
            return this.getDocPath().lookup("WEB-INF");
        }
        return warExpandDir.lookup("WEB-INF");
    }

    public Path getWar() {
        return this._war;
    }

    public void setWar(Path war) {
        this._war = war;
        this.addDepend(war);
    }

    public void addDepend(Path path) {
        Depend depend;
        if (path instanceof MergePath) {
            path = ((MergePath)path).getBestPath();
        }
        if (!this._depends.contains(depend = new Depend(path))) {
            this._depends.add(depend);
        }
    }

    public ArrayList getDepends() {
        return this._depends;
    }

    public RegistryNode getOriginalRegistry() {
        return this._origRegistry;
    }

    public String getHost() {
        return this.getVirtualHost().getName();
    }

    public String getChain(String mimeType) {
        return (String)this._mimeFilters.get(mimeType);
    }

    public Path lookupPath(String path) throws RegistryException {
        return Application.lookupPath(path, this.getEnv());
    }

    public void addListener(ExitListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        this._listeners.add(listener);
    }

    public void clearCache() {
        this._server.clearCache();
    }

    void timeout(long now) {
        int liveSessions = 0;
        CauchoSystem.setContextClassLoader(this.getClassLoader());
        if (this._sessionManager != null) {
            liveSessions = this._sessionManager.timeout(now);
        }
        if (this._stats != null) {
            this._stats.setLiveSessions(liveSessions);
        }
        CauchoSystem.setContextClassLoader(null);
    }

    void cron(long now) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClassLoader());
        for (int i = 0; this._cronList != null && i < this._cronList.size(); ++i) {
            ServletAlarm cron = (ServletAlarm)this._cronList.get(i);
            try {
                cron.timeout(now);
                continue;
            }
            catch (Throwable e) {
                this.log(String.valueOf(e), e);
            }
        }
        super.cron(now);
        if (this._sessionManager != null) {
            this._sessionManager.cron(now);
        }
        thread.setContextClassLoader(oldLoader);
    }

    Path getTempDir() {
        return this._tempDir;
    }

    public Path getWorkDir() {
        return this._workDir;
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    void close() {
        this.completeClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeClose() {
        Application application = this;
        synchronized (application) {
            if (this._isClosed) {
                return;
            }
            this._isModified = true;
            this._isClosed = true;
        }
        if (log.canWrite()) {
            log.log("closing application " + this.getDisplayName());
        }
        this.getServer().killCache();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            int i;
            Servlet servlet;
            thread.setContextClassLoader(this.getClassLoader());
            ArrayList<Servlet> servletList = new ArrayList<Servlet>();
            ArrayList listenerList = null;
            if (this._instances != null) {
                Hashtable hashtable = this._instances;
                synchronized (hashtable) {
                    Enumeration enumeration = this._instances.elements();
                    while (enumeration.hasMoreElements()) {
                        servlet = (Servlet)enumeration.nextElement();
                        servletList.add(servlet);
                    }
                    this._instances.clear();
                    this._instances = null;
                    listenerList = this._listeners;
                    this._listeners = null;
                }
            }
            ArrayList filterList = this._filterList;
            this._filterList = null;
            for (i = 0; i < servletList.size(); ++i) {
                servlet = (Servlet)servletList.get(i);
                try {
                    servlet.destroy();
                    continue;
                }
                catch (Throwable e) {
                    this.log(String.valueOf(e), e);
                }
            }
            for (i = 0; filterList != null && i < filterList.size(); ++i) {
                QFilterConfig filterConfig = (QFilterConfig)filterList.get(i);
                try {
                    if (filterConfig.getFilter() == null) continue;
                    filterConfig.getFilter().destroy();
                    continue;
                }
                catch (Throwable e) {
                    this.log(String.valueOf(e), e);
                }
            }
            if (this._applicationListeners != null) {
                ServletContextEvent event = new ServletContextEvent((ServletContext)this);
                for (int i2 = this._applicationListeners.size() - 1; i2 >= 0; --i2) {
                    ServletContextListener listener = (ServletContextListener)this._applicationListeners.get(i2);
                    try {
                        listener.contextDestroyed(event);
                        continue;
                    }
                    catch (Throwable e) {
                        dbg.log(e);
                    }
                }
            }
            for (int i3 = 0; listenerList != null && i3 < listenerList.size(); ++i3) {
                ExitListener listener = (ExitListener)listenerList.get(i3);
                try {
                    listener.handleExit(this);
                    continue;
                }
                catch (Exception e) {
                    dbg.log(e);
                }
            }
            this._listeners = null;
            if (this._sessionManager != null) {
                try {
                    this._sessionManager.close();
                }
                catch (Exception e) {
                    dbg.log(e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        super.close();
        this._servlets = null;
        this._filterMap = null;
        this._filters = null;
        this._dispatchMap = null;
        this._attributes = null;
        this._sessionManager = null;
        if (_dbgLife.canWrite()) {
            _dbgLife.log("close: " + this);
        }
    }

    String getCharEncoding() {
        return this._charEncoding;
    }

    boolean doMultipartForm() {
        return this._doMultipartForm;
    }

    long getFormUploadMax() {
        return this._formUploadMax;
    }

    boolean hasBrowserMap() {
        return this._browserMap != null;
    }

    BrowserConfig getBrowser(CharSegment cb) {
        if (this._browserMap == null) {
            return null;
        }
        Object value = this._browserCache.get(cb);
        if (value == NULL) {
            return null;
        }
        BrowserConfig config = (BrowserConfig)value;
        if (config != null) {
            return config;
        }
        config = (BrowserConfig)this._browserMap.map(cb.toString(), null, null, null, null);
        if (config == null) {
            this._browserCache.put(new CharBuffer(cb.toString()), NULL);
        } else {
            this._browserCache.put(new CharBuffer(cb.toString()), config);
        }
        return config;
    }

    String getMedia(CauchoRequest req) {
        return null;
    }

    public static void verifyElements(RegistryNode node, IntMap validElements) throws ServletException {
        Iterator iter = node.iterator();
        while (iter.hasNext()) {
            RegistryNode subNode = (RegistryNode)iter.next();
            if (validElements.get(subNode.getName()) >= 0) continue;
            throw Application.error(subNode, L.l("unexpected element `{0}' in {1}", (Object)subNode.getName(), node.getName()));
        }
    }

    public static ServletException error(RegistryNode node, String msg) {
        if (node != null) {
            return new ConfigException(node.getFilename() + ":" + node.getLine() + ": " + msg);
        }
        return new ConfigException(msg);
    }

    public static ServletException error(RegistryNode node, Throwable e) {
        if (e instanceof ServletException) {
            return (ServletException)e;
        }
        if (node != null) {
            return new ServletException(node.getFilename() + ":" + node.getLine() + ": " + String.valueOf(e));
        }
        return new ServletException(e);
    }

    public String toString() {
        String serverId = this.getServer().getServerId();
        if (serverId != null && !serverId.equals("")) {
            return "Application[url=" + this.getContextPath() + ",host=" + this.getVirtualHost().getURL() + ",server=" + serverId + "]";
        }
        return "Application[url=" + this.getContextPath() + ",host=" + this.getVirtualHost().getURL() + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        NULL = new Object();
        _workDirLocal = new ClassLoaderLocal("caucho.work-dir");
        _defaultMimeTypes = new HashMap();
        _defaultMimeTypes.put(".aif", "audio/x-aiff");
        _defaultMimeTypes.put(".aiff", "audio/x-aiff");
        _defaultMimeTypes.put(".aifc", "audio/x-aiff");
        _defaultMimeTypes.put(".ai", "application/postscript");
        _defaultMimeTypes.put(".au", "audio/basic");
        _defaultMimeTypes.put(".asc", "text/plain");
        _defaultMimeTypes.put(".asf", "video/x-ms-asf");
        _defaultMimeTypes.put(".asx", "video/x-ms-asf");
        _defaultMimeTypes.put(".avi", "video/x-msvideo");
        _defaultMimeTypes.put(".bin", "application/octet-stream");
        _defaultMimeTypes.put(".bcpio", "application/x-bcpio");
        _defaultMimeTypes.put(".bmp", "image/bmp");
        _defaultMimeTypes.put(".class", "application/octet-stream");
        _defaultMimeTypes.put(".cpt", "application/mac-compactpro");
        _defaultMimeTypes.put(".css", "text/css");
        _defaultMimeTypes.put(".cpio", "application/x-cpio");
        _defaultMimeTypes.put(".csh", "application/x-csh");
        _defaultMimeTypes.put(".cdf", "application/x-netcdf");
        _defaultMimeTypes.put(".dms", "application/octet-stream");
        _defaultMimeTypes.put(".doc", "application/msword");
        _defaultMimeTypes.put(".dcr", "application/x-director");
        _defaultMimeTypes.put(".dir", "application/x-director");
        _defaultMimeTypes.put(".dxr", "application/x-director");
        _defaultMimeTypes.put(".dvi", "application/x-dvi");
        _defaultMimeTypes.put(".exe", "application/octet-stream");
        _defaultMimeTypes.put(".eps", "application/postscript");
        _defaultMimeTypes.put(".etx", "text/x-setext");
        _defaultMimeTypes.put(".gtar", "application/x-gtar");
        _defaultMimeTypes.put(".gif", "image/gif");
        _defaultMimeTypes.put(".gz", "application/octet-stream");
        _defaultMimeTypes.put(".hdml", "text/x-hdml");
        _defaultMimeTypes.put(".hqx", "application/mac-binhex40");
        _defaultMimeTypes.put(".html", "text/html");
        _defaultMimeTypes.put(".htm", "text/html");
        _defaultMimeTypes.put(".hdf", "application/x-hdf");
        _defaultMimeTypes.put(".ief", "image/ief");
        _defaultMimeTypes.put(".ice", "x-conference/x-cooltalk");
        _defaultMimeTypes.put(".js", "application/x-javascript");
        _defaultMimeTypes.put(".jpeg", "image/jpeg");
        _defaultMimeTypes.put(".jpg", "image/jpeg");
        _defaultMimeTypes.put(".jpe", "image/jpeg");
        _defaultMimeTypes.put(".kar", "audio/midi");
        _defaultMimeTypes.put(".latex", "application/x-latex");
        _defaultMimeTypes.put(".lha", "application/octet-stream");
        _defaultMimeTypes.put(".lhz", "application/octet-stream");
        _defaultMimeTypes.put(".mid", "audio/midi");
        _defaultMimeTypes.put(".mpeg", "video/mpeg");
        _defaultMimeTypes.put(".mpg", "video/mpeg");
        _defaultMimeTypes.put(".mpe", "video/mpeg");
        _defaultMimeTypes.put(".mov", "video/quicktime");
        _defaultMimeTypes.put(".movie", "video/x-sgi-movie");
        _defaultMimeTypes.put(".mpga", "audio/mpeg");
        _defaultMimeTypes.put(".mp2", "audio/mpeg");
        _defaultMimeTypes.put(".mp3", "audio/mpeg");
        _defaultMimeTypes.put(".man", "application/x-troff-man");
        _defaultMimeTypes.put(".me", "application/x-troff-me");
        _defaultMimeTypes.put(".ms", "application/x-troff-ms");
        _defaultMimeTypes.put(".nc", "application/x-netcdf");
        _defaultMimeTypes.put(".oda", "application/oda");
        _defaultMimeTypes.put(".pdf", "application/pdf");
        _defaultMimeTypes.put(".ps", "application/postscript");
        _defaultMimeTypes.put(".ppt", "application/vnd.ms-powerpoint");
        _defaultMimeTypes.put(".png", "image/png");
        _defaultMimeTypes.put(".pgn", "application/x-chess-pgn");
        _defaultMimeTypes.put(".pnm", "image/x-portable-anymap");
        _defaultMimeTypes.put(".pbm", "image/x-portable-bitmap");
        _defaultMimeTypes.put(".pgm", "image/x-portable-graymap");
        _defaultMimeTypes.put(".ppm", "image/x-portable-pixmap");
        _defaultMimeTypes.put(".qt", "video/quicktime");
        _defaultMimeTypes.put(".rtf", "application/rtf");
        _defaultMimeTypes.put(".ram", "audio/x-pn-realaudio");
        _defaultMimeTypes.put(".rm", "audio/x-pn-realaudio");
        _defaultMimeTypes.put(".rpm", "audio/x-pn-realaudio-plugin");
        _defaultMimeTypes.put(".ra", "audio/x-realaudio");
        _defaultMimeTypes.put(".ras", "image/x-cmu-raster");
        _defaultMimeTypes.put(".rgb", "image/x-rgb");
        _defaultMimeTypes.put(".rtx", "text/richtext");
        _defaultMimeTypes.put(".rtf", "text/rtf");
        _defaultMimeTypes.put(".smi", "application/smil");
        _defaultMimeTypes.put(".smil", "application/smil");
        _defaultMimeTypes.put(".sml", "application/smil");
        _defaultMimeTypes.put(".skp", "application/x-koan");
        _defaultMimeTypes.put(".skd", "application/x-koan");
        _defaultMimeTypes.put(".skt", "application/x-koan");
        _defaultMimeTypes.put(".skm", "application/x-koan");
        _defaultMimeTypes.put(".src", "application/x-wais-source");
        _defaultMimeTypes.put(".sh", "application/x-sh");
        _defaultMimeTypes.put(".shar", "application/x-shar");
        _defaultMimeTypes.put(".swf", "application/x-shockwave-flash");
        _defaultMimeTypes.put(".sit", "application/x-stuffit");
        _defaultMimeTypes.put(".spl", "application/x-futuresplash");
        _defaultMimeTypes.put(".sv4cpio", "application/x-sv4cpio");
        _defaultMimeTypes.put(".sv4crc", "application/x-sv4crc");
        _defaultMimeTypes.put(".snd", "audio/basic");
        _defaultMimeTypes.put(".sgml", "text/sgml");
        _defaultMimeTypes.put(".sgm", "text/sgml");
        _defaultMimeTypes.put(".tgz", "application/octet-stream");
        _defaultMimeTypes.put(".tar", "application/x-tar");
        _defaultMimeTypes.put(".tcl", "application/x-tcl");
        _defaultMimeTypes.put(".tex", "application/x-tex");
        _defaultMimeTypes.put(".texinfo", "application/x-texinfo");
        _defaultMimeTypes.put(".texi", "application/x-texinfo");
        _defaultMimeTypes.put(".t", "application/x-troff");
        _defaultMimeTypes.put(".tr", "application/x-troff");
        _defaultMimeTypes.put(".roff", "application/x-troff");
        _defaultMimeTypes.put(".tiff", "image/tiff");
        _defaultMimeTypes.put(".tif", "image/tiff");
        _defaultMimeTypes.put(".txt", "text/plain");
        _defaultMimeTypes.put(".tsv", "text/tab-separated-values");
        _defaultMimeTypes.put(".ustar", "application/x-ustar");
        _defaultMimeTypes.put(".vcd", "application/x-cdlink");
        _defaultMimeTypes.put(".vrml", "model/vrml");
        _defaultMimeTypes.put(".wav", "audio/x-wav");
        _defaultMimeTypes.put(".wax", "audio/x-ms-wax");
        _defaultMimeTypes.put(".wrl", "model/vrml");
        _defaultMimeTypes.put(".wma", "audio/x-ms-wma");
        _defaultMimeTypes.put(".wml", "text/vnd.wap.wml");
        _defaultMimeTypes.put(".wmls", "text/vnd.wap.wmlscript");
        _defaultMimeTypes.put(".wmlc", "application/vnd.wap.wmlc");
        _defaultMimeTypes.put(".wmlsc", "application/vnd.wap.wmlscript");
        _defaultMimeTypes.put(".wbmp", "image/vnd.wap.wbmp");
        _defaultMimeTypes.put(".xls", "application/vnd.ms-excel");
        _defaultMimeTypes.put(".xbm", "image/x-xbitmap");
        _defaultMimeTypes.put(".xpm", "image/x-xpixmax");
        _defaultMimeTypes.put(".xwd", "image/x-xwindowdump");
        _defaultMimeTypes.put(".xml", "text/xml");
        _defaultMimeTypes.put(".zip", "application/zip");
        _defaultMimeTypes.put(".z", "application/octet-stream");
        _loginConfigElements = new IntMap();
        _loginConfigElements.put("auth-method", 1);
        _loginConfigElements.put("realm-name", 1);
        _loginConfigElements.put("form-login-config", 1);
        _loginConfigElements.put("authenticator", 1);
        _loginConfigElements.put("class-name", 1);
        _loginConfigElements.put("init-param", 1);
        _errorPageElements = new IntMap();
        _errorPageElements.put("error-code", 1);
        _errorPageElements.put("exception-type", 1);
        _errorPageElements.put("location", 1);
        _filterMapElements = new IntMap();
        _filterMapElements.put("icon", 1);
        _filterMapElements.put("filter-name", 1);
        _filterMapElements.put("display-name", 1);
        _filterMapElements.put("description", 1);
        _filterMapElements.put("filter-class", 1);
        _filterMapElements.put("init-param", 1);
        _filterMapElements.put("url-pattern", 1);
        _filterMapElements.put("url-regexp", 1);
        _filterMapElements.put("servlet-name", 1);
        _filterMapElements.put("init", 1);
        _filterMapElements.put("case-sensitive", 1);
    }

    public class AppVar {
        public String getUrl() {
            return Application.this.getURL();
        }

        public String getName() {
            return Application.this.getContextPath();
        }

        public String getContextPath() {
            return Application.this.getContextPath();
        }

        public Path getDocDir() {
            return Application.this.getDocPath();
        }

        public String toString() {
            return Application.this.toString();
        }
    }

    class AppAlarm {
        int _start;
        int _stop;
        int _period;
        Invocation _invocation;
        String _queryString;

        AppAlarm(Invocation invocation, String queryString, int start, int stop, int period) {
            this._invocation = invocation;
            this._queryString = queryString;
            this._start = start;
            this._stop = stop;
            this._period = period;
        }
    }

    static class NullEnum
    implements Enumeration {
        NullEnum() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }
}

