/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.Invocation;
import com.caucho.server.http.Response;
import com.caucho.server.http.ServletServer;
import com.caucho.server.http.VirtualHost;
import com.caucho.util.Alarm;
import com.caucho.util.CacheListener;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.QDate;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;

class CacheInvocation
extends Invocation
implements CacheListener {
    static WriteStream dbg = LogStream.open("/caucho.com/http/cache");
    static long DEFAULT_EXPIRES = 5000L;
    private static QDate _calendar = new QDate();
    Path _cacheRoot;
    boolean _isCacheable = true;
    long _lastCacheCheck;
    CacheEntry _entry;
    Thread _cacheThread = null;
    WriteStream _cacheStream = null;

    CacheInvocation(VirtualHost host, byte[] rawUri, int uriLength, boolean isDispatch, boolean decodeUrl, boolean isSubrequest) throws IOException {
        super(host, rawUri, uriLength, isDispatch, decodeUrl, isSubrequest);
        this._cacheRoot = host.getServer().getCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void service(AbstractRequest req, CauchoResponse response) throws IOException, ServletException {
        if (!(response instanceof Response)) {
            super.service(req, response);
            return;
        }
        req.invocation = this;
        Response res = (Response)response;
        if (this._entry != null && this.useCache(req, res)) {
            return;
        }
        if (req == res.getOriginalRequest() && (this._isCacheable || Alarm.getCurrentTime() > this._lastCacheCheck + 60000L)) {
            res.setCacheInvocation(this);
        }
        Thread currentThread = Thread.currentThread();
        try {
            super.service(req, res);
            if (this._cacheThread == currentThread) {
                res.finish(false);
            }
        }
        finally {
            if (this._cacheThread == currentThread) {
                this.finishCaching(false);
            }
        }
    }

    boolean useCache(AbstractRequest req, Response res) throws IOException, ServletException {
        CacheEntry entry = this._entry;
        Application application = this._application;
        if (entry == null || !entry._isValid) {
            return false;
        }
        boolean varyCookies = entry._varyCookies;
        String varyCookie = entry._varyCookie;
        if (entry._varyCookies && (varyCookie != null && req.getCookie(varyCookie) != null || varyCookie == null && req.getHeader("Cookie") != null)) {
            return false;
        }
        if (!this._application.isModified() && entry._expireDate >= req.getDate() && this.fillFromCache(req, res, entry, true)) {
            return true;
        }
        if (entry._hasExpires || !entry._isValid) {
            return false;
        }
        String oldIfMatch = null;
        if (entry._etag != null) {
            oldIfMatch = req.getHeader("If-None-Match");
            req.setHeader("If-None-Match", entry._etag);
            if (oldIfMatch != null) {
                int p = oldIfMatch.indexOf(59);
                if (p > 0) {
                    oldIfMatch = oldIfMatch.substring(0, p);
                }
                if (req.isTop() && oldIfMatch.equals(entry._etag)) {
                    res.setTopCache(true);
                }
            }
        }
        String oldIfModifiedSince = null;
        if (entry._lastModified != null) {
            oldIfModifiedSince = req.getHeader("If-Modified-Since");
            req.setHeader("If-Modified-Since", entry._lastModified);
            if (oldIfModifiedSince != null) {
                int p = oldIfModifiedSince.indexOf(59);
                if (p > 0) {
                    oldIfModifiedSince = oldIfModifiedSince.substring(0, p);
                }
                if (req.isTop() && oldIfModifiedSince.equals(entry._lastModified)) {
                    res.setTopCache(true);
                }
            }
        }
        res.setCacheEntry(entry);
        return false;
    }

    boolean fillFromCache(AbstractRequest req, Response response, CacheEntry entry, boolean isTop) throws IOException {
        if (!entry._isValid) {
            return false;
        }
        try {
            response.reset();
        }
        catch (Throwable e) {
            return false;
        }
        response.disableCaching(true);
        boolean notModified = false;
        if (isTop) {
            int i;
            String key;
            if (entry._etag != null && (key = req.getHeader("if-none-match")) != null) {
                i = key.indexOf(59);
                if (i >= 0) {
                    key = key.substring(0, i);
                }
                if (key != null && key.equals(entry._etag)) {
                    response.setHeader("ETag", entry._etag);
                    if (entry._lastModified != null) {
                        response.setHeader("Last-Modified", entry._lastModified);
                    }
                    response.setStatus(304);
                    notModified = true;
                }
            }
            if (!notModified && entry._lastModified != null) {
                key = req.getHeader("if-modified-since");
                int n = i = key != null ? key.indexOf(59) : 0;
                if (i > 0) {
                    key = key.substring(0, i);
                }
                if (key != null && key.equals(entry._lastModified)) {
                    if (entry._etag != null) {
                        response.setHeader("ETag", entry._etag);
                    }
                    response.setHeader("Last-Modified", entry._lastModified);
                    response.setStatus(304);
                    notModified = true;
                }
            }
        }
        if (dbg.canWrite()) {
            if (notModified) {
                dbg.log("not-modified: " + this._uri + "?" + this._queryString);
            } else {
                dbg.log("using cache: " + this._uri + "?" + this._queryString);
            }
        }
        if (notModified) {
            if (entry._expiresTime > 0L) {
                response.setDateHeader("Expires", req.getDate() + entry._expiresTime);
            }
            return true;
        }
        if (entry._contentType != null) {
            response.setContentType(entry._contentType);
        }
        ArrayList headerKeys = entry._headerKeys;
        ArrayList headerValues = entry._headerValues;
        for (int i = 0; headerKeys != null && i < headerKeys.size(); ++i) {
            response.addHeader((String)headerKeys.get(i), (String)headerValues.get(i));
        }
        if (entry._varyCookies) {
            response.setNoCache(true);
        } else if (entry._expiresTime > 0L) {
            response.setDateHeader("Expires", req.getDate() + entry._expiresTime);
        } else if (entry._expireDate > 0L) {
            response.setDateHeader("Expires", entry._expireDate);
        }
        CharSegment cb = req.getMethodBuffer();
        if (cb != null && cb.matches("HEAD")) {
            response.setContentLength((int)entry._contentLength);
            return true;
        }
        Path path = entry._cache;
        if (path == null) {
            return false;
        }
        try {
            String range = req.getHeader("Range");
            if (range != null && this.handleRange(req, response, entry, path, range)) {
                return true;
            }
            response.setContentLength((int)entry._contentLength);
            path.writeToStream(response.getStream());
        }
        catch (ClientDisconnectException e) {
            throw e;
        }
        catch (IOException e) {
            dbg.log(e);
            entry._isValid = false;
            try {
                response.reset();
            }
            catch (Exception e1) {
                dbg.log(e);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRange(AbstractRequest req, Response res, CacheEntry cache, Path path, String range) throws IOException {
        ServletOutputStream os;
        block15: {
            int off;
            int length = range.length();
            if (length < 7 || !range.startsWith("bytes=")) {
                return false;
            }
            boolean hasFirst = false;
            long first = 0L;
            boolean hasLast = false;
            long last = 0L;
            int ch = -1;
            for (off = 6; off < length; ++off) {
                char c = range.charAt(off);
                ch = c;
                if (c < '0' || ch > 57) break;
                first = 10L * first + (long)ch - 48L;
                hasFirst = true;
            }
            if (ch != 45) {
                return false;
            }
            ++off;
            while (off < length) {
                char c = range.charAt(off);
                ch = c;
                if (c < '0' || ch > 57) break;
                last = 10L * last + (long)ch - 48L;
                hasLast = true;
                ++off;
            }
            while (off < length) {
                char c = range.charAt(off);
                ch = c;
                if (c != ' ') break;
                ++off;
            }
            if (off < length) {
                return false;
            }
            if (!hasLast) {
                last = cache._contentLength - 1L;
            }
            if (!hasFirst) {
                first = cache._contentLength - last;
                last = cache._contentLength - 1L;
            }
            if (first > last) {
                return false;
            }
            if (last >= cache._contentLength) {
                return false;
            }
            res.setStatus(206);
            res.setContentLength((int)(last - first + 1L));
            CharBuffer cb = CharBuffer.allocate();
            cb.append("bytes ");
            cb.append(first);
            cb.append('-');
            cb.append(last);
            cb.append('/');
            cb.append(cache._contentLength);
            res.setHeader("Content-Range", cb.close());
            ReadStream is = null;
            os = null;
            try {
                is = path.openRead();
                is.skip(first);
                os = res.getOutputStream();
                is.writeToStream((OutputStream)os, (int)(last - first + 1L));
                Object var19_16 = null;
                if (is == null) break block15;
            }
            catch (Throwable throwable) {
                Object var19_17 = null;
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                throw throwable;
            }
            is.close();
        }
        if (os != null) {
            os.close();
        }
        return true;
    }

    boolean isCacheable() {
        return this._isCacheable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WriteStream startCaching(AbstractRequest req, Response res, ArrayList keys, ArrayList values, String contentType, String charEncoding, long contentLength) {
        String etag;
        String lastModified;
        long now = Alarm.getCurrentTime();
        CacheInvocation cacheInvocation = this;
        synchronized (cacheInvocation) {
            if (!this._isCacheable && now < this._lastCacheCheck + 60000L || this._cacheThread != null) {
                return null;
            }
            this._cacheThread = Thread.currentThread();
        }
        CacheEntry oldEntry = this._entry;
        boolean killCache = false;
        if (!"GET".equals(req.getMethod())) {
            if ("HEAD".equals(req.getMethod())) {
                this._cacheThread = null;
                return null;
            }
            killCache = true;
        } else if ((long)req.getApplication().getCacheMaxLength() < contentLength) {
            killCache = true;
        } else if (res.getHeader("Vary") != null) {
            killCache = true;
        } else if (res.isNoCache()) {
            killCache = true;
        }
        this._lastCacheCheck = now;
        CacheEntry entry = new CacheEntry();
        boolean anonymousCaching = false;
        boolean hasCacheControl = false;
        long internalCacheTimeout = 5000L;
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = (String)values.get(i);
            if (!key.equalsIgnoreCase("cache-control")) continue;
            if (value.equals("public")) {
                hasCacheControl = true;
                continue;
            }
            if (value.equals("must-revalidate") || value.equals("proxy-revalidate")) {
                internalCacheTimeout = -1L;
                continue;
            }
            if (value.equals("x-anonymous")) {
                anonymousCaching = true;
                keys.remove(i);
                values.remove(i);
                --i;
                continue;
            }
            hasCacheControl = true;
            killCache = true;
        }
        if (killCache) {
            this._isCacheable = false;
            this._entry = null;
            this._cacheThread = null;
            if (oldEntry != null) {
                oldEntry.remove();
            }
            return null;
        }
        if (anonymousCaching) {
            entry._varyCookies = req.getVaryCookies();
            entry._varyCookie = req.getVaryCookie();
            if (req.getHasCookie()) {
                if (!hasCacheControl) {
                    res.setPrivateCache(true);
                }
                this._cacheThread = null;
                return null;
            }
        }
        long expireDate = -1L;
        String expires = res.getHeader("Expires");
        if (expires != null) {
            QDate qDate = _calendar;
            synchronized (qDate) {
                try {
                    expireDate = _calendar.parseDate(expires);
                    entry._hasExpires = true;
                    entry._expireDate = expireDate;
                    if (expireDate < req.getDate()) {
                        this._isCacheable = false;
                        this._entry = null;
                        this._cacheThread = null;
                        if (oldEntry != null) {
                            oldEntry.remove();
                        }
                        return null;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        entry._expireDate = expireDate;
        entry._lastModified = lastModified = res.getHeader("Last-Modified");
        entry._etag = etag = res.getHeader("ETag");
        if (expireDate == -1L && (etag != null || lastModified != null)) {
            if (entry._expiresTime <= 0L) {
                Application app = req.getApplication();
                if (app != null && this._uri != null) {
                    entry._expiresTime = app.getCacheTime(this._uri);
                }
                if (entry._expiresTime > 0L && entry._expiresTime < DEFAULT_EXPIRES) {
                    entry._expiresTime = DEFAULT_EXPIRES;
                }
            }
            if (entry._expiresTime > 0L && !req.getVaryCookies()) {
                res.setDateHeader("Expires", req.getDate() + entry._expiresTime);
            }
            entry._expireDate = req.getDate() + internalCacheTimeout;
        }
        if (entry._expireDate - 1000L < req.getDate() && entry._lastModified == null && entry._etag == null) {
            this._isCacheable = false;
            this._entry = null;
            if (oldEntry != null) {
                oldEntry.remove();
            }
            this._cacheThread = null;
            return null;
        }
        if (entry._varyCookies) {
            res.setNoCache(true);
        }
        entry._headerKeys = new ArrayList();
        entry._headerValues = new ArrayList();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            if (key.equalsIgnoreCase("expires") || key.equalsIgnoreCase("set-cookie")) continue;
            entry._headerKeys.add(key);
            entry._headerValues.add(values.get(i));
        }
        if (contentType != null) {
            entry._contentType = contentType;
        } else if (charEncoding != null) {
            entry._contentType = "text/html; charset=" + charEncoding;
        }
        try {
            int dirIndex = (int)(Math.random() * 32.0);
            Path dir = this._cacheRoot.lookup(ServletServer._cacheDirNames[dirIndex]);
            entry._cache = dir.createTempFile("res", "");
            this._cacheStream = entry._cache.openWrite();
            this._isCacheable = true;
            this._entry = entry;
            if (oldEntry != null) {
                oldEntry.remove();
            }
            return this._cacheStream;
        }
        catch (IOException e) {
            dbg.log(e);
            this._cacheThread = null;
            return null;
        }
    }

    void killCache() {
        this._isCacheable = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishCaching(boolean okay) {
        if (Thread.currentThread() != this._cacheThread) {
            return;
        }
        CacheEntry entry = this._entry;
        try {
            try {
                WriteStream os = this._cacheStream;
                this._cacheStream = null;
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                dbg.log(e);
                okay = false;
            }
            if (entry == null) {
                okay = false;
            } else if (!okay) {
                this._entry = null;
                entry.remove();
            }
            Object var5_5 = null;
            if (entry != null) {
                Path path;
                if (okay && (path = entry._cache) != null) {
                    entry._contentLength = path.getLength();
                    entry._isValid = true;
                } else {
                    this._entry = null;
                }
            }
            this._cacheThread = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (entry != null) {
                Path path;
                if (okay && (path = entry._cache) != null) {
                    entry._contentLength = path.getLength();
                    entry._isValid = true;
                } else {
                    this._entry = null;
                }
            }
            this._cacheThread = null;
            throw throwable;
        }
        if (dbg.canWrite() && entry != null) {
            this.logCache(entry);
        }
    }

    public void removeEvent() {
        if (this._entry != null) {
            CacheEntry entry = this._entry;
            this._entry = null;
            WriteStream os = this._cacheStream;
            this._cacheStream = null;
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (entry != null) {
                entry.remove();
            }
            if (dbg.canWrite()) {
                dbg.log("lru removing cache: " + this._uri + "?" + this._queryString);
            }
        }
    }

    private void logCache(CacheEntry entry) {
        CharBuffer extra = CharBuffer.allocate();
        if (entry._varyCookies) {
            extra.append(" anonymous");
            if (entry._varyCookie != null) {
                extra.append("(");
                extra.append(entry._varyCookie);
                extra.append(")");
            }
        }
        if (entry._etag != null) {
            extra.append(" etag=");
            extra.append(entry._etag);
        } else if (entry._lastModified != null) {
            extra.append(" last-modified=");
            extra.append(entry._lastModified);
        } else if (entry._expireDate > Alarm.getCurrentTime()) {
            extra.append(" expires=");
            extra.append(QDate.format(entry._expireDate));
        }
        if (entry._isValid && entry._cache != null) {
            long length = entry._cache.getLength();
            extra.append(" length=" + length);
        }
        if (entry != null) {
            dbg.log("caching: " + this._uri + "?" + this._queryString + extra.close());
        } else {
            dbg.log("removing cache: " + this._uri + "?" + this._queryString + extra.close());
        }
    }

    public static class CacheEntry {
        CacheInvocation _invocation;
        Path _cache;
        ArrayList _headerKeys;
        ArrayList _headerValues;
        String _contentType;
        String _etag;
        String _lastModified;
        long _contentLength;
        boolean _varyCookies;
        String _varyCookie;
        long _expireDate;
        long _expiresTime;
        boolean _hasExpires;
        boolean _isValid;

        void updateExpiresDate() {
            this._expireDate = Alarm.getCurrentTime() + 5000L;
        }

        void remove() {
            this._isValid = false;
            try {
                if (this._cache != null) {
                    Path path = this._cache;
                    this._cache = null;
                    path.remove();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

